/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"
#include <math.h>

/** Update livewalls. This function updates the livewalls by making them move, moving the players on them, changing their size, adjusting their non-integer coordinates, handling their zignals.
@return Returns always 0.
@see move_livewl_with_players()
@see update_livewall_size()
@see livewall_adj_coord()
@see handle_lwall_zignals()
*/
int make_livewalls()
{
int y;
livewall * lwrot = obj_db.livewall_head;

while(lwrot)
        {

        if(!(lwrot->parms & LWL_NOMOVE))
                {
                /*we move the livewall and the players on it*/
                if(lwrot->speed & ZL_DIVIDE_SPD)
                        {
                        if(cyclediv_check(&lwrot->speed, &lwrot->idling_for))
                                {
                                move_livewl_with_players(lwrot);
                                }
                        }
                        
                else{
                        for(y=0; y < lwrot->speed; y++)
                                move_livewl_with_players(lwrot);
                        }
                   
                }
        /*size variation*/
        if(lwrot->parms & LWL_SIZE_VAR)
                { /*if the size has to be changed*/
                update_livewall_size(lwrot);
                }
            
        /*coord. adjusting*/
        livewall_adj_coord(lwrot);
        handle_lwall_zignals(lwrot);
	lwrot = GETNEXT(lwrot);
        }

return 0;
}
  
/** Blocks the movement of a livewall for some time.
@param counter is the time counter updated by the scheduler
@param lwlnb is the number of the livewall to be stopped
@param parm is not used by this function
@see pf_pause_invert()
*/  
void block_pf_move(int counter,  int parm, void * pparm)
{
parm = 0;
livewall * target = (livewall *)pparm;
if(counter == 1)
    {
    target->state&=~LWL_PAUSE_MVT;
    move_livewl_with_players(target);
    }

}
    
    
/** Pauses a livewall and inverts its direction. It uses block_pf_move with the scheduler.
@param lwlnb is the number of the livewall
@see block_pf_move()
@see add_scheduler_fnct()
*/    
 int pf_pause_invert(livewall * target)
{
if(target -> state & LWL_PAUSE_MVT)
        return 1;
add_scheduler_fnct(block_pf_move, 0, target, 150, "block liveplatform movement");
target->dx=0;
target->dy=0;
target->state|=LWL_PAUSE_MVT;

if(target->parms & LWL_INVERT_CONTACT)
{
        if(target->state & DIRECTION)
            target->state&=~DIRECTION;
        else
            target->state|=DIRECTION;
}

return 0;
}
    
/** Move a livewall and all the players standing on it
@return Returns always 0.
*/
int move_livewl_with_players(livewall * targetlw)
{
float inert_to_set; /*l'inertie qui sera donne aux players*/
liveplayer * playerlist[15];
for(int i = 0; i < 15; i ++) playerlist[i] = (liveplayer *)(0xdeadbeef);

if(targetlw->state & LWL_PAUSE_MVT)
    {
    return 0;
    }

/*calculate the inertia to apply*/
if(targetlw->speed & ZL_DIVIDE_SPD)
	{ /*in case the real speed is inverted*/
	inert_to_set = 1 / ((float)targetlw->speed - ZL_DIVIDE_SPD);
	}
else
	inert_to_set = targetlw->speed;

/*make up the list of players to move*/
int pli = -1;
liveplayer * plrot;
for(int i = 0; i <2; i++)
	{
	if(!i) plrot = obj_db.liveplayer_head;
	else plrot = obj_db.enemy_head;
		
	while(plrot)
		{
		if(pli > 13)
			break;
		if(plrot->ref_pform == targetlw)
			{
			pli ++;
			playerlist[pli] = plrot;
			}
		plrot = GETNEXT(plrot);
		}
	}
				
/*move the livewall*/
switch(targetlw->dx)
	{
	case 1 : lwl_move_right(targetlw, 1); break;
	case -1 : lwl_move_left(targetlw, 1); break;
	}
switch(targetlw->dy)
	{
	case 1 : lwl_move_down(targetlw, 1); break;
	case -1 : lwl_move_up(targetlw, 1); break;
	}
	


for(; pli >= 0; pli --)
	{
	/*move the player*/
	plrot = playerlist[pli];
	/*if(plrot == NULL) break;*/
	switch(targetlw->dx)
				{
				case 1 :	if ((plrot->current_spd.x <= 0) || (plrot->current_spd.x < inert_to_set))
					{ /*si vitesse nulle ou oppose ou infrieure  vitesse lwl*/
					plrot->current_spd.x = inert_to_set;
					} break;
				case -1: if ((plrot->current_spd.x >= 0) || (plrot->current_spd.x > - inert_to_set))
					{ /*si vitesse nulle ou oppose ou infrieure  vitesse lwl*/
					plrot->current_spd.x = -inert_to_set;
					} break;
				}
			
	switch(targetlw->dy)
				{
				case 1: pl_move_down(plrot, 1); break;
				case -1: pl_move_up(plrot, 1); break;
				}
	}
	
/*then we calculate the next dx/dy*/
if(targetlw->mvt_ysize)
    { /*vertical movement*/
    
    if(!(targetlw->state & DIRECTION))
        { /*if we go to the final refpt*/
        if(targetlw->refpt.y <= (targetlw->base_mvt.y + targetlw->mvt_ysize))
            { /*if the current refpoint is still less than the final refpoint we wanna get to*/
            targetlw->dy=1;
            targetlw->dx=0;
            }
    
        else { /*if we reached that refpoint*/
            targetlw->dy=-1;
            targetlw->dx=0;
            targetlw->state|=DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 0, 0); /*the first zero stands for vertical movement, could be used later*/
            }
        }
    else { /*if we come back from final refpt*/
        if(targetlw->refpt.y > targetlw->base_mvt.y)
            {
            targetlw->dy=-1;
            targetlw->dx=0;
            }
        else { /*if we reach the basemvt point*/
            targetlw->dy=1;
            targetlw->dx=0;
            targetlw->state&=~DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 0, 1);
            }
        }
    }
     
    
if(targetlw->mvt_xsize) { /*if horizontal movement*/
    if(!(targetlw->state & DIRECTION))
        { /*if we go to the final refpt*/
        if(targetlw->refpt.x <= (targetlw->base_mvt.x + targetlw->mvt_xsize))
            { /*if the current refpoint is still less than the final refpoint we wanna get to*/
            targetlw->dx=1;
            targetlw->dy=0;
            }
    
        else { /*if we reached that refpoint*/
            targetlw->dx=-1;
            targetlw->dy=0;
            targetlw->state|=DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 1, 0);
            }
        }
    else { /*if we are coming back from final refpt*/
        if(targetlw->refpt.x > targetlw->base_mvt.x)
            {
            targetlw->dx=-1;
            targetlw->dy=0;
            }
        else { /*if we reach the basemvt point*/
            targetlw->dx=1;
            targetlw->dy=0;
            targetlw->state&=~DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 1, 1);
            }
        }
    }

return 0;
}


/** Update the size of a livewall
@param lwlnb is the number of the livewall
@return Returns always 0.
*/
int update_livewall_size(livewall * target)
{
        short int xvar=0, yvar=0;
        float real_xvar=0, real_yvar=0;
        colldet();
        if((! target->sizevarspd.x) && (! target->sizevarspd.y))
                return 0;
	
        if(target->sizevarspd.x)
        { /*calculate x size variation*/
                real_xvar = target->sizevarspd.x * (target-> max_size.x - target->min_size.x);
                if(!(target->state & LWL_SZVAR_X))
                        real_xvar = -real_xvar;
                xvar = rintf(real_xvar); /*actual variation*/ 
                if(xvar < 0 && abs(xvar) > target->xsize)
                        xvar = - target->xsize;
        }
	
        if(target->sizevarspd.y)
        { /*see comments above*/
                real_yvar = target->sizevarspd.y * (target-> max_size.y - target->min_size.y);
                if(!(target->state & LWL_SZVAR_X))
                        real_yvar = -real_yvar;
                yvar = rintf(real_yvar);
	}
        
        if( (!(target-> state & NO_LEFT)) && (!(target->state & NO_RIGHT)))
        {
                target->xsize += xvar; /*xsize varies*/
                if(! target->xsize)
                        target->size_add_x += 0;
                else
                        {
                        target->size_add_x += real_xvar - xvar; /*decimal variation*/
                        target->refpt.x -= rintf(real_xvar/2);
                        target->add_x -= (real_xvar/2) - rintf(real_xvar/2);
                        }
                colldet();
        }
	
        if(target->xsize >= target->max_size.x)
        {
                target->state &= ~LWL_SZVAR_X;
                target->xsize = target->max_size.x;
        }
	
        if(target->xsize <= target->min_size.x)
        {
                target->state |= LWL_SZVAR_X;
                target->xsize = target->min_size.x;
                if(target->min_size.x == 0)
                                { /*we just disappear FIXME : ??!!!*/
                                target->parms &= ~LWL_SIZE_VAR;
                                add_scheduler_fnct(alarm_zignal, LWLEFFECTOR_SZVAR_REAPPEAR, &target->zignals, 150, "alarm for lwall reappearing (to be further checked)");
                                }
        }
       
       if( (!(target ->state & NO_DOWN)) && (!(target->state & NO_UP)))
       {
               target->ysize += yvar; /*ysize varies*/
               target->size_add_y += real_yvar - yvar;
               colldet();
       }

        if(target->ysize >= target->max_size.y)
        {
                target->state &= ~LWL_SZVAR_Y;
                target->ysize = target->max_size.y;
        }
        if(target->ysize <= target->min_size.y)
        {
                target->state |= LWL_SZVAR_Y;
                target->ysize = target->min_size.y;
        }
        
        
        /*now compute decimal variation adjustment*/
        if(target->size_add_x >= 0.5)
	{
                target->xsize ++;
                target->size_add_x -= 1;
	}
        if(target->size_add_x <= -0.5)
	{
                target->xsize --;
                target->size_add_x += 1;
	}
	
        if(target->size_add_y >= 0.5)
	{
                target->ysize ++;
                target->size_add_y -= 1;
	}
        if(target->size_add_y <= -0.5)
	{
                target->ysize --;
                target->size_add_y += 1;
	}
        
        /*now center the players (if needed and if any)*/
        if(target->parms & LWL_CENTER_PL && (!(target->state & LWL_SZVAR_X)))
        {
                int i;
		liveplayer * plrot;
		for (i=0; i < 2; i++)
			{
			if(!i) plrot = obj_db.liveplayer_head;
			else plrot = obj_db.enemy_head;
			
			while(plrot)
				{
                                if((plrot->ref_pform == target) && plrot->state & ZL_PLAYER_IDLE)
					{ /*then the player is on the livewall*/
					center_player(plrot, target);
					}
				plrot = GETNEXT(plrot);
				}
			}
        }
return 0;
}

/** Round coordinates of a livewall to integers
@return Returns 0 if nothing was to do, 1 if some changes occured.
*/
int livewall_adj_coord(livewall * target)
{
        if(target->add_x >= 0.5)
	{
                if ( !(target->state & NO_RIGHT))
                target->refpt.x++;
                colldet();
                target->add_x-=1;
                return 1;
	}
        if(target->add_x <= -0.5)
	{
                if ( !(target->state & NO_LEFT))
                target->refpt.x--;
                colldet();
                target->add_x+=1;
                return 1;
	}
	
        if(target->add_y >= 0.5)
	{
                if ( !(target->state & NO_DOWN))
                lwl_move_down(target, 1);
                target->add_y-=1;
                return 1;
	}
        if(target->add_y <= -0.5)
	{
                if ( !(target->state & NO_UP))
                lwl_move_up(target, 1);
                target->add_y+=1;
                return 1;
	}
return 0;
}

/** Center a player standing on a livewall
@return  Returns always 0.
*/
int center_player(liveplayer * target, livewall * ref)
{
        int i;
        
       int target_cx = target->refpt.x - ref->refpt.x + target->xsize / 2;
       
        /*si le player dpasse sur la gauche de plus la moiti de sa largeur*/
        if(target_cx < 0)
        {
                for(i=0; i < - target_cx; i ++)
                {
                        if ( !(target->state & NO_RIGHT))
                                target->refpt.x++;
                        colldet();
                }
                return 0;
        }
        
        target_cx = (target->refpt.x + target->xsize) - (ref->refpt.x + ref->xsize);
        
        if( target_cx > target->xsize/2)
        {
                        if ( !(target->state & NO_LEFT))
                                target->refpt.x--;
                        colldet();
        }
        
return 0;
}
