/*


Copyright (c) 2004 Arthur Huillet.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



#ifndef LOG_FAC_H
#define LOG_FAC_H
#include <stdarg.h>
#include <stdio.h>


#define LOG_ERROR 0
#define LOG_NORMAL 1
#define LOG_VERBOSE 2
#define LOG_DEBUG 3

#define LOGTO_STDERR 0
#define LOGTO_STDOUT 1
#define LOGTO_DEVNULL 2
#define LOGTO_FILE 3


/*
message_handler struct : */

typedef struct{
unsigned short int debuglvl; 
unsigned short int rule_num;
int log_action;
int filedest;
} message_hdl;

message_hdl *msg_hdl;


int init_logfac();
int exit_logfac();

int add_rule(message_hdl);

int del_rule(int); /*deletes the rule identified by int rulenb*/

int retr_rule_str(int, char *); /*returns a string defining the current rule*/



int get_hdl_nb();

int realloue_msg_hdl(); /*reallocates memory returns number of allocated bytes
-1 on error
*/

/*open_newlog(lognb (0 or 1), path); returns lognb*/
int open_newlog(const char *);

/*closes log*/
int close_log(int);



int log_msg(unsigned short int,  const char *, ...);
/*from cmdline.c*/
char ** cut_to_argv(char * s, int * argc);

#ifdef _WIN32
#ifdef USE_W32_CSL
void Q3_AppendText( const char *msg );
void Q3_FatalError( const char *error, ... );
void Q3_DestroyConsole( void );
int Handle_Q3_Lock();
#endif
#endif
#endif


