/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"


static char * object_options[30];
static int portal_uniqueID = 0;

/** Open a level file for reading
@param lvlfile is the path to the file to open.
@return Returns -1 on error, 0 otherwise.
@see close_lvl_file()
*/
int open_lvl_file(const char *lvlfile)
{
level_xml_file = fopen(lvlfile,"r");
if(level_xml_file == NULL)
    return -1;
return 0;
}

/** Close the current levelfile
@return Returns always 0.
@see open_lvl_file()
*/
int close_lvl_file()
{
fclose(level_xml_file);
return 0;
}

/** Fill in the data structures by reading the levelfile. This is the second part of the reading of a level.
@return Returns always 0.
@see register_level_objects()
*/
int parse_level_data()
{
liveplayer *PlToRegister;
wall *WlToRegister;
livewall * lWlToRegister;
killing_line * KlToRegister;
portal * PortalToRegister;
banana * BananaToRegister;
int done = 0;
int GetLineState;
char *TempLine;
TempLine = (char *)calloc(1, 5000);
PlToRegister = (liveplayer *)calloc(1, sizeof(liveplayer));
WlToRegister = (wall *)calloc(1, sizeof(wall));
lWlToRegister = (livewall *)calloc(1, sizeof(livewall));
KlToRegister = (killing_line*)calloc(1, sizeof(killing_line));
PortalToRegister = (portal *)calloc(1, sizeof(portal));
BananaToRegister = (banana *)calloc(1, sizeof(banana));
GetLineState = get_level_line(TempLine);
while(!done)
{
    
    
    if(strstr(TempLine,"fileinfo"))
        {
        log_msg(3, "Parsing and displaying fileinfo from line %s", TempLine);
        display_level_info(TempLine);
        }

    if(strstr(TempLine,"<player") || strstr(TempLine, "<liveplayer"))
        {
	int isfirst = 0;
	if(!obj_db.liveplayer_head)
		{
		isfirst = 1;
		log_msg(3, "Main player found.");
		}
        return_player(TempLine, PlToRegister, ZL_PLAYER_HUMAN); /*on rcupre les infos sur lui*/
	obj_db.liveplayer_head = add_player_to_database(obj_db.liveplayer_head, PlToRegister);
	//if(isfirst) cur_player = obj_db.liveplayer_head;
        }
        
    if(strstr(TempLine,"<enemy"))
        {       
        return_player(TempLine, PlToRegister, ZL_PLAYER_ENNEMY); /*on rcupre les infos sur lui*/
	obj_db.enemy_head = add_player_to_database(obj_db.enemy_head, PlToRegister);
        }
        
    if(strstr(TempLine,"<wall"))
        {
        return_wall(TempLine, WlToRegister);
	obj_db.wall_head = add_wall_to_database(obj_db.wall_head, WlToRegister);
	}
     
    if(strstr(TempLine,"<kline") || strstr(TempLine, "<killing_line"))
    	{	
    	return_kl(TempLine, KlToRegister);
	obj_db.killing_line_head = add_killing_line_to_database(obj_db.killing_line_head, KlToRegister);
    	}

    if(strstr(TempLine,"<platform") || strstr(TempLine, "<livewall"))
        {
	return_lwall(TempLine, lWlToRegister);
	obj_db.livewall_head = add_livewall_to_database(obj_db.livewall_head, lWlToRegister);
        }

    if(strstr(TempLine, "<madmaker"))
	{
	register_madmaker(TempLine);
	}
	
    if(strstr(TempLine, "<portal"))
	{
	return_portal(TempLine, PortalToRegister);
	obj_db.portal_head = add_portal_to_database(obj_db.portal_head, PortalToRegister);
	}
   
    if(strstr(TempLine, "<banana"))
	{
	return_banana(TempLine, BananaToRegister);
	obj_db.banana_head = add_banana_to_database(obj_db.banana_head, BananaToRegister);
	}
	
    if(strstr(TempLine, "<music"))
	{
	char * temp = strstr(TempLine, "<music") + 7;
	temp[strlen(temp) - 1] = 0;
	music = load_midi(temp);
	if(music == NULL)
		log_msg(0, "Error loading midi file %s", temp);
	}
		
    GetLineState=get_level_line(TempLine);
    
    if(strstr(TempLine,"EndOfFile")|| GetLineState)
        {
        done=1;
        }
}
    
    
free(TempLine);
free(PlToRegister);
free(WlToRegister);
free(lWlToRegister);
free(KlToRegister);
free(PortalToRegister);
return 0;
}

/** Display the informations related to the levelfile. 
*/
int display_level_info(char * InfoLine)
{
char *temp2 = (char *)calloc(1, 100);
log_msg(3, "Tampon temporaire allou, appel de get_level_string()");
get_level_string(InfoLine, "version", "0", temp2);
log_msg(2,"Level file version is %s", temp2);
memset(temp2, 0, strlen(temp2));
get_level_string(InfoLine, "desc", "no description", temp2);
log_msg(2,"Level description : \n%s", temp2);
free(temp2);
return 0;
}

/** Parse player information and fill in a structure.
@param DefineLine is the line that defines the player, taken from the levelfile
@param target is a pointer to the structure where the data will be stored
@pltype is the type of the player, ie., ZL_PLAYER_ENNEMY or ZL_PLAYER_HUMAN.
*/
int return_player(char *DefineLine, liveplayer * target, char pltype)
{
char *temp2=(char *)calloc(1, 4096);
/*char temp2[4096];*/

memset(target,0,sizeof(liveplayer));
memset(temp2, 0, 4095);

get_level_string(DefineLine, "refpt.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "refpt", "0;0", temp2);
	set_refpoint(&target->refpt, temp2);
	}
else {
	target->refpt.x = atoi(temp2);
	get_level_string(DefineLine, "refpt.y", "45879444", temp2);
	target->refpt.y = atoi(temp2);
	}

memset(target->level_def, 0, 149);
strncpy(target->level_def, DefineLine, 149);
                

log_msg(3, "target->level_def %s", target->level_def);
/*valeurs entires lues dans le fichier*/
target->ysize = atoi(get_level_string(DefineLine, "ysize", "100", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "90", temp2));
target->moving_spd.x = atoi(get_level_string(DefineLine, "x_moving_spd", "3", temp2));
target->moving_spd.y = atoi(get_level_string(DefineLine, "y_moving_spd", "5", temp2));
target->life = atoi(get_level_string(DefineLine, "life", "1000", temp2));

/*valeurs relles lues*/
target->inert_max_speed_walk = atof(get_level_string(DefineLine, "max_inert_walk", "0.25", temp2));
target->inert_max_speed_run = atof(get_level_string(DefineLine, "max_inert_run", "0.5", temp2));
target->base_jumping_speed = atof(get_level_string(DefineLine, "base_jumping_speed", "5", temp2));
target->max_jumping_speed = atof(get_level_string(DefineLine, "max_jumping_speed", "10", temp2));

/*valeurs "chaine"*/
strncpy(target->name, get_level_string(DefineLine, "name", "noname", temp2), 25);
if(pltype == ZL_PLAYER_ENNEMY)
        strncpy(target->name, "Enemy", 25);
        
strncpy(target->sprset_key, get_level_string(DefineLine, "spriteset", "stdplayer", temp2), 25);
if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key)))
        {
        spriteset_db = add_spritesetdb_entry(spriteset_db, target->sprset_key, PLAYER_SPRSET);
        target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key);
        }

strncpy(target->sndset_key, get_level_string(DefineLine, "soundset", "stdplayer", temp2), 25);
if(! (target->soundset = search_soundsetdb_entry(soundset_db, target->sndset_key)))
        {
        soundset_db = add_soundsetdb_entry(soundset_db, target->sndset_key, 0);
        target->soundset = search_soundsetdb_entry(soundset_db, target->sndset_key);
        }
	
/*valeurs par dfaut*/
target->jtime = 1;
target->state &= ~ (NO_LEFT | NO_RIGHT | NO_UP | NO_DOWN);
target->used = 1;
target->ref_pform = 0;
target->moving_spd.y =  target->base_jumping_speed;

get_level_string(DefineLine, "state", "", temp2);
char *optstr;
optstr = temp2;
init_object_options(optstr);

target->state |= get_object_option("go_right", DIRECTION);
	
if(IS_GOING_LEFT(target))
	target->current_sprite = target->spriteset[SPRSET_GOING_LEFT];
else
	target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT];
        
if(pltype == ZL_PLAYER_ENNEMY)
        {
        target->effectors.armed |= PLEFFECTOR_MOVE_ENNEMY;
	target->parms |= get_object_option("clever", ZL_ENEMY_CLEVER);
        }
free(temp2);
return 0;
}




/** Parse wall information and fill in a structure.
@param DefineLine is the line that defines the wall, taken from the levelfile
@param target is a pointer to the structure where the data will be stored
*/
int return_wall(char *DefineLine, wall * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine)+1);

memset(target, 0, sizeof(wall));


get_level_string(DefineLine, "refpt.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "refpt", "0;0", temp2);
	set_refpoint(&target->refpt, temp2);
	}
else {
	target->refpt.x = atoi(temp2);
	get_level_string(DefineLine, "refpt.y", "45879444", temp2);
	target->refpt.y = atoi(temp2);
	}

/*valeurs entires*/
target->ysize = atoi(get_level_string(DefineLine, "ysize", "15", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "100", temp2));

/*valeurs relles*/
target->resist_inert = atof(get_level_string(DefineLine, "resist_inert", "0.005", temp2));

/*state*/
get_level_string(DefineLine, "state", "", temp2);
if(strstr(temp2, "invisible"))
        target->parms |= WL_IS_INVISIBLE;

/*valeurs par dfaut*/
target->state |= EXISTS;

strncpy(target->spriteset, get_level_string(DefineLine, "spriteset", "stdpform", temp2), 25);
free(temp2);
return 0;
}

int register_madmaker(char *DefineLine)
{
char *temp2=(char *)calloc(1, strlen(DefineLine)+1);
madmaker * newmad = (madmaker *)calloc(1, sizeof(madmaker));
	
/*valeurs entires*/
get_level_string(DefineLine, "refpt.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "refpt", "0;0", temp2);
	set_refpoint(&newmad->refpt, temp2);
	}
else {
	newmad->refpt.x = atoi(temp2);
	get_level_string(DefineLine, "refpt.y", "45879444", temp2);
	newmad->refpt.y = atoi(temp2);
	}
	
newmad->speed = atoi(get_level_string(DefineLine, "speed", "130", temp2));
obj_db.madmaker_head = newmad;
free(temp2);
return 0;
}

/** Parse killing line information and fill in a structure.
@param DefineLine is the line that defines the kline, taken from the levelfile
@param target is a pointer to the structure where the data will be stored
*/
int return_kl(char *DefineLine, killing_line * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target, 0, sizeof(killing_line));

get_level_string(DefineLine, "position.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "position", "0;0", temp2);
	set_refpoint(&target->position, temp2);
	}
else {
	target->position.x = atoi(temp2);
	get_level_string(DefineLine, "position.y", "45879444", temp2);
	target->position.y = atoi(temp2);
	}


target->taille = atoi(get_level_string(DefineLine, "taille", "65535", temp2));
target->to_disp = atoi(get_level_string(DefineLine, "display", "0", temp2));
target->state |= EXISTS;


free(temp2);
return 0;
}

/** Parse portal information and fill in a structure.
@param DefineLine is the line that defines the portal, taken from the levelfile
@param target is a pointer to the structure where the data will be stored
*/
int return_portal(char *DefineLine, portal * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target, 0, sizeof(portal));
get_level_string(DefineLine, "position.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "position", "0;0", temp2);
	set_refpoint(&target->position, temp2);
	}
else {
	target->position.x = atoi(temp2);
	get_level_string(DefineLine, "position.y", "45879444", temp2);
	target->position.y = atoi(temp2);
	}

target->ysize = atoi(get_level_string(DefineLine, "ysize", "100", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "50", temp2));
target->destination = atoi(get_level_string(DefineLine, "destination", "0", temp2));
target->state |= EXISTS;
target->id = atoi(get_level_string(DefineLine, "id", "0", temp2));
portal_uniqueID++;
free(temp2);
return 0;
}

int return_banana(char *DefineLine, banana * target)
{
char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);
memset(target, 0, sizeof(banana));
get_level_string(DefineLine, "refpt.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "refpt", "0;0", temp2);
	set_refpoint(&target->refpt, temp2);
	}
else {
	target->refpt.x = atoi(temp2);
	get_level_string(DefineLine, "refpt.y", "45879444", temp2);
	target->refpt.y = atoi(temp2);
	}
	
if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, "banana")))
        {
        spriteset_db = add_spritesetdb_entry(spriteset_db, "banana", BANANA_SPRSET);
        target->spriteset = search_spritesetdb_entry(spriteset_db, "banana");
        }
free(temp2);
return 0;
}

/** Parse livewall information and fill in a structure.
@param DefineLine is the line that defines the livewall, taken from the levelfile
@param target is a pointer to the structure where the data will be stored
*/
int return_lwall(char *DefineLine, livewall * target)
{
char *optstr;
char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target,0,sizeof(livewall));
memset(temp2, 0, strlen(DefineLine));
log_msg(3, "Looking for refpt in %s", DefineLine);
get_level_string(DefineLine, "refpt.x", "45879444", temp2);
if(atoi(temp2) == 45879444)
	{
	get_level_string(DefineLine, "refpt", "0;0", temp2);
	set_refpoint(&target->refpt, temp2);
	}
else {
	target->refpt.x = atoi(temp2);
	get_level_string(DefineLine, "refpt.y", "45879444", temp2);
	target->refpt.y = atoi(temp2);
	}

if(!strcmp(get_level_string(DefineLine, "mvt_base", "nothing", temp2), "nothing"))
        {
        log_msg(3, "Platform has no base_mvt defined. Setting it to %i;%i", target->refpt.x, target->refpt.y);
        target->base_mvt = target->refpt;
        }
        else
                set_refpoint(&target->base_mvt, temp2);
        
get_level_string(DefineLine, "template", "0", temp2);
if(! atoi(temp2)) /*no template*/
        target->template = 0;
if(! strcmp(temp2, "elevator"))
        set_template(target, ZL_TEMPLATE_ELEVATOR);
        
/*valeurs entires*/
target->ysize = atoi(get_level_string(DefineLine, "wl_ysize", "15", temp2));
target->xsize = atoi(get_level_string(DefineLine, "wl_xsize", "100", temp2));
target->speed = atoi(get_level_string(DefineLine, "speed", "1", temp2));
target->trigger_flagmask = atoi(get_level_string(DefineLine, "trigger_flags", "0", temp2));
target->max_size.x = atoi(get_level_string(DefineLine, "maxsize_x", "200", temp2));
target->max_size.y = atoi(get_level_string(DefineLine, "maxsize_y", "20", temp2));
target->mvt_ysize = atoi(get_level_string(DefineLine, "mvt_ysize", "300", temp2));
target->mvt_xsize = atoi(get_level_string(DefineLine, "mvt_xsize", "0", temp2));
if(target->mvt_ysize && target->mvt_xsize)
    {
    log_msg(0,"Pform %i;%i mvt_ysize %i mvt_xsize %i",target->refpt.x, target->refpt.y, target->mvt_ysize,\
        target->mvt_xsize);
    log_msg(0,"Platform at %i %i movement has both vertical and horizontal direction defined, keeping only horizontal move.", target->refpt.x, target->refpt.y);
    target->mvt_xsize = 0;
    }

/*valeurs relles*/
target->resist_inert = atof(get_level_string(DefineLine, "resist_inert", "0.005", temp2));
target->sizevarspd.x = atof(get_level_string(DefineLine, "xsizevarspd", "0.007", temp2));
target->sizevarspd.y = atof(get_level_string(DefineLine, "ysizevarspd", "0.007", temp2));
    
/*valeurs par dfaut*/
target->idling_for=0;

target->state |= EXISTS;
target->parms|=LWL_INVERT_CONTACT;
target->min_size.x = target->xsize;
target->min_size.y = target->ysize;

strncpy(target->spriteset, get_level_string(DefineLine, "spriteset", "stdpform", temp2), 25);

/*state*/
get_level_string(DefineLine, "state", "", temp2);
optstr = temp2;
init_object_options(optstr);

target->parms |= get_object_option("invisible", WL_IS_INVISIBLE);
target->parms &=  ~ get_object_option("noinvert", LWL_INVERT_CONTACT);
target->parms |= get_object_option("sizevar", LWL_SIZE_VAR);
target->parms |= get_object_option("centerpl", LWL_CENTER_PL);
target->parms |= get_object_option("nomove", LWL_NOMOVE);        
target->effectors.armed |= get_object_option("triggerflags", LWLEFFECTOR_TRIGGER_FLAG);


free(temp2);
return 0;
}

/** Set livewall default values according to the template number it is passed. Currently useless.
*/
int set_template(livewall * target, int template)
{
target->template = template;

switch(template) {
        case ZL_TEMPLATE_ELEVATOR :
                return 0;
        default : return -1;
        };
}


/** Helper function to get a string value for a parameter, from a string structured as follows : parameter="value"
@param line is the line where the string is
@param parameter is the name of the parameter to look for
@param def is the default value
@param cible is the string where to put the value
*/
char *get_level_string(const char *line, const char *parameter, char *def, char *cible)
{
	char * temp = NULL; /*temporary pointer*/
	unsigned int ipos=0, vpos=0;
	
	temp=strstr(line,parameter); /*search the parameter*/
        memset(cible, 0, strlen(cible));
	if(temp)
        { /*if we have it*/
                /*log_msg(3, "Found %s : %s", parameter, temp);*/
                ipos=0; 
                /*now go to the first "*/
                while((temp[ipos]!='"' && (ipos < strlen(line))))
			{
			ipos++;
			}
			
                if(ipos > strlen(line))
                        {
                        log_msg(0, "Unable to find \" while parsing level line %s, looking for parameter %s", line, parameter);
                        exit(255);
                        }
                ipos++;
                temp += ipos;
                /*vpos = ipos;*/
                
                /*search the second "*/
                while(temp[vpos]!='"' && (vpos < strlen(line)))
                        vpos++;
                if(vpos > strlen(line))
                        {
                        log_msg(0, "Unable to find \" while parsing level line %s, looking for parameter %s", line, parameter);
                        exit(255);
                        }
                vpos++;
                
                /*memset(cible, 0, strlen(cible));*/
                strncpy(cible, temp, vpos-1);
                return cible;
        }
else 
        {
        /*memset(cible, 0, strlen(cible)); */
        strncpy(cible, def, strlen(def));
        return cible;
        }
}

/** Read a reference point definition from a string like refpt="x;y"
@param target is a pointer to the point structure in which to put the values read
@param value is the string shown above
*/
int set_refpoint(point * target, char *value)
{
char *temp = value;
char coord[10];
unsigned int pos1=0;

memset(coord, 0, 10);

while(temp[pos1] != ';' && pos1 < strlen(value))
	pos1++;

if (pos1 >= strlen(value))
	{
	log_msg(0, "Unable to find \";\" while parsing reference point definition %s", value);
    exit(255);
	}



strncpy(coord, temp, pos1);
target->x = atoi(coord);

temp += pos1;
temp ++;

memset(coord, 0, strlen(coord));
strncpy(coord, temp, 10);
target->y = atoi(coord);
return 0;
}


/** Load a level, while the game is already running.
@param level_file is the path of the level file to load.
*/
int runtime_level_loader(char * level_file)
{
log_msg(1,"Loading a levelfile while the game is running.");


if(level_file)
    {
    if(! open_lvl_file(level_file))
        {
        log_msg(2,"Cleaning memory");
        fin_instances(1); /*1 stands for "only level-related stuff*/
        log_msg(2, "Now processing levelfile loading.");
        log_msg(3, "Parsing levelfile");
        parse_level_data();
        close_lvl_file();
	log_msg(3, "Levelfile closed...");
        log_msg(2, "Rendering platforms");
        render_platforms();
        update_liveplatforms_sprites();
        }
    else
        {
        log_msg(0, "The program was unable to load the specified levelfile %s", level_file);
        return -2;
        }
    }
return 0;
}

/** Get a useful line from a levelfile, that is, a line that starts with < and ends with >
@param target is where to put the line, it is supposed to be able to handle at least 4999 characters.
*/
int get_level_line(char * target)
{

int done=0;
int is_comment=0;
    if(!target)
	{
	log_msg(0, "Target string of get_level_line() is NULL, quitting !");
	exit(1);
	}

while(!done)
    {
    memset(target, 0, strlen(target));
    fgets(target,4999,level_xml_file);
         
               
    if(!is_comment && strstr(target,"/*"))
        is_comment=1;
        
        
    if(!is_comment)
        if(strchr(target,'<'))
           done=1;
                    
        
        
    if(is_comment==1)
        if(strstr(target,"*/"))
            is_comment=0;            
         
           
/*        target[strlen(target)-1]='\0';*/
        
    if(feof(level_xml_file))
        {
        log_msg(2,"get_level_line() : EOF reached");
/*        memset(target,0,strlen(target));*/
        return 1;
        }
    
    
    }
/*remove last \n*/
if(target[strlen(target) - 1] == '\n')
        target[strlen(target) - 1] = 0;
return 0;
}
 

/** Initialise the parsing of object parameters taken from levelfile, from a string like : state="option1,option2,option3"
@param line is the line where the string is
*/
int init_object_options(char * line)
{
int i;
/*erase the array*/
for(i=0; i < 30; i++)
        object_options[i] = NULL;

if(! strlen(line))
        return 1;
        
object_options[0] = strtok(line, " ,;:!");

for(i=1; i <29; i++)
        object_options[i] = strtok(NULL, " ,;:!");

return 0;
}


/** Tell whether an object option was set
@param option_name is the name of the option
@param if_present is the value to return if the option is present
*/
short int get_object_option(const char * option_name, short int if_present)
{
int i;

for(i = 0; i < 30; i++)
{
        if(object_options[i])
        {
              if( ! strcmp(object_options[i], option_name))
                {

                        return if_present;
                }
        }
}

return 0;
}
                                
