/*
Copyright (c) 2005    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

/** This bitfield keeps track of what physic code has to be run within the leveledit loop
*/
char lvl_physic_runmask = 0; 
#define LVL_RUN_SCHEDULER 1
#define LVL_RUN_SCROLL 2
#define LVL_RUN_UPDLWALLS 4
#define LVL_RUN_UPDENEMIES 8
#define LVL_RUN_TELEPORT 16
#define LVL_RUN_PLZIGNALS 32
#define LVL_RUN_GRAVITY 64


/** This function is used to go into normal realtime (game) mode
*/
void switchto_realtime()
{
log_msg(1, "Restoring realtime engine ...");
CLEAR_GLOBAL_STATE(LVLEDIT_MODE);
log_msg(2, "Changing loop entry points for realtime mode");
update_world = realtime_update_world;
get_input = get_keypress;
display_world = display_all;
log_msg(2, "Restoring realtime game screen");
GAMESCR_RESOL_X = zlogframe.L;
GAMESCR_RESOL_Y = zlogframe.l;
zlogframe.cadrehg.y = 0;
destroy_leveleditor_toolbox();
zl_widget_head = NULL;
if(lvledit_upper_panel[0]) destroy_bitmap(lvledit_upper_panel[0]);
if(lvledit_upper_panel[1]) destroy_bitmap(lvledit_upper_panel[1]);
lvledit_upper_panel[0] = NULL;
lvledit_upper_panel[1] = NULL;
set_clip_rect(game_frame[0], 0, 0, game_frame[0]->w - 1, game_frame[0]->h - 1);
set_clip_rect(game_frame[1], 0, 0, game_frame[1]->w - 1, game_frame[1]->h - 1);
}

/** This function is used to go into level editor mode 
*/
void switchto_leveledit()
{
log_msg(1, "Going into leveledit mode ...");
SET_GLOBAL_STATE(LVLEDIT_MODE);
log_msg(2, "Changing loop entry points for leveledit mode");
update_world = leveledit_update_world;
get_input = leveledit_get_input;
display_world = leveledit_display_all;
log_msg(2, "Setting up upper panel...");
GAMESCR_RESOL_Y -= 120;
zlogframe.cadrehg.y = 120;
lvledit_upper_panel[0] = create_sub_bitmap(game_frame[0], 0, 0, game_frame[0]->w, 120);
lvledit_upper_panel[1] = create_sub_bitmap(game_frame[1], 0, 0, game_frame[1]->w, 120);          
set_clip_rect(game_frame[0], 0, 120, game_frame[0]->w - 1, game_frame[0]->h - 1);
set_clip_rect(game_frame[1], 0, 120, game_frame[1]->w - 1, game_frame[1]->h - 1);
CLEAR_GLOBAL_STATE(LVLEDIT_TESTLEVEL);
lvl_physic_runmask = 0;
create_leveleditor_toolbox();
lveditcommand = 0;
}

/** Leveleditor world updating module : conditionnaly enabled realtime code in order to ease live testing
*/
int leveledit_update_world()
{
cycle_object_sprites();
update_liveplatforms_sprites();

if(lvl_physic_runmask & LVL_RUN_SCHEDULER)	
	scheduler();
	
if(lvl_physic_runmask & LVL_RUN_SCROLL)
	do_scroll(cur_player);  

if(lvl_physic_runmask & LVL_RUN_UPDLWALLS)
	make_livewalls();

if(lvl_physic_runmask & LVL_RUN_UPDENEMIES)
	update_enemies();

if(lvl_physic_runmask & LVL_RUN_TELEPORT)
	handle_pending_teleportation();
	
liveplayer * plrot;
for(int i = 0; i <2; i++)
	{
	if(!i) plrot = obj_db.liveplayer_head;
	else plrot = obj_db.enemy_head;
	
	while(plrot)
		{
		plrot->state |= ZL_PLAYER_IDLE;
		plrot->state &= ~ZL_SPRITE_ANIMATE;
		
		if(lvl_physic_runmask & LVL_RUN_PLZIGNALS)
			handle_player_zignals(plrot);
		
		if(lvl_physic_runmask & LVL_RUN_GRAVITY)
			{
			make_jump(plrot);
			make_inertia(plrot);
			player_adj_coord(plrot);
			}
			
		plrot = GETNEXT(plrot);
		}
	}
return 0;
}

/** Leveleditor input function
*/
int leveledit_get_input()
{
int return_code = 0;
if(TEST_GLOBAL_STATE(LVLEDIT_TESTLEVEL))
	{
	return_code = get_keypress();
	if(return_code) return(return_code);
	
	if(key[KEY_Q])
		{
		zl_gui_widget * testbtn = search_widget_id("TestBtn");
		SET_NOT_CLICKED(testbtn);
		testbtn->callback();
		}
		
	if(key[KEY_T])
	{
	if(!(lvltoggle_ispressed_flag & 128))
		{
		zl_gui_widget * tbbtn = search_widget_id("TrackbackBtn");
		SET_CLICKED(tbbtn);
		tbbtn->callback();
		}
	}
        else lvltoggle_ispressed_flag &= ~128;
		
	//char old_runmask = lvl_physic_runmask;
	if(key[KEY_1])
		{
		if(!(lvltoggle_ispressed_flag & 1))
			{
			lvltoggle_ispressed_flag |= 1;
			lvl_physic_runmask ^= 1;
			}
		}
	else lvltoggle_ispressed_flag &= ~1;
		
	if(key[KEY_2])
		{
		if(!(lvltoggle_ispressed_flag & 2))
			{
			lvltoggle_ispressed_flag |= 2;
			lvl_physic_runmask ^= 2;
			}
		}
        else lvltoggle_ispressed_flag &= ~2;

	if(key[KEY_3])
		{
		if(!(lvltoggle_ispressed_flag & 4))
			{
			lvltoggle_ispressed_flag |= 4;
			lvl_physic_runmask ^= 4;
			}
		}
        else lvltoggle_ispressed_flag &= ~4;
		
	if(key[KEY_4])
		{
		if(!(lvltoggle_ispressed_flag & 8))
			{
			lvltoggle_ispressed_flag |= 8;
			lvl_physic_runmask ^= 8;
			}
		}
        else lvltoggle_ispressed_flag &= ~8;
		
	if(key[KEY_5])
		{
		if(!(lvltoggle_ispressed_flag & 16))
			{
			lvltoggle_ispressed_flag |= 16;
			lvl_physic_runmask ^= 16;
			}
		}
        else lvltoggle_ispressed_flag &= ~16;

	if(key[KEY_6])
		{
		if(!(lvltoggle_ispressed_flag & 32))
			{
			lvltoggle_ispressed_flag |= 32;
			lvl_physic_runmask ^= 32;
			}
		}
        else lvltoggle_ispressed_flag &= ~32;

	if(key[KEY_7])
		{
		if(!(lvltoggle_ispressed_flag & 64))
			{
			lvltoggle_ispressed_flag |= 64;
			lvl_physic_runmask ^= 64;
			}
		}
        else lvltoggle_ispressed_flag &= ~64;
	}

if(!TEST_GLOBAL_STATE(LVLEDIT_TESTLEVEL))
	{
	if(key[KEY_L])
                {
                if(!(pltoggle_ispressed_flag & 16))
                        {
                        pltoggle_ispressed_flag |= 16;
			char answer = 0;
				if(!TEST_GLOBAL_STATE(LVLEDIT_MODE))
					{
					zl_screen_msgbox("Mode change", "Do you want to go into leveledit mode ?", ZL_MESSAGE_YESNOBOX, &answer);
						if(answer == 1)
								switchto_leveledit();
					}	
				else 
					{
					zl_screen_msgbox("Mode change", "Are you sure you want to leave leveledit mode ?", ZL_MESSAGE_YESNOBOX, &answer);
						if(answer == 1)
								switchto_realtime();
					}
                        }
                }
        else pltoggle_ispressed_flag &= ~16;
		

        if(key[key_quit])
                {
                return_code = ZL_QUIT;
                }
	
	if(key[KEY_T])
	{
	if(!(lvltoggle_ispressed_flag & 128))
		{
		zl_gui_widget * testbtn = search_widget_id("TestBtn");
		SET_CLICKED(testbtn);
		testbtn->callback();
		}
	}
	}
/*for(int i = 0; i < 8; i++)
	{
	if((lvl_physic_runmask & (1 << i)) != (old_runmask & (1 << i)))
		log_msg(1, "There was a change in the physics code mask : bit %i changed from %i to %i", i, (old_runmask & (1 << i)), (lvl_physic_runmask & (1 << i)));
	}*/
zl_gui_widget * cur = zl_widget_head;
unsigned int xpos = mouse_pos >> 16;
unsigned int ypos = mouse_pos & 0x0000ffff;
while(cur)
	{
	if(xpos > cur->position.x && xpos < cur->position.x + cur->size.x && ypos > cur->position.y && ypos < cur->position.y + cur->size.y)
		{
		if(!ISCLICKED(cur) && mouse_b & 1)
			{
			SET_CLICKED(cur);
			}
		if(ISCLICKED(cur) && !(mouse_b & 1))
			{
			SET_NOT_CLICKED(cur);
			if(cur->callback)
				cur->callback();
			}
		}
	cur = GETNEXT(cur);
	}


switch(lveditcommand)
	{
	case LVCMD_ADD_BANANA:
		if(ISCLICKED(search_widget_id("AddBnBtn")) && !(mouse_b &1))
			{
			banana * newb = (banana *)calloc(1, sizeof(banana));
			newb->refpt.x = xpos + obj_db.screen_pos.x;
			newb->refpt.y = ypos + obj_db.screen_pos.y;
			newb->spriteset = search_spritesetdb_entry(spriteset_db, "banana");
			obj_db.banana_head = add_banana_to_database(obj_db.banana_head, newb);
			SET_NOT_CLICKED(search_widget_id("AddBnBtn"));
			printf("<banana refpt=\"%i;%i\">\n", newb->refpt.x, newb->refpt.y);
			lveditcommand = 0;
			}
		if(!ISCLICKED(search_widget_id("AddBnBtn"))  && mouse_b & 1 && ypos > 120) SET_CLICKED(search_widget_id("AddBnBtn"));
		break;
	case LVCMD_ADD_WALL:
		if(mouse_b & 1 && ypos > 120)
			{
			wall * newb = (wall *)calloc(1, sizeof(wall));
			newb->refpt.x = xpos + obj_db.screen_pos.x;
			newb->refpt.y = ypos + obj_db.screen_pos.y;
			newb->sprite = create_bitmap(1, 20);
			newb->xsize = 1;
			newb->ysize = 15;
			clear_bitmap(newb->sprite);
			rectfill(newb->sprite, 0, 0, 1, 20, makecol(255, 0, 0));
			obj_db.wall_head = add_wall_to_database(obj_db.wall_head, newb);
			lveditcommand = LVCMD_REDIM_WALL;
			}
		break;
	case LVCMD_REDIM_WALL:
		if(!(mouse_b & 1))
			{
			printf("<wall refpt=\"%i;%i\" xsize=\"%i\">\n", obj_db.wall_head->refpt.x, obj_db.wall_head->refpt.y, obj_db.wall_head->xsize);
			lveditcommand = 0;
			}
		else {
			obj_db.wall_head->xsize = xpos - obj_db.wall_head->refpt.x + obj_db.screen_pos.x;
			//printf("%i\n", obj_db.wall_head->xsize);
			}
		break;
	};
return return_code;
}



int leveledit_display_all()
{
extern volatile int last_fps;

if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
    {
    acquire_bitmap(ecranv[page_num]);
    }
clear_bitmap(ecranv[page_num]);

display_background();
display_toolbox();
display_stats();

liveplayer * plrot = obj_db.liveplayer_head;
while(plrot)
	{
	disp_pl(plrot);
	plrot = GETNEXT(plrot);
	}

plrot = obj_db.enemy_head;
while(plrot)
	{
	disp_pl(plrot);
	plrot = GETNEXT(plrot);
	}

killing_line * klrot = obj_db.killing_line_head;
while(klrot)
	{
	disp_kline(klrot);
	klrot = GETNEXT(klrot);
	}
	
wall * wlrot = obj_db.wall_head;
while(wlrot)
	{
	disp_wall(wlrot);
	line(ecranv[page_num], wlrot->refpt.x + wlrot->xsize - obj_db.screen_pos.x, wlrot->refpt.y- obj_db.screen_pos.y, wlrot->refpt.x + wlrot->xsize - obj_db.screen_pos.x, wlrot->refpt.y + wlrot->ysize- obj_db.screen_pos.y, makecol(255,255,255));
	wlrot = GETNEXT(wlrot);
	}

livewall * lwlrot = obj_db.livewall_head;
while(lwlrot)
	{
	disp_lwall(lwlrot);
	lwlrot = GETNEXT(lwlrot);
	}

portal * ptrot = obj_db.portal_head;
while(ptrot)
	{
	disp_portal(ptrot);
	ptrot = GETNEXT(ptrot);
	}
banana * bnrot = obj_db.banana_head;
while(bnrot)
	{
	disp_banana(bnrot);
	bnrot = GETNEXT(bnrot);
	}
//display_madmaker(obj_db.madmaker_head);
display_mouse();

textprintf_ex(ecranv[page_num], font, 720, 133, -1, -1, "FPS : %i",last_fps);

display_cadre(zlogframe);

scheduler_disp();

    

if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
	release_bitmap(ecranv[page_num]);
 

if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
    {    

    if(!is_memory_bitmap(ecranv[0]))
		vsync();

    acquire_screen();
    blit(ecranv[0], screen, 0,0,0,0,RESOL_X,RESOL_Y);
    release_screen();
    }
else {
    show_video_bitmap(ecranv[page_num]);
    page_num = 1-page_num;
}

return 0;
}


int display_toolbox()
{
zl_gui_widget * cur_widget = zl_widget_head;
rectfill(lvledit_upper_panel[page_num], 0, 0, RESOL_X, 120, makecol(70, 70, 70));
if(TEST_GLOBAL_STATE(LVLEDIT_TESTLEVEL))
	{
	for(int i = 0; i < 120; i+=2)
		{
		line(lvledit_upper_panel[page_num], 0, i, RESOL_X, i, makecol(127, 127, 127));
		}
	textprintf_ex(lvledit_upper_panel[page_num], font, 1, 50, makecol(0,0,0), -1, "TESTING LEVEL");
	}
while(cur_widget)
	{
	if(cur_widget->dialogtype == ZL_WIDGET_BUTTON)
		{
		if(! ISCLICKED(cur_widget))
			{
			rectfill(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.x + cur_widget->size.x, cur_widget->position.y + cur_widget->size.y, makecol(210, 210, 210));
			hline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.x + cur_widget->size.x, makecol(180, 180, 180));
			hline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y + cur_widget->size.y, cur_widget->position.x + cur_widget->size.x, makecol(50, 50, 50));
			vline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.y + cur_widget->size.y, makecol(180, 180, 180));
			vline(lvledit_upper_panel[page_num], cur_widget->position.x + cur_widget->size.x, cur_widget->position.y, cur_widget->position.y + cur_widget->size.y, makecol(50, 50, 50));
			textprintf_centre_ex(lvledit_upper_panel[page_num], font, cur_widget->position.x + cur_widget->size.x / 2, cur_widget->position.y + cur_widget->size.y/2 - font->height / 2, makecol(0, 0, 0), -1, "%s", cur_widget->label);
			}
		else
			{
			rectfill(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.x + cur_widget->size.x, cur_widget->position.y + cur_widget->size.y, makecol(190, 190, 190));
			hline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.x + cur_widget->size.x, makecol(50, 50, 50));
			hline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y + cur_widget->size.y, cur_widget->position.x + cur_widget->size.x, makecol(180, 180, 180));
			vline(lvledit_upper_panel[page_num], cur_widget->position.x, cur_widget->position.y, cur_widget->position.y + cur_widget->size.y, makecol(50, 50, 50));
			vline(lvledit_upper_panel[page_num], cur_widget->position.x + cur_widget->size.x, cur_widget->position.y, cur_widget->position.y + cur_widget->size.y, makecol(180, 180, 180));
			textprintf_centre_ex(lvledit_upper_panel[page_num], font, cur_widget->position.x + cur_widget->size.x / 2, cur_widget->position.y + cur_widget->size.y/2 - font->height / 2, makecol(255, 255, 255), -1, "%s", cur_widget->label);
			}
		}
	cur_widget = cur_widget->NEXT;
	}
return 0;
}

int save_level()
{
create_savefile("newlevel.xml");
zl_save_game();
return 0;
}

int add_banana()
{
if(lveditcommand == 0)
	{
	lveditcommand = LVCMD_ADD_BANANA;
	return 0;
	}
if(lveditcommand == LVCMD_ADD_BANANA)
	lveditcommand = 0;
return 0;
}

int add_wall()
{
if(lveditcommand ==0)
	{
	lveditcommand = LVCMD_ADD_WALL;
	return 0;
	}
if(lveditcommand == LVCMD_ADD_WALL)
	lveditcommand = 0;
return 0;
}


