/*

Copyright (c) 2003-2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"
extern int use_hardconfig;

/** Retrieve configuration from the specified configuration file
@param config_file is the path of the config file
@return Returns always 0.
*/
int retr_cfg(const char *config_file)
	{
	int loopctrl;
	const char * key_value; 
        /*char * playersection; */
        char *temp2 = (char *)calloc(1, 1024);
        char *cline = (char *)calloc(1, 1024);
	/*est-ce qu'on a un fichier de config ?*/
	if(config_file[0])
                log_msg(1,"Using configfile %s",config_file);
        
        log_msg(3,  "Opening file %s", config_file);
        open_lvl_file(config_file);

        get_level_line(cline);
        /*playersection =  (char *) calloc(1,50);*/
        pl_with_kbinds = atoi (get_level_string(cline, "player_nb", "1", temp2));
        log_msg(1,  "%i player(s) with keybindings", pl_with_kbinds);
        if(pl_with_kbinds > 0 && pl_with_kbinds < 4)
        {
                log_msg(2,  "Allocating memory for keybindings");
                for(loopctrl=0; loopctrl < 15; loopctrl++)
                        pl_kbinds[loopctrl] = (short int *) calloc (pl_with_kbinds + 1, sizeof(short int));
        }
        else
        {
                log_msg(0, "%i player(s) with keybindings is not a valid number. Please define at least one player, at most 3.", pl_with_kbinds);
                exit(5);
        }
        fontsize=8;

        pltoggle_ispressed_flag = 0;
        /*general keybindings*/
        get_level_line(cline);
        log_msg(2, "General keybindings");
        key_value = get_level_string(cline, "quit", "esc", temp2);
	key_quit=give_key_value(key_value);
	log_msg(2, "Quit key : %s", key_value);
	
	key_value = get_level_string(cline, "console", "C", temp2);
	key_console=give_key_value(key_value);
        log_msg(2,  "Console key : %s", key_value);
        
        key_value = get_level_string(cline, "pause", "P", temp2);
        key_pause = give_key_value(key_value);
        
        /*player keybindings*/
        log_msg(2, "Player keybindings");
        for (loopctrl = 0; loopctrl < pl_with_kbinds; loopctrl++)
        {
                log_msg(2,  "Player %i keybindings", loopctrl);
                get_level_line(cline);
                
                key_value = get_level_string(cline, "go_left", "none", temp2);
                pl_kbinds[LEFT][loopctrl]=give_key_value(key_value);
                log_msg(2,"Go_left key : %i",pl_kbinds[LEFT][loopctrl]);

                key_value = get_level_string(cline, "go_right", "none", temp2);
                pl_kbinds[RIGHT][loopctrl]=give_key_value(key_value);
                log_msg(2,"Go_right key : %i",pl_kbinds[RIGHT][loopctrl]);
                
                key_value = get_level_string(cline, "jump", "not_defined", temp2);
                pl_kbinds[JUMP][loopctrl]=give_key_value(key_value);
                log_msg(2,"Jump key :  %i",pl_kbinds[JUMP][loopctrl]);
                
                key_value = get_level_string(cline, "crouch", "not_defined", temp2);
                pl_kbinds[CROUCH][loopctrl]=give_key_value(key_value);
                log_msg(2,"Crouch key :  %i",pl_kbinds[CROUCH][loopctrl]);
                
                key_value = get_level_string(cline, "fire", "not_defined", temp2);
                pl_kbinds[FIRE][loopctrl]=give_key_value(key_value);
                log_msg(2,"Fire key :  %i",pl_kbinds[FIRE][loopctrl]);
                
                key_value = get_level_string(cline, "change_weapon", "not_defined", temp2);
                pl_kbinds[CH_WEAP][loopctrl]=give_key_value(key_value);
                log_msg(2,"Change weapon key :  %i",pl_kbinds[CH_WEAP][loopctrl]);
                
                key_value = get_level_string(cline, "run", "not_defined", temp2);
                pl_kbinds[RUN][loopctrl]=give_key_value(key_value);
                log_msg(2,"Run key : %i", pl_kbinds[RUN][loopctrl]);
        }
        
        free(temp2);
        free(cline);
        return 0;
        }
        
        
/** Set default configuration. Not to be used.
*/	
int set_default_conf()
{
        int loopctrl;
        log_msg(3,  "Entering set_default_conf()");
        fontsize=8;
        for(loopctrl=0; loopctrl < 15; loopctrl++)
                pl_kbinds[loopctrl] = (short int *) calloc (2, sizeof(short int));
        key_quit = give_key_value("esc");
        key_pause = give_key_value("P");
        key_console = give_key_value("C");
        pl_kbinds[LEFT][0] = give_key_value("left");
        pl_kbinds[RIGHT][0] = give_key_value("right");
        pl_kbinds[JUMP][0] = give_key_value("up");
        pl_kbinds[CROUCH][0] = give_key_value("down");
        pl_kbinds[FIRE][0] = give_key_value("space");
        pl_kbinds[CH_WEAP][0] = give_key_value("tabulation");
        pl_kbinds[RUN][0] = give_key_value("R");
        return 0;
}
        
/** Give the allegro numeric value of a key from the Zlog symbolic name.
@param valuestr is the symbolic name of the key.
@return the Allegro KEY_* constant
@see give_key_name()
*/     
int give_key_value(const char *valuestr)
        {
        char testingmn='a';
        char testingmj='A';
        int i=1;
        
        if(strstr(valuestr,"none"))
                return -1;
        if(strstr(valuestr,"not_defined"))
                return 0;
        if(strstr(valuestr,"left"))
                return KEY_LEFT;
        if(strstr(valuestr,"right"))
                return KEY_RIGHT;
        if(strstr(valuestr,"up"))
                return KEY_UP;
        if(strstr(valuestr,"down"))
                return KEY_DOWN;
        if(strstr(valuestr,"tabulation"))
                return KEY_TAB;
        if(strstr(valuestr,"space"))
                return KEY_SPACE;
        if(strstr(valuestr,"esc"))
                return KEY_ESC;
        if(strstr(valuestr,"backspace"))
                return KEY_BACKSPACE;
        if(strstr(valuestr,"asterisk"))
                return KEY_ASTERISK;
        if(strstr(valuestr,"pad_plus"))
                return KEY_PLUS_PAD;
        if(strstr(valuestr,"pad_moins"))
                return KEY_MINUS_PAD;
        if(strstr(valuestr,"pad_slash"))
                return KEY_SLASH_PAD;
        
        if(strlen(valuestr)>1)
                {
                log_msg(0,"Error while setting key configuration : %s unknown.",valuestr);
                exit(250);
                }
        /* A = 1 .... Z=26 ...9=36*/
        
        
        while(i!=27)
                {
                if(valuestr[0]==testingmn)
                        return i;
                if(valuestr[0]==testingmj)
                        return i;
                
                testingmn++;
                testingmj++;
                i++;
                }
        
        testingmn='0';
        while(i!=37)
                {
                if(valuestr[0]==testingmn)
                        return i;
               testingmn++;
               i++;
               }
        
        log_msg(0,"Error parsing %s : no corresponding token.",valuestr);
        exit(10);
        
        }
        
        
/** Give the Zlog symbolic name of a key, from the allegro value
@param keyvalue is the allegro value
@param target is the pointer where to put the symbolic name
@return Returns a pointer to target.*/        
char * give_key_name(const char keyvalue, char * target)
        {
        char valeur='A';
        int is_letter=1;
        memset(target, 0, strlen(target));
            switch(keyvalue){
                    case -1 : sprintf(target, "%s", "none"); is_letter=0; break;
                    case 0 : sprintf(target, "%s","not_defined"); is_letter=0; break;
                    case KEY_LEFT : sprintf(target, "%s","left"); is_letter=0; break;
                    case KEY_RIGHT : sprintf(target, "%s","right"); is_letter=0; break;
                    case KEY_DOWN : sprintf(target, "%s","down"); is_letter=0; break;
                    case KEY_UP : sprintf(target, "%s","up"); is_letter=0; break;
                    case KEY_TAB : sprintf(target, "%s","tabulation"); is_letter=0; break;
                    case KEY_SPACE : sprintf(target, "%s","space"); is_letter=0; break;
                    case KEY_ESC : sprintf(target, "%s","esc"); is_letter=0; break;
                    case KEY_BACKSPACE : sprintf(target, "%s","backspace"); is_letter=0; break;
                    case KEY_ASTERISK : sprintf(target, "%s","asterisk"); is_letter=0; break;
                    case KEY_PLUS_PAD : sprintf(target, "%s","pad_plus"); is_letter=0; break;
                    case KEY_MINUS_PAD : sprintf(target, "%s","pad_moins"); is_letter=0; break;
                    case KEY_SLASH_PAD : sprintf(target, "%s","pad_slash"); is_letter=0; break;
                    }
            /* A = 1 .... Z=26 ...9=36*/
            
            if(is_letter)
            {
                    if(keyvalue <= 26)
                        valeur+=keyvalue-1;
                    else if(keyvalue <= 36)
                        {
                        valeur='0';
                        valeur+=keyvalue-27;
                        }
                    sprintf(target,"%c",valeur);
            }
        return target;
        }
                
        


