/*

Copyright (c) 2004-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */



#include "all_inc.h"

/** \file display.c
Display
*/

extern volatile int speed_counter;
extern volatile int fps_counter;
extern volatile int render_fps;
extern volatile int last_fps;
extern volatile int avg_fps;
extern volatile int nb_fps_cycles;
extern int cyclecount;

BITMAP * saucer_spr;
/** Display the main frame of the screen
@param where the coordinates of the frame
*/
void display_cadre(gamescreen where)
{
rect(ecranv[page_num], where.cadrehg.x, where.cadrehg.y, where.cadrebd.x, where.cadrebd.y, CYAN);
}


/** Display a liveplayer and its weapon
@param target is a pointer to the liveplayer to be displayed
@return Returns always 0.
*/
int disp_pl(liveplayer * target)
{
extern int bpp;
/* affichage du player */
int l=target->xsize;
int L=target->ysize;
point plrefpt;
int color = 1 << (bpp -  8);

plrefpt.x=target->refpt.x-obj_db.screen_pos.x;
plrefpt.y=target->refpt.y-obj_db.screen_pos.y;

if(color == 16)
        color --;
if(target->state & ZL_PLAYER_INVINCIBLE)
        color = 4;
        
if(target->current_sprite)
        draw_sprite(game_frame[page_num], target->current_sprite->spr, plrefpt.x, plrefpt.y);
else
        rectfill(game_frame[page_num],plrefpt.x,plrefpt.y,plrefpt.x+l,plrefpt.y+L, color);

return(0);
}

/** Display a killing_line (usually invisible).
@param klnb is the number of the killing line
@return Returns always 0.
*/
int disp_kline(killing_line * source)
{
if(!source->to_disp) return 1;
int posx = source->position.x - obj_db.screen_pos.x;
int posy = source->position.y - obj_db.screen_pos.y;
int taille = source->taille;
rectfill(game_frame[page_num], posx, posy, posx+taille, posy+2, RED);
return 0;
}


/** Display a given portal. The portal is displayed in RED if it's active, in BLUE otherwise.
@param portalnb is the number of the portal to display
@return Returns always 0.
*/
int disp_portal(portal * target)
{
rect(game_frame[page_num], target->position.x - obj_db.screen_pos.x, target->position.y - obj_db.screen_pos.y, (target->position.x + target->xsize) - obj_db.screen_pos.x, (target->position.y + target->ysize) - obj_db.screen_pos.y, (target->state & INHIBIT_TELEPORTER) ? BLUE : RED);
return 0;
}


/** Display a given wall.
@param wallnb is the number of the wall.
@return Returns always 0.
*/
int disp_wall(wall * source)
{
int l, L, color;
extern int bpp;
point wallrefpt;
if(source->parms & WL_IS_INVISIBLE)
	return 1;

/* affichage du mur */
l = source->xsize;
L = source->ysize;
color = 4 * (1 << (bpp -8)) + 1;

wallrefpt.x = source->refpt.x-obj_db.screen_pos.x;
wallrefpt.y = source->refpt.y-obj_db.screen_pos.y;
if (color == 16 || color == 17 || color == 18)
        color = 15;

if(source->sprite)
        draw_sprite(game_frame[page_num], source->sprite, wallrefpt.x, wallrefpt.y);
else
        rectfill(game_frame[page_num], wallrefpt.x, wallrefpt.y, wallrefpt.x+l, wallrefpt.y+L, color);
return 0;
}


/** Display the background, with the offset needed for the pseudo-parallax scrolling.
*/
void display_background()
{

unsigned int modx, mody;
unsigned int x, y;
int starrot;

modx = (/*obj_db.screen_pos.x - */background_offset_x) % 384;
mody = (/*obj_db.screen_pos.y - */background_offset_y) % 384;


for(starrot=0; starrot < nombre_stars; starrot ++)
        {
        
        if(stars[starrot].x > modx)
                x = stars[starrot].x - modx;
        else
                x = stars[starrot].x - modx + 384;
        for(; x < zlogframe.L; x += 384)
                {
                if(stars[starrot].y > mody)
                        y = stars[starrot].y - mody;
                else
                        y = stars[starrot].y - mody + 384;
                for(; y < RESOL_Y; y += 384)
                        {
                        putpixel(game_frame[page_num], x, y, stars[starrot].color);
                        if(!(starrot % 10))
                                stars[starrot].color = rand();
                        }
                }
        }
}

/** Display the console if relevant
*/
void display_console()
{


}


/** Display standard in-game statistics as well as debugging info.
*/
void display_stats()
{




textprintf_ex(ecranv[page_num], font, 610, zlogframe.cadrebd.y+11, -1, -1, "ScreenPos [%i;%i]",\
                                obj_db.screen_pos.x, obj_db.screen_pos.y);
textprintf_ex(ecranv[page_num], font, 610, zlogframe.cadrebd.y + 25, -1, -1, "MadPos [%i;%i]", obj_db.madmaker_head->refpt.x, obj_db.madmaker_head->refpt.y);


liveplayer * plrot;
plrot = obj_db.liveplayer_head;
int plnb = 0;
	
	while(plrot)
		{
		if(plnb > 2) break;
		textprintf_ex(ecranv[page_num], font, 5 + (200*plnb), zlogframe.cadrebd.y +11, -1, -1, "%s %i,%i", plrot->name, plrot->refpt.x, plrot->refpt.y);
    
		textprintf_ex(ecranv[page_num], font, 5 + (200*plnb), zlogframe.cadrebd.y + 11 + 2*fontsize, -1, -1, "Sanity");
		rect(ecranv[page_num], 60+(200*plnb), zlogframe.cadrebd.y + 11 + 2*fontsize, (200*plnb) + 162, zlogframe.cadrebd.y + 21 + 2*fontsize, RED);
		rectfill(ecranv[page_num], 61+(200*plnb), zlogframe.cadrebd.y+12+2*fontsize, (61+(200*plnb)) + 99 * plrot->life / 1000,\
                    zlogframe.cadrebd.y+20+2*fontsize, DARKRED);    
		textprintf_ex(ecranv[page_num], font, 5 + (200*plnb), zlogframe.cadrebd.y + 11 + 4*fontsize, -1, -1, "Speed");
		rect(ecranv[page_num], 60+(200*plnb), zlogframe.cadrebd.y + 11 + 4*fontsize, (200*plnb) + 162, zlogframe.cadrebd.y + 21 + 4*fontsize, GREEN);
		rectfill(ecranv[page_num], 61+(200*plnb), zlogframe.cadrebd.y+12+4*fontsize, (61+(200*plnb)) + 99 * plrot->moving_spd.x/4,\
                    zlogframe.cadrebd.y+20+4*fontsize, makecol(0, 127, 0));    
		
		plrot = GETNEXT(plrot);
		plnb ++;
		}

    
    if(MODE_DEBUG_ACTIF)
        { /*si on dbuggue un player*/
	/*informations relatives aux coordones*/
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), -1, -1, "ysize : %i xsize : %i",cur_player->ysize, cur_player->xsize);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), -1,-1, "Ref %x", (unsigned int)(void *)cur_player->ref_pform);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 7*(fontsize+2), -1,-1, "Dzone %i", delay_to_deadzone);
                textprintf_ex(ecranv[page_num], font, 5, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), -1, -1, "x+ %f y+ %f", cur_player->add_x, cur_player->add_y);
                
                /*flags du player courant*/
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), -1, -1, "Jmp %i Jpd %i", cur_player->state & ZL_PLAYER_JUMPING, cur_player->state & ZL_PLAYER_JPRESSED);
                
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), -1, -1, "Nol %i Nor %i", cur_player->state & NO_LEFT, cur_player->state & NO_RIGHT);
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 3*(fontsize+2), -1, -1, "Nou %i Nod %i", cur_player->state & NO_UP, cur_player->state & NO_DOWN);
                textprintf_ex(ecranv[page_num], font, 700, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), -1, -1, "Idl %i Run %i", cur_player->state & ZL_PLAYER_IDLE, cur_player->state & ZL_PLAYER_RUNNING);
                textprintf_ex(ecranv[page_num], font, 610, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), -1, -1, "Zig %i %i", cur_player->zignals.mask, cur_player->zignals.parm[1][0]);
                
                /*informations relatives au saut en cours*/
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 4*(fontsize+2), -1, -1, "Jti %f",cur_player->jtime);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 5*(fontsize+2), -1, -1, "Spd x %f y %f",cur_player->current_spd.x, cur_player->current_spd.y);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 6*(fontsize+2), -1, -1, "MovSpd x %f y %f",cur_player->moving_spd.x, cur_player->moving_spd.y);
                textprintf_ex(ecranv[page_num], font, 250, zlogframe.cadrebd.y+ 11 + 7*(fontsize+2), -1, -1, "BJSpd %f MJSpd %f",cur_player->base_jumping_speed, cur_player->max_jumping_speed);
        }
    
}

int display_madmaker(madmaker * obj)
{
if(obj == NULL)
	{
	log_msg(0, "No madmaker!");
	return 1;
	}
line(ecranv[page_num], obj->refpt.x + 50 - obj_db.screen_pos.x, obj->refpt.y + 100 - obj_db.screen_pos.y, obj->refpt.x - obj_db.screen_pos.x + 100, zlogframe.cadrebd.y, makecol(255, 0, 0));
line(ecranv[page_num], obj->refpt.x + 50 - obj_db.screen_pos.x, obj->refpt.y + 100 - obj_db.screen_pos.y, obj->refpt.x + 50 - 2*zlogframe.L - obj_db.screen_pos.x, zlogframe.cadrebd.y, makecol(255, 0, 0));
float totalangle = atan(2*zlogframe.L /( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y)) + atan(50/( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y));
float anglestep = totalangle / 6;
int piece = 0;
float curangle = - atan(2*zlogframe.L /( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y));

triangle(ecranv[page_num], obj->refpt.x + 50 - 2*zlogframe.L - obj_db.screen_pos.x, zlogframe.cadrebd.y, obj->refpt.x + 50 - obj_db.screen_pos.x, obj->refpt.y + 100 - obj_db.screen_pos.y, obj->refpt.x + 50 - obj_db.screen_pos.x + ( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y) * tan(curangle+anglestep), zlogframe.cadrebd.y, makecol(255, 0 ,0));
for( ; curangle < atan(50/( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y)); curangle += anglestep)
	{
	int posx = obj->refpt.x + 50 - obj_db.screen_pos.x + ( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y) * tan(curangle);
	int color = 0;
	switch(piece) {
		case 0: color = makecol(255, 200, 0); break;
		case 1: color = makecol(255, 255, 0);break;
		case 2: color = makecol(127, 255, 0); break;
		case 3: color = makecol(0, 255, 127); break;
		case 4: color = makecol(0, 127, 255); break;
		case 5: color = makecol(0, 0, 255); break;
		case 6: color = makecol(127, 0, 255); break;
		};
	triangle(ecranv[page_num], posx, zlogframe.cadrebd.y, obj->refpt.x + 50 - obj_db.screen_pos.x, obj->refpt.y + 100 - obj_db.screen_pos.y, obj->refpt.x + 50 - obj_db.screen_pos.x + ( obj->refpt.y + 100 - obj_db.screen_pos.y + zlogframe.cadrebd.y) * tan(curangle+anglestep), zlogframe.cadrebd.y, color);
	line(ecranv[page_num], obj->refpt.x + 50 - obj_db.screen_pos.x, obj->refpt.y + 100 - obj_db.screen_pos.y, posx, zlogframe.cadrebd.y, color);
	piece ++;
	}
return 0;
}

int disp_banana(banana * source)
{
//rectfill(ecranv[page_num], source->refpt.x - obj_db.screen_pos.x, source->refpt.y - obj_db.screen_pos.y, source->refpt.x + 30- obj_db.screen_pos.x, source->refpt.y + 30- obj_db.screen_pos.y, makecol(255, 255, 0));
draw_sprite(game_frame[page_num], source->spriteset[0][0].spr, source->refpt.x - obj_db.screen_pos.x, source->refpt.y - obj_db.screen_pos.y);
return 0;
}
/** Display a livewall.
@param lwallnb is the number of the livewall.
@return Returns always 0.
*/
int disp_lwall(livewall * source)
{
int l, L, color;
point lwallrefpt;
        if(source->parms & WL_IS_INVISIBLE)
                return 1;
/* affichage du mur */
l=source->xsize;
L=source->ysize;
/*if(source == obj_db.livewall_head)
	printf("X %i Y %i\n", l, L);*/
color = 3 * (1 << (bpp -8)) + 5;
lwallrefpt.x=source->refpt.x-obj_db.screen_pos.x;
lwallrefpt.y=source->refpt.y-obj_db.screen_pos.y;

if(color == 16)
        color --;
        
if(source->sprite)
        {
	unsigned int yclip = 0;
	if(TEST_GLOBAL_STATE(LVLEDIT_MODE))
		yclip = 120;
        /*on clippe exactement sur la taille du centre*/
        int offset = (float)((source->sprite)->w - l) / 2;
	masked_blit(source->sprite, game_frame[page_num], (*source->edgeleft)->w + offset, 0, lwallrefpt.x + (*source->edgeleft)->w, lwallrefpt.y, l - (*source->edgeright)->w - (*source->edgeleft)->w, L);
        draw_sprite(game_frame[page_num], *source->edgeleft, lwallrefpt.x, lwallrefpt.y);
        draw_sprite(game_frame[page_num], *source->edgeright, lwallrefpt.x + l - (*source->edgeright)->w, lwallrefpt.y);
        }
else
        rectfill(game_frame[page_num],lwallrefpt.x,lwallrefpt.y,lwallrefpt.x+l,lwallrefpt.y+L, color);
return 0;
}


/** Display the crosshair. UNUSED
*/
void display_mouse()
{
point scr_mouse;
scr_mouse.x = mouse_pos >> 16;
scr_mouse.y = mouse_pos & 0x0000ffff;
extern int lveditcommand;
if(lveditcommand == LVCMD_ADD_BANANA)
	{
	sprset bananes;
	if(! (bananes = search_spritesetdb_entry(spriteset_db, "banana")))
		{
		spriteset_db = add_spritesetdb_entry(spriteset_db, "banana", BANANA_SPRSET);
		bananes = search_spritesetdb_entry(spriteset_db, "banana");
		}
	draw_sprite(ecranv[page_num], bananes[0][0].spr, scr_mouse.x, scr_mouse.y);
	return;
	}
if(lveditcommand == LVCMD_ADD_WALL)
	{
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y + 4, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y + 5, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 4, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 5, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 3, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 2, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 1, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y +1, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y +2, WHITE);
	putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y +3, WHITE);
	return;
	}

log_msg(3, "scr_mouse.x = %i ; scr_mouse.y = %i", scr_mouse.x, scr_mouse.y);
putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y, WHITE);
putpixel(ecranv[page_num], scr_mouse.x + 4, scr_mouse.y, WHITE);
putpixel(ecranv[page_num], scr_mouse.x + 5, scr_mouse.y, WHITE);
putpixel(ecranv[page_num], scr_mouse.x - 4, scr_mouse.y, WHITE);
putpixel(ecranv[page_num], scr_mouse.x - 5, scr_mouse.y, WHITE);
putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y + 4, WHITE);
putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y + 5, WHITE);
putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 4, WHITE);
putpixel(ecranv[page_num], scr_mouse.x, scr_mouse.y - 5, WHITE);
}

/** The main display function. It calls the other display_ function and takes care of the double buffering or page flipping.
@return Returns always 0.
*/
int display_all()
{
if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
    {
    acquire_bitmap(ecranv[page_num]);
    }
clear_bitmap(ecranv[page_num]);

display_background();

if(CONSOLE_IS_ACTIVE)
        display_console();
        
display_stats();

display_madmaker(obj_db.madmaker_head);
liveplayer * plrot = obj_db.liveplayer_head;
while(plrot)
	{
	disp_pl(plrot);
	plrot = GETNEXT(plrot);
	}

plrot = obj_db.enemy_head;
while(plrot)
	{
	disp_pl(plrot);
	plrot = GETNEXT(plrot);
	}

killing_line * klrot = obj_db.killing_line_head;
while(klrot)
	{
	disp_kline(klrot);
	klrot = GETNEXT(klrot);
	}
	
wall * wlrot = obj_db.wall_head;
while(wlrot)
	{
	disp_wall(wlrot);
	wlrot = GETNEXT(wlrot);
	}

livewall * lwlrot = obj_db.livewall_head;
while(lwlrot)
	{
	disp_lwall(lwlrot);
	lwlrot = GETNEXT(lwlrot);
	}

portal * ptrot = obj_db.portal_head;
while(ptrot)
	{
	disp_portal(ptrot);
	ptrot = GETNEXT(ptrot);
	}

banana * bnrot = obj_db.banana_head;
while(bnrot)
	{
	disp_banana(bnrot);
	bnrot = GETNEXT(bnrot);
	}
madmaker * obj = obj_db.madmaker_head;
//rect(ecranv[page_num], obj->refpt.x - obj_db.screen_pos.x, obj->refpt.y - obj_db.screen_pos.y, obj->refpt.x + 100 - obj_db.screen_pos.x, obj->refpt.y - obj_db.screen_pos.y + 100, makecol(255, 0, 255));
draw_sprite(game_frame[page_num], saucer_spr, 	obj->refpt.x - obj_db.screen_pos.x, obj->refpt.y - obj_db.screen_pos.y + 65);
/*display_mouse(); temporarily disabled*/

display_cadre(zlogframe);

scheduler_disp();


if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
	release_bitmap(ecranv[page_num]);
 

if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
    {    

    if(!is_memory_bitmap(ecranv[0]))
		vsync();

    acquire_screen();
    blit(ecranv[0], screen, 0,0,0,0,RESOL_X,RESOL_Y);
    release_screen();
    }
else {
    show_video_bitmap(ecranv[page_num]);
    page_num = 1-page_num;
}

return(0);
}
/** Display the splash screen.
@param message is the message to be displayed
@return Returns always 0.
*/
int display_splash(char *message)
{

log_msg(3, "Resolution X : %i, Resolution Y : %i", RESOL_X, RESOL_Y);
rectfill(screen, 0, 0, RESOL_X, RESOL_Y, 7);
textout_ex(screen, font, message, 0.40*RESOL_X, 0.48*RESOL_Y, 1, WHITE);

return 0;
}

/** Display an in-game message not using a messagebox, but directly in the statistics frame. This function is called by the scheduler.
@param counter is not used by this function.
@param iparm is not used by this function.
@param message is the message to display.
*/
void display_schedmsg(int counter, int iparm, void * message)
{
        counter = 0;
        iparm = 0;
        if(message != NULL)
                        textout_ex(ecranv[page_num], font, message, 400, 570, -1, -1);
}

