/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */


/** \file colldet.c
Collision detection
*/


#define COLLDET_C
#include "all_inc.h"

#define GIVE_NW_POINT(OPTR) OPTR->refpt

#define GIVE_NE_POINT(OPTR) {OPTR->refpt.x + OPTR->xsize, \
                OPTR->refpt.y}
                

#define GIVE_SW_POINT(OPTR) {OPTR->refpt.x, \
                OPTR->refpt.y + OPTR->ysize}
                
                
#define GIVE_SE_POINT(OPTR) { (OPTR->refpt.x + OPTR->xsize), \
                (OPTR->refpt.y + OPTR->ysize)}
                

/*
tableau tests pour 5 objets

0 1 2 3 4 

n o o o o   0               x, o : ancien test
x n o o o   1               o : new
x x n o o   2               n : aucun
x x x n o   3
x x x x n   4
*/

/** Do global collision detection. This function makes collision detection between all objects. It's heavy so please use with care.
*/
void colldet()
{
reset_forbids();

pl_colldet_lwalls();
pl_colldet_player();

pl_colldet_walls();
pl_colldet_klines();
pl_colldet_portals();
pl_colldet_bananas();
}


/** Reset all collision markers from players, enemies and livewalls.
@see colldet()
*/
void reset_forbids()
{
	
for(int i = 0; i < 2; i ++)
	{
	liveplayer * plrot;
	if(!i)
		plrot = obj_db.liveplayer_head;
	else plrot = obj_db.enemy_head;
	
	while(plrot)
		{
		plrot->state &= ~NO_LEFT;
		plrot->state &= ~NO_RIGHT;
		plrot->state &= ~NO_DOWN;
		plrot->state &= ~NO_UP;
		plrot->ref_pform = NULL;
		plrot->state &= ~ZL_PLAYER_LIVE_REFPFORM;
		plrot = GETNEXT(plrot);
		}
	}

livewall * wlrot = obj_db.livewall_head;
	
while(wlrot)
        {
        wlrot->state &= ~NO_LEFT;
        wlrot->state &= ~NO_RIGHT;
        wlrot->state &= ~NO_DOWN;
        wlrot->state &= ~NO_UP;
	wlrot = GETNEXT(wlrot);
        }
}

/** Tests for collision between liveplayers and other liveplayers.
@see colldet()
@see _plvpltest()
*/
void pl_colldet_player()
{
liveplayer * X, * Y;
int Ytype = ZL_PLAYER_HUMAN;
X = obj_db.liveplayer_head;
while(X)
	{
	for(int i = 0; i < 2; i++)
		{
		if(!i)
			Y = GETNEXT(X);
		else {
			Y = obj_db.enemy_head;
			Ytype = ZL_PLAYER_ENNEMY;
			}
			
		while(Y)
			{
			liveplayer * next = GETNEXT(Y);
			if((abs(X->refpt.x - Y->refpt.x) < (X->xsize + Y->xsize)) && (abs(X->refpt.y - Y->refpt.y) < (X->ysize + Y->ysize)))
				_plvpltest(X, Y, ZL_PLAYER_HUMAN, Ytype);
			Y = next;
			}
		}
	X = GETNEXT(X);
	}
	
X = obj_db.enemy_head;
while(X)
	{
	Y = GETNEXT(X);
	while(Y)
		{
		if((abs(X->refpt.x - Y->refpt.x) < (X->xsize + Y->xsize)) && (abs(X->refpt.y - Y->refpt.y) < (X->ysize + Y->ysize)))
			_plvpltest(X, Y, ZL_PLAYER_ENNEMY, ZL_PLAYER_ENNEMY);
		Y = GETNEXT(Y);
		}
	X = GETNEXT(X);
	}
}
	
/*
int yrt,xrt, zrt;
    for(yrt = 0; yrt < obj_db.nombre_perso; yrt++)
        {
        for(xrt = 0; yrt+1+xrt < obj_db.nombre_perso; xrt++)
                {
                if((abs(obj_db.perso[yrt].refpt.x-obj_db.perso[yrt+1+xrt].refpt.x)<\
                                obj_db.perso[yrt].xsize+obj_db.perso[yrt+1+xrt].xsize)&&\
                   (abs(obj_db.perso[yrt].refpt.y-obj_db.perso[yrt+1+xrt].refpt.y)<\
                                obj_db.perso[yrt].ysize+obj_db.perso[yrt+1+xrt].ysize))
                _plvpltest(yrt,yrt+1+xrt, ZL_PLAYER_HUMAN, ZL_PLAYER_HUMAN);
                }
                
        for(xrt = 0; xrt < obj_db.nombre_enemies; xrt++)
                {
                if((abs(obj_db.perso[yrt].refpt.x-obj_db.enemies[xrt].refpt.x)<\
                                obj_db.perso[yrt].xsize+obj_db.enemies[xrt].xsize)&&\
                   (abs(obj_db.perso[yrt].refpt.y-obj_db.enemies[xrt].refpt.y)<\
                                obj_db.perso[yrt].ysize+obj_db.enemies[xrt].ysize))
                _plvpltest(yrt,xrt, ZL_PLAYER_HUMAN, ZL_PLAYER_ENNEMY);
                for(zrt = 0; xrt+1+zrt < obj_db.nombre_enemies; zrt ++)
                        {
                        if((abs(obj_db.enemies[xrt].refpt.x-obj_db.enemies[xrt+1+zrt].refpt.x)<\
                                obj_db.enemies[xrt].xsize+obj_db.enemies[xrt+1+zrt].xsize)&&\
                   (abs(obj_db.enemies[xrt].refpt.y-obj_db.enemies[xrt+1+zrt].refpt.y)<\
                                obj_db.enemies[xrt].ysize+obj_db.enemies[xrt+1+zrt].ysize))
                _plvpltest(xrt,xrt+1+zrt, ZL_PLAYER_ENNEMY, ZL_PLAYER_ENNEMY);
                        }
                }
                
        }*/


/** Tests for collision between liveplayers and walls.
@see colldet()
@see _plvwalltest()
*/
void pl_colldet_walls()
{

liveplayer * pl;
wall * wl;
for(int i = 0; i < 2; i ++)
	{
	if(!i) pl = obj_db.liveplayer_head;
	else {
		pl = obj_db.enemy_head;
		}
	
	while(pl)
		{
		wl = obj_db.wall_head;
		while(wl)
			{
			if((abs(pl->refpt.x - wl->refpt.x) < (pl->xsize + wl->xsize)) && (abs(pl->refpt.y - wl->refpt.y) < (pl->ysize + wl->ysize)))
				_plvwalltest(pl, wl);
			wl = GETNEXT(wl);
			}
		pl = GETNEXT(pl);
		}
	}
}
void pl_colldet_bananas()
{
liveplayer *pl = obj_db.liveplayer_head;
banana * bn = obj_db.banana_head;
while(pl)
	{
	bn = obj_db.banana_head;
	while(bn)
		{
		_plvbananatest(pl, bn);
		bn = GETNEXT(bn);
		}
	pl = GETNEXT(pl);
	}
	
}
/** Tests for collision between liveplayers and killing-lines.
@see colldet()
@see _plvkltest()
*/
void pl_colldet_klines()
{
liveplayer * pl;
killing_line * kl;
	
for(int i = 0; i < 2; i ++)
	{
	if(!i) pl = obj_db.liveplayer_head;
	else {
		pl = obj_db.enemy_head;
		}
	
	while(pl)
		{
		kl = obj_db.killing_line_head;
		while(kl)
			{
			_plvkltest(pl, kl);
			kl = GETNEXT(kl);
			}
			
		pl = GETNEXT(pl);
		}
	}
pl = obj_db.liveplayer_head;
static int last_cycle_hit;
/*x = by +c
twice!
dx = b.dy
b = dx/dy*/
while(pl)
	{
	extern int cyclecount;
	speed AM;
	AM.x = (float)(pl->refpt.x - obj_db.screen_pos.x) - (float)((float)obj_db.madmaker_head->refpt.x + (float)50 - (float)2*zlogframe.L - (float)obj_db.screen_pos.x);
	AM.y = (float)(pl->refpt.y - obj_db.screen_pos.y)- (float)zlogframe.cadrebd.y;
	speed AB;
	AB.x = (float)obj_db.madmaker_head->refpt.x + 50 - (float)obj_db.screen_pos.x - (float)((float)obj_db.madmaker_head->refpt.x + 50 - (float)2*(float)zlogframe.L - (float)obj_db.screen_pos.x);
	AB.y = (float)obj_db.madmaker_head->refpt.y + 100 - obj_db.screen_pos.y - zlogframe.cadrebd.y;
	speed AC;
	AC.x = (float)obj_db.madmaker_head->refpt.x - (float)obj_db.screen_pos.x + 100 - (float)(obj_db.madmaker_head->refpt.x + 50 - 2*(float)zlogframe.L - obj_db.screen_pos.x);
	AC.y = 0;
	int AMAC = AM.x * AC.x + AM.y * AC.y;
	int AMAB = AM.x * AB.x + AM.y * AB.y;

	if(AMAC < AC.x * AC.x + AC.y * AC.y && AMAB < AB.x * AB.x + AB.y * AB.y && AMAC > 0 && AMAB > 0)
		{
		speed CB;
		CB.x = -50;
		CB.y = (float)obj_db.madmaker_head->refpt.y + 100 - obj_db.screen_pos.y -(float)zlogframe.cadrebd.y;
		speed CM;
		CM.x = (float)(pl->refpt.x) - (float)obj_db.madmaker_head->refpt.x + 100;
		CM.y = (float)(pl->refpt.y - obj_db.screen_pos.y) -(float)zlogframe.cadrebd.y;
		int CMCB = CM.x * CB.x + CM.y * CB.y;
		if(CMCB < CB.x * CB.x + CB.y * CB.y && last_cycle_hit != cyclecount) {
										last_cycle_hit = cyclecount;
										unit_lose_hp(pl, 1);
										}
		}
		
		
	pl = GETNEXT(pl);
	}
}

/** Tests for contact between liveplayers and teleporters.
@see colldet()
@see _plvportaltest()
*/
void pl_colldet_portals()
{
liveplayer * pl = obj_db.liveplayer_head;
portal * pt;
	
while(pl)
	{
	pt = obj_db.portal_head;
	while(pt)
		{
		_plvportaltest(pl, pt);
		pt = GETNEXT(pt);
		}
	pl = GETNEXT(pl);
	}
}

/** Tests for collision between liveplayers and livewalls.
@see colldet()
@see _plvlwalltest()
*/
void pl_colldet_lwalls()
{

liveplayer * pl;
livewall * lwl;
int pltype = ZL_PLAYER_HUMAN;
for(int i = 0; i < 2; i ++)
	{
	if(!i) pl = obj_db.liveplayer_head;
	else {
		pl = obj_db.enemy_head;
		pltype = ZL_PLAYER_ENNEMY;
		}
	
	while(pl)
		{
		lwl = obj_db.livewall_head;
		while(lwl)
			{
			if((abs(pl->refpt.x - lwl->refpt.x) < (pl->xsize + lwl->xsize)) && (abs(pl->refpt.y - lwl->refpt.y) < (pl->ysize + lwl->ysize)))
				_plvlwalltest(pl, lwl);
			lwl = GETNEXT(lwl);
			}
		pl = GETNEXT(pl);
		}
	}
}


/** Test for collision between two liveplayers. This function is entitled to test if two liveplayers (each being either a player or an enemy) are in contact. In this case, the collision markers are set.
@param type1 is either ZL_PLAYER_HUMAN to indicate that the first liveplayer is a player, or ZL_PLAYER_ENNEMY to indicate that it is an enemy
@param type2 see above
@see pl_colldet_player()
@return Returns -1 on error, 0 otherwise.
*/
int _plvpltest(liveplayer * target1, liveplayer * target2, char type1, char type2)
{
point pl1nw, pl1se;
point boxnw, boxse, pl2nw;

pl1nw=GIVE_NW_POINT(target1);
pl1se=(point)GIVE_SE_POINT(target1);

      
pl2nw=GIVE_NW_POINT(target2);
              
boxnw.x = pl1nw.x - target2->xsize - 1;
boxnw.y = pl1nw.y - target2->ysize - 1;
boxse.x = pl1se.x + 1;
boxse.y = pl1se.y + 1;

    if(pl2nw.x == boxnw.x && pl2nw.y >= boxnw.y && pl2nw.y <= boxse.y)
    /*alors collision gauche pl1 droite pl2  interdire*/
        {
        target1->state |= NO_LEFT;
        target2->state |= NO_RIGHT;
      /*  if(target1->ref_pform == 0 && target2->ref_pform != 0)
                {
                target1->ref_pform = target2->ref_pform;
                }
        
        if(target2->ref_pform == 0 && target1->ref_pform != 0)
                {
                target2->ref_pform = target1->ref_pform;
                }*/
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                /*target2->state |= ZL_PLAYER_INVINCIBLE;
                target2->trigger_flagmask |= ZL_PLAYER_INVINCIBLE;
                target2->trigger_flagmask = -target1->trigger_flagmask;
                add_scheduler_fnct(alarm_zignal, PLEFFECTOR_TRIGGER_FLAG, &target2->zignals, 300);*/
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }        
        return 0;
        }
    
    if(pl2nw.x == boxse.x && pl2nw.y >= boxnw.y && pl2nw.y <= boxse.y)
    /*alors collision droite pl1 gauche pl2  interdire*/
        {
        target1->state |= NO_RIGHT;
        target2->state |= NO_LEFT;
        
     /*    if(target1->ref_pform == 0 && target2->ref_pform != 0)
                {
                target1->ref_pform = target2->ref_pform;
                }
        
        if(target2->ref_pform == 0 && target1->ref_pform != 0)
                {
                target2->ref_pform = target1->ref_pform;
                }
                */
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }   
        return 0;
        }
        
    if(pl2nw.y == boxse.y && pl2nw.x >= boxnw.x && pl2nw.x <= boxse.x)
    /*alors collision bas pl1 haut pl2  interdire*/
        {
        target1->state |= NO_DOWN;
        target2->state |= NO_UP;
        if(target2->state & ZL_PLAYER_LIVE_REFPFORM)
		target1->state |= ZL_PLAYER_LIVE_REFPFORM;
	else target1->state &= ~ZL_PLAYER_LIVE_REFPFORM;
	target1->ref_pform = target1->ref_pform;

        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 50);
                raise_zignal(&target2->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target2, 100);
                }   
        return 0;
        }
   
    if(pl2nw.y == boxnw.y && pl2nw.x >= boxnw.x && pl2nw.x <= boxse.x)
    /*alors collision haut pl1 bas pl2  interdire*/
        {
        target1->state |= NO_UP;
        target2->state |= NO_DOWN;
        if(target1->state & ZL_PLAYER_LIVE_REFPFORM)
		target2->state |= ZL_PLAYER_LIVE_REFPFORM;
	else target2->state &= ~ZL_PLAYER_LIVE_REFPFORM;
	target2->ref_pform = target1->ref_pform;

        if(type2 == ZL_PLAYER_ENNEMY && type1 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 50);
                raise_zignal(&target1->zignals, ZIGNAL_GOT_HURT, 0, 0);
                }
        if(type1 == ZL_PLAYER_ENNEMY && type2 == ZL_PLAYER_HUMAN)
                {
                unit_lose_hp(target1, 100);
                }   
        return 0;
        }
return 0;
}



/** Test if a player is touching a portal, in what case a teleportation must be done.
@return Return always 0.
@see pl_colldet_portals()
*/
int _plvportaltest(liveplayer * pl, portal * portal)
{
point pl1nw, portalnw, portalse, boxnw, boxse;
pl1nw=GIVE_NW_POINT(pl);

portalnw = portal->position;
portalse = portalnw;
portalse.x += portal->xsize;
portalse.y += portal->ysize;

boxnw.x = portalnw.x - pl->xsize;
boxnw.y = portalnw.y - pl->ysize;
boxse.x = portalse.x;
boxse.y = portalse.y;


if((pl1nw.x >= boxnw.x && pl1nw.x <= boxse.x && pl1nw.y >= boxnw.y && pl1nw.y <= boxse.y))
        {
                if(!(portal->state & INHIBIT_TELEPORTER))
                        {
                        set_teleportation(pl, portal->destination);
                        }
        }
else
        {
        portal->state &= ~INHIBIT_TELEPORTER;
        }
 
return 0;
}

int _plvbananatest(liveplayer * pl, banana * bn)
{
if(pl->refpt.x > bn->refpt.x - pl->xsize && pl->refpt.x < bn->refpt.x + 30 && pl->refpt.y > bn->refpt.y - pl->ysize && pl->refpt.y < bn->refpt.y)
	{
	obj_db.banana_head = del_banana_from_database(obj_db.banana_head, bn);
	if(pl->moving_spd.x < 2)
		{
		pl->moving_spd.x *= 1.3;
		pl->moving_spd.x += 0.5;
		}
	else pl->moving_spd.x *= 1.3;
		
	//pl->moving_spd.x *= 1;
	return 0;
	}
else return 0;
	
}

/** Test if a given player is in collision with a given wall. Update collision markers.
@param type indicates whether the player is a human or an enemy. ZL_PLAYER_HUMAN or ZL_PLAYER_ENNEMY, again.
@see pl_colldet_walls()
@return Returns -1 on error, 0 otherwise.
*/
int _plvwalltest(liveplayer * target, wall * wl)
{
point pl1ne, pl1nw, pl1se, pl1sw;
pl1ne=(point)GIVE_NE_POINT(target);
pl1nw=GIVE_NW_POINT(target);
pl1se=(point)GIVE_SE_POINT(target);
pl1sw=(point)GIVE_SW_POINT(target);
                

point wlne=GIVE_NE_POINT(wl);
point wlnw=GIVE_NW_POINT(wl);
point wlse=GIVE_SE_POINT(wl);
point wlsw=GIVE_SW_POINT(wl);


    if(_segmenttest(&pl1nw, &pl1sw, &wlne, &wlse))
        {
        target->state |= NO_LEFT;
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_W, testwlnb,0);*/
        return 0;
        }
    
    if(_segmenttest(&pl1ne, &pl1se, &wlnw, &wlsw))
        {
        target->state |= NO_RIGHT;
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_E, testwlnb,0);*/
        return 0;
        }
    if(_segmenttest(&pl1sw, &pl1se, &wlnw, &wlne))
        {
        target->state |= NO_DOWN;
	target->state &= ~ ZL_PLAYER_LIVE_REFPFORM;
	target->ref_pform = wl;
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_S, testwlnb,0);*/
        return 0;
        }
   
    if(_segmenttest(&pl1nw, &pl1ne, &wlsw, &wlse))
        {
        target->state |= NO_UP;
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_N, testwlnb,0);*/
        return 0;
        }
        
return 0;
}


/** Test if a given player is in collision with a given livewall. Update collision markers.
@param type indicates whether the player is a human or an enemy. ZL_PLAYER_HUMAN or ZL_PLAYER_ENNEMY, again.
@see pl_colldet_lwalls()
@return Returns -1 on error, 0 otherwise.
*/
int _plvlwalltest(liveplayer * target, livewall * lwl)
{
point pl1ne, pl1nw, pl1se, pl1sw;

pl1ne=(point)GIVE_NE_POINT(target);
pl1nw=GIVE_NW_POINT(target);
pl1se=(point)GIVE_SE_POINT(target);
pl1sw=(point)GIVE_SW_POINT(target);

point lwlne=GIVE_NE_POINT(lwl);
point lwlnw=GIVE_NW_POINT(lwl);
point lwlse=GIVE_SE_POINT(lwl);
point lwlsw=GIVE_SW_POINT(lwl);


    if(_segmenttest(&pl1nw, &pl1sw, &lwlne, &lwlse))
        {
        target->state |= NO_LEFT;
        lwl->state |= NO_RIGHT;
        if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_xsize==0)
                pf_pause_invert(lwl);
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_E, 0, 0);
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_W, testlwlnb, 0);*/
        return 0;
        }
    
    if(_segmenttest(&pl1ne, &pl1se, &lwlnw, &lwlsw))
        {
        target->state |= NO_RIGHT;
        lwl->state |= NO_LEFT;     
	if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_xsize==0)
                pf_pause_invert(lwl);  
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_W, 0, 0);
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_E, testlwlnb, 0);*/
        return 0;
        }
    if(_segmenttest(&pl1sw, &pl1se, &lwlnw, &lwlne))
        {
        target->state |= NO_DOWN;
	target->state |= ZL_PLAYER_LIVE_REFPFORM;
        target->ref_pform = lwl;
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_N, 0, 0);
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_S, testlwlnb, 0);*/
        /*flag triggering*/
        /*if(obj_db.lwalls[testlwlnb].trigger_flagmask > 0)
                obj_db.lwalls[testlwlnb].parms |= obj_db.lwalls[testlwlnb].trigger_flagmask;
        else 
                obj_db.lwalls[testlwlnb].parms &= ~(-obj_db.lwalls[testlwlnb].trigger_flagmask);*/
        return 0;
        }
   
    if(_segmenttest(&pl1nw, &pl1ne, &lwlsw, &lwlse))
        {
        
	target->state |= NO_UP;
        lwl->state |= NO_DOWN;
        
        raise_zignal(&lwl->zignals, ZIGNAL_COLLISION_S, 0, 0);
        /*raise_zignal(&target->zignals, ZIGNAL_COLLISION_N, testlwlnb, 0);*/
        
	if(target->ref_pform && target->state & ZL_PLAYER_LIVE_REFPFORM)
	    { /*if we have a referer, tell it to stop and invert - ie,  go down - */
	    ((livewall *)(target->ref_pform))->state |= NO_UP;
	    pf_pause_invert(target->ref_pform);
	    }
        
	if(!(lwl->state & LWL_PAUSE_MVT) && lwl->mvt_ysize==0 && !(target->state & ZL_PLAYER_JPRESSED))
                pf_pause_invert(lwl);
        return 0;
        }
        
return 0;
}


/** Test if a given player has reached the given killing-line, in what case he must be killed.
@param type indicates whether the player is a human or an enemy. ZL_PLAYER_HUMAN or ZL_PLAYER_ENNEMY, again.
@see pl_colldet_klines()
@return Returns always 0.
*/
int _plvkltest(liveplayer * target, killing_line * kl)
{
/* on vrifie chaque point X du player par rapport aux bornes de la ligne
	si dedans, alors on teste le y, si suprieur killed sinon return 0*/


point position = kl->position;
point endpos = kl->position;
endpos.x += kl->taille;

point pl1ne, pl1nw;

pl1ne=(point)GIVE_NE_POINT(target);
pl1nw=GIVE_NW_POINT(target);

if(_segmenttest(&pl1nw, &pl1ne, &position, &endpos))
	{
	unit_lose_hp(target, target->life+1);
	}
return 0;
}
	
	
/** Test if two segments are in collision. This function is the basis of most _plv*() tests.
@param seg1b1 is a pointer to the first point of the first segment.
@param seg1b2 is a pointer to the second point of the first segment.
@param seg2b1 is a pointer to the first point of the second segment.
@param seg2b2 is a pointer to the second point of the second segment.
@return Returns 0 if no collision, 1 otherwise.
*/
int _segmenttest(const point *seg1b1,const point *seg1b2, const point *seg2b1,const  point *seg2b2)
{



int SENS=0;


#define HORZ 1
#define VERT 2

    if(abs(seg1b1->x-seg1b2->x)==0)
        SENS=VERT; /*car la variation en x est nulle*/
    if(abs(seg1b1->y-seg1b2->y)==0)
        SENS=HORZ; /*car la variation en y est nulle*/
    
    
   
    switch(SENS){
        case VERT:  if((seg1b1->x != seg2b1->x-1) && (seg1b1->x != seg2b1->x+1) && (seg1b1->x != seg2b1->x))
                        return 0; /*si les segments sont pas colls l'un  l'autre ni superposs*/
        
                      if(abs(seg1b1->y - seg1b2->y)>= abs(seg2b1->y - seg2b2->y))
                        { /*si le premier segment est plus long que le second*/
                        /*alors ncessairement collision = un des points de seg2 appartient  seg1*/
                            
                            if(seg2b1->y>=seg1b1->y)
                                if(seg2b1->y<=seg1b2->y)
                                    return 1;
                            if(seg2b2->y>=seg1b1->y)
                                if(seg2b2->y<=seg1b2->y)
                                    return 1;   
                        }
                        
                      if(abs(seg1b1->y-seg1b2->y)<abs(seg2b1->y-seg2b2->y))
                        { /*resp. si le second seg. est le plus long....*/
                            if(seg1b1->y>=seg2b1->y)
                                if(seg1b1->y<=seg2b2->y)
                                    return 1;
                            if(seg1b2->y>=seg2b1->y)
                                if(seg1b2->y<=seg2b2->y)
                                    return 1; 
                        }  
                        break;
        
        case HORZ:
                if((seg1b1->y!=seg2b1->y)&&(seg1b1->y!=seg2b1->y-1)\
                                &&(seg1b1->y!=seg2b1->y+1))
                        return 0;  
                if(abs(seg1b1->x-seg1b2->x)>=abs(seg2b1->x-seg2b2->x))
                        {
                            if(seg2b1->x>=seg1b1->x)
                                if(seg2b1->x<=seg1b2->x)
                                    return 1;
                            if(seg2b2->x>=seg1b1->x)
                                if(seg2b2->x<=seg1b2->x)
                                    return 1;
                        }
                        
                if(abs(seg1b1->x-seg1b2->x)<abs(seg2b1->x-seg2b2->x))
                        {
                            if(seg1b1->x>=seg2b1->x)
                                if(seg1b1->x<=seg2b2->x)
                                    return 1;
                            if(seg1b2->x>seg2b1->x)
                                if(seg1b2->x<seg2b2->x)
                                    return 1;
                        }  
                        break;
        } /* fin du switch*/
    return 0;
}
                        
        
        
        
        
        
        
        
/** Test if one point belongs to a given segment.
@param pt is a pointer to the point.
@param segb1 is a pointer to the first point of the segment.
@param segb2 is a pointer to the second point of the segment.
@return 0 if no collision, 1 otherwise.
*/
int _ptsegtest(const point *pt, const point *segb1, const point *segb2)
{
    int SENS=0;
    
    if(abs(segb1->x - pt->x)<2)
        SENS=VERT; /*car la variation en x est nulle*/
    if(abs(segb1->y - pt->y)<2)
        SENS=HORZ; /*car la variation en y est nulle*/
    
    if(!SENS)
        {
        return 0;
        }
     
    
    if(SENS==VERT) 
        {
             if((segb1->y > segb2->y))
                {
                if((pt->y-2 < segb1->y) && (pt->y+2 > segb2->y))
                    return 1;
                else return 0;
                }
                
             if((segb1->y < segb2->y))
                {
                if((pt->y+2 > segb1->y) && (pt->y-2 < segb2->y))
                    return 1;
                else return 0;
                }
            
         }
       
    if(SENS==HORZ) 
        {
             if((segb1->x > segb2->x))
                {
                if((pt->x-2 < segb1->x) && (pt->x+2 > segb2->x))
                    return 1;
                else return 0;
                }
                
            if((segb1->x < segb2->x))
                {
                if((pt->x+2 > segb1->x) && (pt->x-2 < segb2->x))
                    return 1;
                else return 0;
                }
            
         }          
        
    

return 0;
}

