/*
Copyright (c) 2005    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

/** \file campaign.c
Handling of campaign
*/

extern int USE_TIMERS;
extern int DO_BENCHMARK;
extern char level_file[250];
extern char campaign_file[250];
extern int game_return_code;
static liveplayer * player_to_teleport;
static short int cur_destcode;
static char do_tlpt;

/** Open a campaign file for reading
@param cmpfile is the path to the file to open.
@return Returns -1 on error, 0 otherwise.
@see close_campaign_file()
*/
int open_campaign_file(const char *cmpfile)
{
campaign_xml_file = fopen(cmpfile,"r");
if(campaign_xml_file == NULL)
    return -1;
return 0;
}

/** Close the current campaign file
@return Returns always 0.
@see open_campaign_file()
*/
int close_campaign_file()
{
fclose(campaign_xml_file);
return 0;
}

/** Start the campaign. This function runs the game with the first levelfile of the "campaign".
@return Returns always 0.*/
int run_campaign() 
{
if(!strlen(level_file))
	sprintf(level_file, "%s", "level_test.xml");
if(!open_lvl_file(level_file))
        {
        log_msg(2,"Parsing levelfile");
        if(parse_level_data())
                log_msg(0, "parse_level_data() seems to have aborted");
        close_lvl_file();
        log_msg(1,"Levelfile closed...");
        }
    else
        {
        perror("Opening level file ");
        exit(-1);
        }

cur_level = 1;

log_msg(2, "Rendering platforms");
render_platforms();
update_liveplatforms_sprites();

	if(USE_TIMERS)
		{
		log_msg(1,"Calling game()");
		game();
		}
	else
		{
		log_msg(1,"Calling game_no_timers()");
		game_no_timers();
		}
return 0;
}


/** Ask for a teleportation of a player.
@param plnb is the number of the player that is to be teleported. Currently, this value must be 0.
@param destcode is the destination code of the teleporter. This short int is used to address both a level and a teleporter inside. The 8 strongest bits contain the level-id, whereas the 8 weakest contain the teleporter-id.\
Using 0 for the levelcode indicates a local teleportation - ie., within the same level.
Using 0 for the portalcode tells the engine to use the standard entry point of the new level.
Using 0 for both (destcode = 0) is the end of the game.
@return Returns always 0.
@see handle_pending_teleportation()
*/
int set_teleportation(liveplayer * pl, short int destcode)
{
if(do_tlpt) return 0;
do_tlpt = 1;
player_to_teleport = pl;
cur_destcode = destcode;
return 0;
}


/** Do a pending teleportation. Teleport a player if the engine was asked to earlier.
@return Returns 2 if gameover, 1 or 0 in other cases.
@see set_teleportation
*/
int handle_pending_teleportation()
{
#define GET_LEVEL_CODE(X) (X >> 8)
#define GET_PORTAL_CODE(X) (X & 0xff)
#define ZL_ENDLVL 2
if(!do_tlpt)
        return 0;
else do_tlpt = 0;

liveplayer * pl = player_to_teleport;
       if(cur_destcode == 0)
                {
                log_msg(1, "Reached endpoint - game over !");
                add_scheduler_dispfnct(display_schedmsg, 1, "GAME OVER", 150, "GAME OVER banner");
                zl_screen_msgbox("Endpoint", "This is an endpoint. The game is now over !", ZL_MESSAGE_BUTTONBOX, "Quit");
                /*runtime_level_loader("level_test.xml");*/
                game_return_code = ZL_ENDLVL;
                return 2;
                }
        else
                {
                if(GET_LEVEL_CODE(cur_destcode))
                        {
			switch(GET_LEVEL_CODE(cur_destcode))
				{
				case 1: sprintf(level_file, "level_test.xml"); break;
				case 2: sprintf(level_file, "level_test2.xml"); break;
				}
		//	zl_screen_msgbox("Warper", "You are about to be warped to another level !", ZL_MESSAGE_BUTTONBOX, "Teleport");
			runtime_level_loader(level_file);
			obj_db.screen_pos.x = 0;
			obj_db.screen_pos.y = 0;
			cur_level = GET_LEVEL_CODE(cur_destcode);
                        if(GET_PORTAL_CODE(cur_destcode))
                                {
				portal * plrot = obj_db.portal_head;
				while(plrot)
					{
					if(plrot->id == (char)GET_PORTAL_CODE(cur_destcode))
						{
						pl->refpt = plrot->position;
						plrot->state |= INHIBIT_TELEPORTER;
						return 0;
						}
					plrot = GETNEXT(plrot);
					}
				log_msg(0, "Unable to find warper destination !");
                                }
                        return 0;
                        }
                else /*local teleportation*/
                        {
                        zl_screen_msgbox("Warper", "You are about to be warped somewhere else in this level !", ZL_MESSAGE_BUTTONBOX, "Teleport");
			portal * prt = obj_db.portal_head;
                        while(prt)
                                {
                                if(prt->id == (char)GET_PORTAL_CODE(cur_destcode))
                                        {
                                        pl->refpt = prt->position;
                                        prt->state |= INHIBIT_TELEPORTER;
                                        return 0;
                                        }
				prt = GETNEXT(prt);
                                }
                        log_msg(0, "Unable to find warper destination !");
                        return 1;
                        }
                }
return 1;
}
