/*

Copyright (c) 2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"    

/** \file anim.c
Functions related to sprites
*/

/*temporary animation function*/  

/** Animate the objects in the game. This function calls animate_player() for all players and enemies.
@see animate_player()
@return Returns always 0.*/
int cycle_object_sprites()
{
liveplayer * plrot = obj_db.liveplayer_head;
while(plrot)
	{
        animate_player(plrot);
	plrot = GETNEXT(plrot);
	}
plrot = obj_db.enemy_head;
while(plrot)
	{
        animate_player(plrot);
	plrot = GETNEXT(plrot);
	}	
return 0;        
}

/** Change sprites of player. Cycles the sprites of a liveplayer to animate its movement. It is called by cycle_object_sprites().
@param target is a pointer to the liveplayer structure tied to the player to animate.
@see cycle_object_sprites()
@return Returns always 0.*/
int animate_player(liveplayer *target)
{
/*cycle sprites*/
if(target->state & ZL_SPRITE_ANIMATE)
        {
        target->sprite_delay++;
        if(target->sprite_delay == 10)
                {
                target->sprite_delay = 0;
                if(target->current_sprite->NEXT && !(target->state & SPR_REVERSE))
                        {
                        /*log_msg(3, "Cycling sprite of player at %x to NEXT : %x -> %x", target, target->current_sprite, target->current_sprite->NEXT);*/
                        target->current_sprite = (zl_sprite *)target->current_sprite->NEXT;
                        if( !target->current_sprite->NEXT)
                                while(target->current_sprite->PREV)
					target->current_sprite = target->current_sprite->PREV;
                        }
                else
                        {
                        /*log_msg(3, "Cycling sprite of player at %x to PREV : %x -> %x", target, target->current_sprite, target->current_sprite->PREV);*/
                        target->current_sprite = (zl_sprite *)target->current_sprite->PREV;
                        if( !target->current_sprite->PREV)
                                target->state &= ~SPR_REVERSE;

                        }
               }
        }
return 0;
}

/** Render platforms pictures. This function generates the sprite of each platform by alternating the base tiles randomly.
@return Returns always 0.
*/
int render_platforms()
{
wall * target = obj_db.wall_head;

while(target)
        {
        sprset pool;
        /*create the bitmap*/
	target->sprite = create_bitmap(target->xsize, target->ysize);
        clear_bitmap(target->sprite);
                
        if(!(pool = search_spritesetdb_entry(spriteset_db, target->spriteset)))
                {
                spriteset_db = add_spritesetdb_entry(spriteset_db, target->spriteset, PFORM_SPRSET);
                pool = search_spritesetdb_entry(spriteset_db, target->spriteset);
                }
                
	/*the edges*/
        blit(pool[SPRSET_EDGE_LEFT][0].spr, target->sprite, 0, 0, 0, 0, pool[SPRSET_EDGE_LEFT][0].spr->w, pool[SPRSET_EDGE_LEFT][0].spr->h);

        
        /*now proceed to the center*/
        for(int xpos = pool[SPRSET_EDGE_LEFT][0].spr->w; xpos < target->sprite->w - pool[SPRSET_EDGE_LEFT][0].spr->w;)
                {
                zl_sprite * std;
                zl_sprite * rd1;
                zl_sprite * rd2;
                BITMAP * source;
                std = &pool[SPRSET_CENTER][0];
                rd1 = (zl_sprite *)std->NEXT;
                if(! rd1) rd1 = std;
                rd2 = (zl_sprite *)rd1->NEXT;
                if(! rd2) rd2 = rd1;
                
                source = std->spr;
                if((rand() % 20) >= 18) 
                        {
                        source = rd1->spr;
                        }
                else if((rand() % 20) == 19)
                                source = rd2->spr;

                blit(source, target->sprite, 0, 0, xpos, 0, source->w, source->h);
                xpos += source->w;
                }
                blit(pool[SPRSET_EDGE_RIGHT][0].spr, target->sprite, 0, 0, target->sprite->w - pool[SPRSET_EDGE_RIGHT][0].spr->w , 0, pool[SPRSET_EDGE_RIGHT][0].spr->w, pool[SPRSET_EDGE_RIGHT][0].spr->h);
	target = GETNEXT(target);
        }
        
return 0;
}

/** Render a livewall's sprite. This function takes a livewall and generates a picture for it with randomness.
@param lwlnb is the livewall number for which to render a sprite
@return Returns always 0.
*/
int render_lwall(livewall * target)
{
sprset pool;
if(target->sprite)
	return -1;

target->sprite = create_bitmap(target->max_size.x, target->max_size.y);
log_msg(3, "New platform bitmap at %x", target->sprite);

clear_bitmap(target->sprite);


if(!(pool = search_spritesetdb_entry(spriteset_db, target->spriteset)))
        {
        spriteset_db = add_spritesetdb_entry(spriteset_db, target->spriteset, PFORM_SPRSET);
        pool = search_spritesetdb_entry(spriteset_db, target->spriteset);
        }

/*the edges*/
target->edgeleft = &pool[SPRSET_EDGE_LEFT][0].spr;
target->edgeright = &pool[SPRSET_EDGE_RIGHT][0].spr;

/*now proceed to the center*/

int xpos = 0;
while( xpos < target->sprite->w)
        {
        zl_sprite * std;
        zl_sprite * rd1;
        zl_sprite * rd2;
        BITMAP * source;
        std = &pool[SPRSET_CENTER][0];
        rd1 = (zl_sprite *)std->NEXT;
        if(! rd1) rd1 = std;
        rd2 = (zl_sprite *)rd1->NEXT;
        if(! rd2) rd2 = rd1;
        
        source = std->spr;
        if((rand() % 20) >= 18) 
                {
                source = rd1->spr;
                }
        else if((rand() % 20) == 19)
                        source = rd2->spr;
        
        blit(source, target->sprite, 0, 0, xpos, 0, source->w, source->h);
        xpos += source->w;
        }

return 0;
}

/** Update the sprites of the liveplatforms. Some liveplatforms have a size that varies, this function basically handles the redrawing of such lpforms.
@return Returns always 0.
@see render_lwall()
*/
int update_liveplatforms_sprites()
{
livewall * target = obj_db.livewall_head;
while(target)
        { /*for each lpform, check whether it has to be redrawn and do it*/
        if(!target->sprite)
                render_lwall(target);
	target = GETNEXT(target);
        }
return 0;
}

/******************************************************************************
SPRITES DATABASE HANDLING
*******************************************************************************/
/*SPRITESET LEVEL 2*/

/*allocation mmoire, libration*/

/** Search for an entry in a spritesetdb. This function is a "level 2" (database of spritesets) sprite database handling helper.
@param db the pointer to the spriteset db in which to search
@param clef the textual key to look for
@return A pointer to the entry or NULL.
@see add_spritesetdb_entry()
*/
sprset search_spritesetdb_entry(sprset_entry * db, char * clef)
{
SEARCH_XSETDB_ENTRY(sprset)
}



/** Add a spriteset into the spriteset database. This function is a "level 2" sprite database handling helper.
@param target is the first element of the linked list of spriteset to which the spriteset is to be added.
@param clef is the textual key to associate to the spriteset
@param type is the type of the spriteset, e.g. PLAYER_SPRSET or PFORM_SPRSET
@return Returns a pointer to the new first element of the linked list, which is also the element that has just been added.
*/
sprset_entry * add_spritesetdb_entry(sprset_entry * target, char * clef, int type)
{
ADD_XSETDB_ENTRY(sprset)
}


/** Free the spriteset database. This function frees the memory used by the spriteset database. This is a level 2 function.
@param db is a pointer to the firtst element of the spriteset database
@return Returns always 0.
*/
int free_spritesetdb(sprset_entry * db)
{
FREE_XSETDB_ENTRY(sprset)
}

/*SPRITE SET LEVEL 1*/
/** Fill in a spriteset. This function loads the sprites associated to a spriteset. This a a level 1 function (spriteset related).
@param target is a pointer to the target spriteset
@param dir is a string containing the path where to search for the files
@param type is the type of spriteset, currently it is used to know what files are to be loaded
@return Returns 0 on success, 1 on failure.
*/
int fill_sprset(sprset * target, char * dir, int type)
{

char path[250];
memset(path, 0, 250);
sprintf(path, "%s/%s/", TILESDIR, dir);
switch(type)
        {
        case PLAYER_SPRSET :
        log_msg(3, "Spriteset level 1 function : fill_sprset. Filling player spriteset.");
        (*target) = (zl_sprite **)calloc(2, sizeof(zl_sprite *));
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d16.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d15.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d14.png", USE_FALLBACK);
	(*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d13.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d12.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d11.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d10.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d9.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d8.png", USE_FALLBACK);
	(*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d7.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d6.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d5.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d4.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d3.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d2.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d1.png", USE_FALLBACK);
	
	(*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g16.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g15.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g14.png", USE_FALLBACK);
	(*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g13.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g12.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g11.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g10.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g9.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g8.png", USE_FALLBACK);
	(*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g7.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g6.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g5.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g4.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g3.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g2.png", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g1.png", USE_FALLBACK);
        return 0;
        
        case PFORM_SPRSET :
        log_msg(3, "Spriteset level 1 function : fill_sprset. Filling platform spriteset.");
        (*target) = (zl_sprite **)calloc(3, sizeof(zl_sprite *));
        (*target)[SPRSET_EDGE_LEFT] = add_zl_sprite_entry((*target)[SPRSET_EDGE_LEFT], path, "edgeleft.bmp", NO_FALLBACK);
        (*target)[SPRSET_EDGE_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_EDGE_RIGHT], path, "edgeright.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerdeco2.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerdeco1.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerstd.bmp", NO_FALLBACK);
        return 0;
	
	case BANANA_SPRSET :
	(*target) = (zl_sprite **)calloc(1, sizeof(zl_sprite *));
	(*target)[0] = add_zl_sprite_entry((*target)[0], path, "banana.png", NO_FALLBACK);
	return 0;
        }


return 1;
}



/** Free a spriteset. This function frees a spriteset, it's a level 1 function called by free_spritesetdb.
@param target is a pointer to the spriteset to free
@param type is the type of the spriteset
@see free_spritesetdb()
@return Returns always 0.
*/
int free_sprset(sprset * target, int type)
{
switch(type)
        {
        case PLAYER_SPRSET :
        log_msg(3, "Spriteset level 1 function : free_sprset. Freeing player spriteset.");
        free_zl_sprite((*target)[SPRSET_GOING_LEFT]);
        free_zl_sprite((*target)[SPRSET_GOING_RIGHT]);
        free(*target);
        return 0;
        
        case PFORM_SPRSET : 
        log_msg(3, "Spriteset level 1 function : free_sprset. Freeing platform spriteset.");
        free_zl_sprite((*target)[SPRSET_EDGE_LEFT]);
        free_zl_sprite((*target)[SPRSET_EDGE_RIGHT]);
        free_zl_sprite((*target)[SPRSET_CENTER]);
        free(*target);
        return 0;
        }
        
return 0;
}    
    
    
    

/*SPRITE SET LEVEL 0*/    
/*linked list handling*/

/** Add a sprite into a spriteset. This is a "level 0" (sprite related) function.
@param target is a pointer to the first element of the spriteset
@param path is the path of the file
@param file is the filename
@param opt is an option which can take two values : USE_FALLBACK, or NO_FALLBACK. USE_FALLBACK will enable the generation of a fallback sprite if the file cannot be loaded.
@return Returns a pointer to the new first element of the spriteset.
*/
zl_sprite * add_zl_sprite_entry(zl_sprite * target, char * path, char * file, int opt)
{
        /*create the new node*/
zl_sprite *new_obj = (zl_sprite *)calloc(1, sizeof(zl_sprite));
        /*load the specified bitmap*/
if(!file) log_msg(3, "Spriteset direct call : creating new sprite node.");
if(file)
	{
	log_msg(3, "Spriteset level 0 function : add_zl_sprite_entry. Adding sprite %s%s to the set.", path, file);
	char * final_path = (char *)calloc(1, strlen(path) + strlen(file) + 10);
	if(file[0] == 'g') sprintf(final_path, "%sd%s", path, file+1);
	else sprintf(final_path, "%s%s", path, file);
	if(strstr(final_path, ".png"))
		new_obj->spr = load_png(final_path, NULL);
	else new_obj->spr = load_bitmap(final_path, NULL);
	if( ! (new_obj->spr)) 
		{
		if(opt == USE_FALLBACK)
			{
			log_msg(0, "Bitmap loading of %s failed, falling back to default sprite (level 0 fallback)", final_path);
			memset(final_path, 0, strlen(final_path));
			sprintf(final_path, "%sfallback.bmp", path);
			if(! (new_obj->spr = load_bitmap(final_path, NULL)))
				{
                                log_msg(0, "Fallback bitmap not loaded, using emergency fallback bitmap !");
                                new_obj->spr = create_bitmap(80, 90);
                                clear_bitmap(new_obj->spr);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 0, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 0, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 15, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 30, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 45, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 60, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 75, 4, 255);
				}
			}
		else 
			{
			log_msg(0, "Loading of bitmap %s failed", final_path);
			new_obj->spr = NULL;
			}
		}
	if(file[0] == 'g')
		{
		BITMAP * newb = create_bitmap(new_obj->spr->w, new_obj->spr->h);
		clear_to_color(newb, bitmap_mask_color(newb));
		draw_sprite_h_flip(newb, new_obj->spr, 0, 0);
		destroy_bitmap(new_obj->spr);
		new_obj->spr = newb;
		}
	free(final_path);
	}
        

if(target)
	{
	new_obj->NEXT = target;
	target->PREV = new_obj;
	}
	
target = new_obj;
return new_obj;
}


/** Free a spriteset. Level 0 function.
@param target is a pointer to the first element of the spriteset that will be freed.
@return Returns always 0.
*/
int free_zl_sprite(zl_sprite * target)
{
log_msg(3, "Spriteset level 0 function : free_zl_sprite. Freeing spriteset.");
zl_sprite * entry_rot = target;
zl_sprite * nextptr;

while(entry_rot)
        {
        nextptr = (zl_sprite *)entry_rot->NEXT;
        free(entry_rot);
        entry_rot = nextptr;
        }

return 0;
}    
