/*

Copyright (c) 2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"

/** \file sound.c
Handles the sound samples used by the game.
*/

/** Fill in a soundset.
@param target is the soundset in which to load the sound files
@param dir is the directory where the files are located
@param type is unused yet.
@return Returns -1 on error, 0 otherwise.
*/
int fill_sndset(sndset * target, char * dir, int type)
{
(*target) = (sndset)calloc(1, sizeof(SAMPLE *));
(*target)[0] = load_sample("test.wav");
if(!(*target)[0])
	log_msg(0, "Error loading sound sample");
type = 0;
dir = NULL;
return 0;
}

/** Free a soundset.
@param target is the soundset to clean up.
@param type is unused yet.
@return Returns always 0.
*/
int free_sndset(sndset * target, int type)
{
destroy_sample((*target)[0]);
free(*target);
type =  0;
return 0;
}

/** The database of soundsets
*/
sndset_entry * soundset_db;

/** Search for a soundset in the database, given the key.
@param db is the soundset database
@param clef is the key to look for
@return Returns the soundset or 0 if not found.
*/
sndset search_soundsetdb_entry(sndset_entry * db, char * clef)
{
SEARCH_XSETDB_ENTRY(sndset)
}

/** Add a soundset to the database
@param db is the database
@param clef is the key of the spriteset to add
@param type is unused yet
@return Returns a pointer to the new first element of the database.
*/
sndset_entry * add_soundsetdb_entry(sndset_entry * target, char * clef, int type)
{
ADD_XSETDB_ENTRY(sndset)
}

/** Frees a soundset database.
@param db is the database to free.
@return Returns always 0.
*/
int free_soundsetdb(sndset_entry * db)
{
FREE_XSETDB_ENTRY(sndset)
}
