/*

Copyright (c) 2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"
    
/** Open a savegame file for writing
@param filename is the name of the file
@return -1 on error, 0 otherwise
*/
int create_savefile(char * filename)
{
zl_savefile = fopen(filename, "w");
/*setvbuf(zl_savefile, NULL, _IONBF, 0);*/
if(zl_savefile)
        return 0;
else return -1;
}

/** Load a savegame
@param filename is the name of the file
@see close_savefile()
@return 0 if it's okay, otherwise -1, but the program will most likely have crashed before
*/
int load_savefile(char *filename)
{ /*well, it would be a good thing to have no error right here, otherwise we will kill the whole game*/
open_lvl_file(filename);
if(! level_xml_file) return -1;

fin_instances(1);
liveplayer *PlToRegister;
wall *WlToRegister;
livewall * lWlToRegister;
killing_line * KlToRegister;
portal * PortalToRegister;

int done = 0;
int GetLineState;
char *TempLine;
TempLine = (char *)calloc(1, 5000);
PlToRegister = (liveplayer *)calloc(1, sizeof(liveplayer));
WlToRegister = (wall *)calloc(1, sizeof(wall));
lWlToRegister = (livewall *)calloc(1, sizeof(livewall));
KlToRegister = (killing_line*)calloc(1, sizeof(killing_line));
PortalToRegister = (portal *)calloc(1, sizeof(portal));
banana * BananaToRegister = (banana *)calloc(1, sizeof(banana));
GetLineState = get_level_line(TempLine);
while(!done)
    {
    if(strstr(TempLine,"fileinfo"))
        {
        /*log_msg(3, "Parsing and displaying fileinfo from line %s", TempLine);
        display_level_info(TempLine);*/
        }

    if(strstr(TempLine, "<liveplayer"))
        {
	int isfirst = 0;
        if(!obj_db.liveplayer_head)
		{
		isfirst = 1;
		}
        read_liveplayer(TempLine, PlToRegister);
	obj_db.liveplayer_head = add_player_to_database(obj_db.liveplayer_head, PlToRegister);
	//if(isfirst) cur_player = obj_db.liveplayer_head;
        }
        
    if(strstr(TempLine,"<enemy"))
        {       
        read_liveplayer(TempLine, PlToRegister);
	obj_db.enemy_head = add_player_to_database(obj_db.enemy_head, PlToRegister);
        }
        
    if(strstr(TempLine,"<wall"))
        {
        read_wall(TempLine, WlToRegister);
	obj_db.wall_head = add_wall_to_database(obj_db.wall_head, WlToRegister);
	}
     
    if(strstr(TempLine,"<kline") || strstr(TempLine, "<killing_line"))
    	{	
    	read_killing_line(TempLine, KlToRegister);
	obj_db.killing_line_head = add_killing_line_to_database(obj_db.killing_line_head, KlToRegister);
    	}

    if(strstr(TempLine,"<platform") || strstr(TempLine, "<livewall"))
        {
	read_livewall(TempLine, lWlToRegister);
	obj_db.livewall_head = add_livewall_to_database(obj_db.livewall_head, lWlToRegister);
        }
if(strstr(TempLine, "<banana"))
	{
	return_banana(TempLine, BananaToRegister);
	obj_db.banana_head = add_banana_to_database(obj_db.banana_head, BananaToRegister);
	}
    
    if(strstr(TempLine, "<portal"))
	{
	read_portal(TempLine, PortalToRegister);
	obj_db.portal_head = add_portal_to_database(obj_db.portal_head, PortalToRegister);
	}
 
    if(strstr(TempLine, "<madmaker"))
	{
	obj_db.madmaker_head = (madmaker *)calloc(1, sizeof(madmaker));
	read_madmaker(TempLine, obj_db.madmaker_head);
	}  
    GetLineState=get_level_line(TempLine);
    
    if(strstr(TempLine,"EndOfFile")|| GetLineState)
        {
        done=1;
        }
        
        
    }
    
    
free(TempLine);
free(PlToRegister);
free(WlToRegister);
free(lWlToRegister);
free(KlToRegister);
free(PortalToRegister);
close_lvl_file();
log_msg(1, "Game loaded !");
return 0;
}

/** Load the binary data and link it to the data structure. This function is used when loading a savegame.
@return Returns always 0.
*/
int zl_load_link_binary_data()
{ /*now, find again the sprites*/
liveplayer * target;

for(int i = 0; i < 2; i++)
        {
	if(!i) target = obj_db.liveplayer_head;
	else target = obj_db.enemy_head;
	
	while(target)
		{
		if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key)))
			{
			spriteset_db = add_spritesetdb_entry(spriteset_db, target->sprset_key, PLAYER_SPRSET);
			target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key);
			}
		if(! (target->soundset = search_soundsetdb_entry(soundset_db, target->sndset_key)))
			{
			soundset_db = add_soundsetdb_entry(soundset_db, target->sndset_key, 0);
			target->soundset = search_soundsetdb_entry(soundset_db, target->sndset_key);
			}
		
		if(IS_GOING_LEFT(target))
			target->current_sprite = target->spriteset[SPRSET_GOING_LEFT];
		else
			target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT];
                
		target->state &= ~ SPR_REVERSE;
		target = GETNEXT(target);
		}
	}
        
render_platforms();
return 0;
}

/** Close the savegame after it's been written
@return Returns always 0.
@see create_savefile()
*/
int close_savefile()
{
fclose(zl_savefile);
return 0;
}

/** Save a string into the savefile
@param parameter is the name of the parameter
@param value is the value associated to it
@return Returns always 0.
*/
int save_string(char *parameter, char* value)
{
fprintf(zl_savefile, "%s=\"", parameter);

unsigned int i = 0;
for(i = 0; i < strlen(value); i ++)
        if(value[i] == '"')
                fprintf(zl_savefile, "*");
        else fprintf(zl_savefile, "%c", value[i]);
        
fprintf(zl_savefile, "\" ");
return 0;
}

/** Save an integer into the savefile
@param parm is the name of the parameter
@param val is the value associated to it
@return Returns always 0.
*/
int save_int(char *parm, int val)
{
fprintf(zl_savefile, "%s=\"%i\" ", parm, val);
return 0;
}

/** Save a float into the savefile
@param parm is the name of the parameter
@param val is the value associated to it
@return Returns always 0.
*/
int save_float(char *parm, float val)
{
fprintf(zl_savefile, "%s=\"%f\" ", parm, val);
return 0;
}

/** Save a char into the savefile
@param parm is the name of the parameter
@param val is the value associated to it
@return Returns always 0.
*/
int save_char(char *parm, char val)
{
fprintf(zl_savefile, "%s=\"%c\" ", parm, val);
return 0;
}

/** Save a point into the savefile
@param parm is the name of the parameter
@param pt is the value associated to it
@return Returns always 0.
*/
int save_point(char *parm, point pt)
{
fprintf(zl_savefile, "%s.x=\"%i\" %s.y=\"%i\" ", parm, pt.x, parm, pt.y);
return 0;
}

/** Save a speed into the savefile
@param parm is the name of the parameter
@param spd is the value associated to it
@return Returns always 0.
*/
int save_speed(char *parm, speed spd)
{
fprintf(zl_savefile, "%s.x=\"%f\" %s.y=\"%f\" ", parm, spd.x, parm, spd.y);
return 0;
}

/** Save zignals into the savefile
@param parm is the name of the parameter
@param zig is the value associated to it
@return Returns always 0.
*/
int save_zignals_t(char *parm, zignals_t zig)
{
int zigrot=0;
        /*short int mask;
        int parm[16][2];*/
fprintf(zl_savefile, "%s.mask=\"%i\" ", parm, zig.mask);
for(zigrot=0; zigrot < 16; zigrot++)
        fprintf(zl_savefile, "%s.parm%i_0=\"%i\" %s.parm%i_1=\"%i\" ", parm, zigrot, zig.parm[zigrot][0], parm, zigrot, zig.parm[zigrot][1]);
return 0;
}

/** Save effectors into the savefile
@param parm is the name of the parameter
@param eft is the value associated to it
@return Returns always 0.
*/
int save_effectors_t(char *parm, effectors_t eft)
{
/*int is_active;
int armed;*/
fprintf(zl_savefile, "%s.is_active=\"%i\" %s.armed=\"%i\" ", parm, eft.is_active, parm, eft.armed);
return 0;
}

/** Read string from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_string(char * buffer,char * parm, char* target)
{
/*if(buffer && parm)*/
        get_level_string(buffer, parm, "undefined", target);

unsigned int i = 0;
for(i = 0; i < strlen(target); i ++)
        if(target[i] == '*')
                target[i] = '"';

return 0;
}

/** Read point from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_point(char *buffer,char *parm, point *target)
{
/*fprintf(zl_savefile, "%s.x=\"%i\" %s.y=\"%i\" ", parm, pt.x, parm, pt.y);*/
char temp[150];
char parm_name[150];
memset(temp, 0, 150);
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.x", parm);
target->x = atoi(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.y", parm);
target->y = atoi(get_level_string(buffer, parm_name, "0", temp));
return 0;
}

/** Read float from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_float(char *buffer, char *parm, float *target)
{
char temp[150];
*target = atof(get_level_string(buffer, parm, "0.0", temp));
return 0;
}

/** Read speed from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_speed(char *buffer,char *parm, speed *target)
{
char temp[150];
char parm_name[150];
memset(temp, 0, 150);
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.x", parm);
target->x = atof(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.y", parm);
target->y = atof(get_level_string(buffer, parm_name, "0", temp));
return 0;
}

/** Read zignals from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_zignals_t(char *buffer,char *parm, zignals_t *target)
{
char parm_name[150];
char temp[150];
int zigrot;
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.mask", parm);
target->mask = atoi(get_level_string(buffer, parm_name, "0", temp));

for(zigrot=0; zigrot < 16; zigrot++)
        {
        sprintf(parm_name, "%s.parm%i_0", parm, zigrot);
        target->parm[zigrot][0] = atoi(get_level_string(buffer, parm_name, "0", temp));
        sprintf(parm_name, "%s.parm%i_1", parm, zigrot);
        target->parm[zigrot][1] = atoi(get_level_string(buffer, parm_name, "0", temp));
        }


return 0;
}

/** Read effectors from buffer
@param buffer is the line extracted from savefile
@param parm is the name of the parameter to look for
@param target is where to put the value
@return Returns always 0.
*/
int read_effectors_t(char *buffer,char *parm, effectors_t *target)
{
char parm_name[150];
char temp[150];
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.is_active", parm);
target->is_active = atoi(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.armed", parm);
target->armed = atoi(get_level_string(buffer, parm_name, "0", temp));
return 0;
}
/*gnration automatique ?
int save_livewalls
int save_walls
int save_players
int save_klines 
etc.

avec structure similaire : 
une boucle et un pointeur target mis  jour rgulirement*/


#include "sav_autocode.zc"

