#!/bin/bash
echo '##########################################################'
echo '#                   sav_autocode.sh                      #'
echo '#--------------------------------------------------------#'
echo '#      Automatically generates the game saving code      #'
echo '#              using the objects.h file.                 #'
#     #--------------------------------------------------------#'
#     #          Copyright (c) 2004 Arthur Huillet             #'
#     #     This file, as a part of Zlog, is released under    #'
#     #                 the MIT licence.                       #'
echo '##########################################################'


#looking for objects defs
LIGNE_DEBUT_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST BEGINS HERE=-\*\/' objects.h | sed 's/\:.*//'`
echo Object list begins line $LIGNE_DEBUT_OBJETS of objects.h
TEMP1=`mktemp`
TEMP2=`mktemp`
tail -n +`expr $LIGNE_DEBUT_OBJETS + 1` objects.h > $TEMP1
LIGNE_FIN_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST ENDS HERE=-\*\/' $TEMP1 | sed 's/\:.*//'`
echo Object list ends line `expr $LIGNE_FIN_OBJETS + $LIGNE_DEBUT_OBJETS` of objects.h
cat $TEMP1 | sed `expr ${LIGNE_FIN_OBJETS} - 1`q > $TEMP2
rm $TEMP1
echo Object list stored at $TEMP2

#looking for object database
LIGNE_DEBUT_OBJDB=`grep -n '\/\*-=OBJ DATABASE BEGINS=-\*\/' $TEMP2 | sed 's/\:.*//'`
LIGNE_DEBUT_OBJDB=`expr $LIGNE_DEBUT_OBJDB + 1`
echo Object database begins line $LIGNE_DEBUT_OBJDB of $TEMP2
OBJ_DB=`mktemp`
tail -n +$LIGNE_DEBUT_OBJDB $TEMP2 > $OBJ_DB

#object database parsing
TEMP1=`mktemp`
cat $OBJ_DB | egrep -v '{|}|int |\[' | sed 's/\*/-/;' > $TEMP1
rm sav_autocode.zc
rm sav_autocode.zh
echo Now parsing 
#cat $TEMP1
#remove { and } to keep only structure members, 
#remove int to keep only structure pointers 
#remove [ because we do not want weapons or bullets
#sed because the shell doesn't like stars much
i=2

AUTOREAD_TMP=`mktemp`

echo 'int zl_save_game()
{
' >> sav_autocode.zc

while test "$i" -le "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	TYPE=`echo $LIGNE | sed 's/ -.*//'`
	echo Writing code for $TYPE
	#code du .h
	echo 'int save_'$TYPE'('$TYPE' *);' >> sav_autocode.zh
	echo 'int read_'$TYPE'(char *, '$TYPE' *);' >> sav_autocode.zh
	#code du .c
	echo $TYPE' * obj'$TYPE' = obj_db.'$TYPE'_head;' >> sav_autocode.zc
	echo '        while (obj'$TYPE'){' >> sav_autocode.zc
	echo '        save_'$TYPE'(obj'$TYPE');
	obj'$TYPE' = GETNEXT(obj'$TYPE');
	}
	' >> sav_autocode.zc

	i=`expr $i + 1`
	done

echo 'close_savefile();
log_msg(1, "Game saved successfully");
return 0;
}' >> sav_autocode.zc


# ce point on a tous les for, il faut maintenant lire chaque structure et 
#crer save_xx()
#c'est pas du gteau mais je vais russir.
#plus besoin de obj_db ni de temp1, on relit carrment depuis le dbut
rm $OBJ_DB
rm $TEMP1
TEMP1=`mktemp`
cat $TEMP2 | egrep -v '{|}' > $TEMP1
rm $TEMP2

#cat $TEMP1
#premire boucle qui va faire crer les <liveplayer
i=1
while test "$i" -lt "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	if [ "$LIGNE" = '/*-=OBJ DATABASE BEGINS=-*/' ]; then
		i=50000
	fi
	#si la ligne dcrit un nouvel objet (/*-=_liveplayer_=-*/)
	SI_OBJET=`echo $LIGNE | egrep '\-\=_.*_\=\-'`
	if [ $SI_OBJET ]; then
		TYPE=`echo $SI_OBJET | sed 's/\/\*\-\=_//; s/_\=\-\*\///;'`
		echo Creating : save_$TYPE'()'
		echo 'int save_'$TYPE'('$TYPE' * target)
{' >> sav_autocode.zc
		echo 'fprintf(zl_savefile, "<'$TYPE' ");' >> sav_autocode.zc 
		echo Creating : read_$TYPE'()'
		echo 'int read_'$TYPE'(char * buffer, '$TYPE' * target)
{
char temp[100];
memset(temp, 0, 100);' >> $AUTOREAD_TMP

	fi
	#si la ligne indique la fin d'un objet
	SI_FIN=`echo $LIGNE | egrep 'ENDOFSTRUCT'`
	if [ $SI_FIN ]; then
		echo End of function
		echo 'fprintf(zl_savefile, " >\n");' >> sav_autocode.zc
		echo '
return 0;
}
' >> sav_autocode.zc
		echo '
return 0;
}
' >> $AUTOREAD_TMP
	fi

	if [ ! $SI_OBJET ]; then
		if [ ! $SI_FIN ]; then
			PAS_COMMENTAIRE=`echo $LIGNE | egrep -v '\/\*AUTOCODE_SKIP\*\/'`
			PAS_COMMENTAIRE=`echo "$PAS_COMMENTAIRE" | sed 's,/\**.*,,'`
			PAS_COMMENTAIRE=`echo "$PAS_COMMENTAIRE" | sed 's,.*\*/,,'`
			PAS_COMMENTAIRE=`echo "$PAS_COMMENTAIRE" | sed 's,\*,_ETOILE_,'`
			if [ "${PAS_COMMENTAIRE}" ]; then
				#echo "$PAS_COMMENTAIRE"
				#on vire les qualificatifs
				LIGNE=`echo $PAS_COMMENTAIRE | sed 's/unsigned //; s/short //'`
				TYPE_VARIABLE=`echo $LIGNE | sed 's/ .*;$//'`
				NOM_VARIABLE=`echo $LIGNE | sed 's/^.* //; s/;//'`

		
				#echo Variable de type $TYPE_VARIABLE, nom $NOM_VARIABLE
				if [ $TYPE_VARIABLE != "char" ]; then
					echo 'save_'$TYPE_VARIABLE'("'$NOM_VARIABLE'", target->'$NOM_VARIABLE');' >> sav_autocode.zc
					if [ $TYPE_VARIABLE != "int" ]; then
						echo 'read_'$TYPE_VARIABLE'(buffer, "'$NOM_VARIABLE'", &(target->'$NOM_VARIABLE'));' >> $AUTOREAD_TMP
					else
						echo 'target->'$NOM_VARIABLE' = atoi(get_level_string(buffer, "'$NOM_VARIABLE'", "0", temp));
memset(temp, 0, strlen(temp));' >> $AUTOREAD_TMP
					fi
				fi
				#on met les char  part  cause des chanes statiques
				if [ $TYPE_VARIABLE = "char" ]; then
					EST_UNE_CHAINE=`echo $NOM_VARIABLE | egrep '\['`
					if [ $EST_UNE_CHAINE ]; then
						VRAI_NOM=`echo $NOM_VARIABLE | sed 's/\[.*\]//'`
						echo 'save_string("'$VRAI_NOM'", target->'$VRAI_NOM');' >> sav_autocode.zc
						echo 'read_string(buffer, "'$VRAI_NOM'", target->'$VRAI_NOM');' >> $AUTOREAD_TMP

					fi
					if [ ! $EST_UNE_CHAINE ]; then
						echo 'save_int("'$NOM_VARIABLE'", target->'$NOM_VARIABLE');' >> sav_autocode.zc
						echo 'target->'$NOM_VARIABLE' = atoi(get_level_string(buffer, "'$NOM_VARIABLE'", "0", temp));
memset(temp, 0, strlen(temp));' >> $AUTOREAD_TMP
					fi
				fi
					
			fi
		fi
	fi


	i=`expr $i + 1`
	done

rm $TEMP1
cat $AUTOREAD_TMP >> sav_autocode.zc
rm $AUTOREAD_TMP
