/*

Copyright (c) 2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"

/** \file objects.c
Game objects : memory allocation, linked lists subsystem
*/


#define add_obj_to_list(TYPE) { \
TYPE * newobj = calloc(1, sizeof(TYPE));\
memcpy(newobj, toadd, sizeof(TYPE));\
newobj->NEXT = head;\
newobj->PREV = NULL;\
if(head)\
	head->PREV = newobj;\
return newobj;\
}

liveplayer * add_player_to_database(liveplayer * head, liveplayer * toadd)
{
add_obj_to_list(liveplayer)
}

wall * add_wall_to_database(wall * head, wall * toadd)
{
add_obj_to_list(wall)
}

livewall * add_livewall_to_database(livewall * head, livewall * toadd)
{
add_obj_to_list(livewall)
}

killing_line * add_killing_line_to_database(killing_line * head, killing_line * toadd)
{
add_obj_to_list(killing_line)
}

banana * add_banana_to_database(banana  * head, banana * toadd)
{
add_obj_to_list(banana)
}

portal * add_portal_to_database(portal * head, portal * toadd)
{
add_obj_to_list(portal)
}

#define rem_obj_from_list() {\
	if(todelete == head)\
		{ /*if the object is the first of the list*/\
		head = GETNEXT(todelete);\
		if(head)\
			head->PREV = NULL;\
		free(todelete);\
		return head;\
		}\
	else if(!GETNEXT(todelete))\
		{ /*if the object is the last of the list*/\
		if(GETPREV(todelete))\
			GETPREV(todelete)->NEXT = NULL;\
		free(todelete);\
		return head;\
		}\
	if(todelete != head && GETNEXT(todelete))\
		{ /*l on va en chier*/\
		/*no NULL test, because it's better to have the program crash NOW than any time later*/\
		/*there's no bug here !*/\
		(GETPREV(todelete))->NEXT = GETNEXT(todelete);\
		(GETNEXT(todelete))->PREV = GETPREV(todelete);\
		free(todelete);\
		return head;\
		}\
	return NULL;\
	}


liveplayer * del_player_from_database(liveplayer * head, liveplayer * todelete)
	{
	rem_obj_from_list()
	}
	
wall * del_wall_from_database(wall * head, wall * todelete)
	{
	destroy_bitmap(todelete->sprite);
	rem_obj_from_list()
	}
	
livewall * del_livewall_from_database(livewall * head, livewall * todelete)
	{
	destroy_bitmap(todelete->sprite);
	rem_obj_from_list()
	}
	
killing_line * del_killing_line_from_database(killing_line * head, killing_line * todelete)
	{
	rem_obj_from_list()
	}
	
portal * del_portal_from_database(portal * head, portal * todelete)
	{
	rem_obj_from_list()
	}

banana * del_banana_from_database(banana * head, banana * todelete)
	{
	rem_obj_from_list()
	}
	
#define free_obj_list1(TYPE) TYPE * objrot = head;\
	TYPE * nextptr;\
	while(objrot)\
		{\
		nextptr = GETNEXT(objrot);
		
#define free_obj_list2(TYPE) free(objrot);\
		objrot = nextptr;\
		}\
	return 0;
	
	
int free_player_database(liveplayer * head)
	{
		free_obj_list1(liveplayer)
		free_obj_list2(liveplayer)
	}
	
int free_wall_database(wall * head)
	{
	free_obj_list1(wall)
	destroy_bitmap(objrot->sprite);
	free_obj_list2(wall)
	}
	
int free_livewall_database(livewall * head)
	{
	free_obj_list1(livewall)
	destroy_bitmap(objrot->sprite);
	free_obj_list2(livewall)
	}
	
int free_killing_line_database(killing_line * head)
	{
	free_obj_list1(killing_line)
	free_obj_list2(killing_line)

	}
	
int free_portal_database(portal * head)
	{
	free_obj_list1(portal)
	free_obj_list2(portal)

	}
	
int free_banana_database(banana * head)
	{
	free_obj_list1(banana)
	free_obj_list2(banana)

	}
	
	
	
