/*


Copyright (c) 2004 Arthur Huillet.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/



#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include "log_fac.h"



FILE * logfile[10];
static int filedest=0;
static int filenb=0;
static int nbhandlers;
static int log_with_rule(int, const char *, const char *, va_list args);
static int log_to_stderr(const char *,const char *,va_list args);
static int log_to_stdout(const char *,const char *,va_list args);
static int log_to_file(const char *, const char *,va_list args);
/** Reallocate memory to message handlers according to the number of them.
@return nonzero on error
*/
int realloue_msg_hdl()
{
msg_hdl=(message_hdl *)realloc(msg_hdl, nbhandlers*sizeof(message_hdl));
if(msg_hdl)
    return 0;
else return -1;
}



/** Initialize the logging facility by allocating memory to 3 handlers.
@return Returns always 0.
@see exit_logfac()
*/
int init_logfac()
{
msg_hdl=(message_hdl *)calloc(3,sizeof(message_hdl));
/*nbhandlers++;*/
return 0;
}


/** Exits the logging facility by closing the logfiles and freeing the message handler structure
@return Returns always 0.
@see init_logfac()
*/
int exit_logfac()
{
int i;
for(i=0; i < filenb; i++)
    fclose(logfile[i]);
free(msg_hdl);
return 0;
}


/** Log a message. This function takes a debuglevel argument, followed by printf-like parameters.
@param msg_debuglvl is the debug level of the message. 0 is error, 1 is standard, 2 is informative, 3 is debug.
@return Returns always 0.
*/
int log_msg(unsigned short int msg_debuglvl, const char *fmt, ...)
{
int i;
char already_logged = 0; /*bitmask*/
va_list ap;
va_start(ap, fmt);
for(i=0; i < nbhandlers; i++)
        {
        if(msg_hdl[i].debuglvl >= msg_debuglvl)
                {
                if(!(already_logged & (1 << msg_hdl[i].log_action)))
                        {
                        already_logged |= (1 << msg_hdl[i].log_action);
                        switch(msg_debuglvl)
                                {
                                case 0: log_with_rule(i, "[EE]", fmt, ap); break;
                                case 1: log_with_rule(i, "[++]", fmt, ap); break;
                                case 2: log_with_rule(i, "[II]", fmt, ap); break;
                                case 3: log_with_rule(i, "[DD]", fmt, ap); break;
                                default: log_with_rule(i, "[unknown]", fmt, ap);
                                }
			va_end(ap);
                        }
                }
        }
return 0;
}



/** Add a message handler
@param newrule is the new rule to add
@return The total number of message handlers.
*/
int add_rule(message_hdl newrule)
{
nbhandlers++;
realloue_msg_hdl();
msg_hdl[nbhandlers-1]=newrule;
msg_hdl[nbhandlers-1].rule_num=nbhandlers-1;
return nbhandlers-1;
}


/** Open a new log file
@param path is the path of the file
@return -1 on error, otherwise the number of currently opened logfiles
*/
int open_newlog(const char *path)
{

if(filenb>=10)
    return -1;

filenb++;
logfile[filenb-1]=fopen(path,"w");

if(!logfile[filenb-1])
    return -1;
return filenb-1;
}


/** Log with a given rule. FIXME : describe
*/
static int log_with_rule(int rulenum, const char *prefix, const char *fmt, va_list args)
{
message_hdl *filtered_rl = &msg_hdl[rulenum];

switch(filtered_rl->log_action)
	{
	case LOGTO_STDERR: log_to_stderr(prefix, fmt, args);break;
	case LOGTO_STDOUT: log_to_stdout(prefix, fmt, args);break;
	case LOGTO_DEVNULL: break;
	case LOGTO_FILE: log_to_file(prefix, fmt, args);break;

	};
	
return 0;
}



/*"low-level" logging functions */
static int log_to_stderr(const char *prefix, const char * fmt, va_list args)
{
fprintf(stderr, prefix);
fprintf(stderr, "  ");
vfprintf(stderr, fmt, args);
fprintf(stderr, "\n");
    
return 0;
}


static int log_to_stdout(const char *prefix, const char * fmt, va_list args)
{
fprintf(stdout, prefix);
fprintf(stdout, "  ");
vfprintf(stdout, fmt,args);
fprintf(stdout, "\n");

return 0;
}

static int log_to_file(const char *prefix, const char * fmt, va_list args)
{

if(!logfile[filedest]) /*we must check the FILE * pointer is okay*/
    return -1;

fprintf(logfile[filedest], prefix);
fprintf(logfile[filedest], "  ");
vfprintf(logfile[filedest], fmt, args);
fprintf(logfile[filedest], "\n"); 

return 0;
}


