/*

Copyright (c) 2003-2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include <stdio.h>
#ifndef LEVELS_H
#define LEVELS_H

#define ZL_TEMPLATE_ELEVATOR 1


FILE *level_xml_file;

void fin_instances(int);
int open_lvl_file(const char *); /*opens the level file*/
int close_lvl_file(); /*closes the file*/

int parse_level_data();


int get_level_line(char * );

int return_player(char *, liveplayer *, char); /*players*/
int return_lwall(char *, livewall *); /*livewall*/
int return_wall(char *, wall *); /*wall*/
int return_kl(char *, killing_line *);
int return_portal(char *, portal *); /*portal*/
int return_banana(char *, banana *);
int register_madmaker(char *);
int init_object_options(char *); 
short int get_object_option(const char * option_name, short int if_present);
char *get_level_string(const char *, const char *, char *, char *);
int set_refpoint(point * , char *); 


int display_level_info(char *);

int set_template(livewall *, int);

int runtime_level_loader(char *level_file); 


#endif
