/*
Copyright (c) 2005-2006    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*On-screen message box */
int zl_screen_msgbox(const char *, const char *, const char, void *);
enum {
        ZL_MESSAGE_TIMEWAIT=0, /*display the message for some time*/
        ZL_MESSAGE_BUTTONBOX=1, /*display a "ok" button*/
        ZL_MESSAGE_YESNOBOX=2 /*straightforward*/
};

enum {
	ZL_WIDGET_BUTTON = 0,
	ZL_WIDGET_NOTHING = 1
};

#define SET_CLICKED(X) X->state |= 1;
#define SET_NOT_CLICKED(X) X->state &= ~1;
#define ISCLICKED(X) (X->state & 1)

typedef struct zl_gui_widget_ {
	int dialogtype; /*type taken in an enum*/
	char label[30]; /*text to display for buttons etc.*/
	char id[15]; /*internal identifier*/
	char state; /*state of the widget (bitfield)*/
	int (* callback)();
	point position;
	point size;
	struct zl_gui_widget_ * NEXT;
	struct zl_gui_widget_ * PREV;
} zl_gui_widget;


zl_gui_widget * zl_widget_head;

zl_gui_widget * add_gui_widget(zl_gui_widget * head, int dialogtype, char * label, char * id, int (*callback)(), point position, point size);
int clear_widget_list(zl_gui_widget * head);
zl_gui_widget * remove_gui_widget(zl_gui_widget * head, zl_gui_widget * to_remove);
zl_gui_widget * search_widget_id(char * id);

int create_leveleditor_toolbox();
int destroy_leveleditor_toolbox();

int toggle_test_mode(); /*realtime testing of a level*/
int lvledit_trackback();

