/*
Copyright (c) 2005-2006    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include "all_inc.h"

extern int GAME_PAUSED;
extern int USE_TIMERS;

/** Display a message box on the screen
@param title is the title of the message box
@param msg is the message to be displayed
@param action describes what kind of messagebox : ZL_MESSAGE_BUTTONBOX is a box with a single button whose label can be set with the optional parameter\
ZL_MESSAGE_YESNOBOX is a box with a YES/NO choice that stores its result in the optional parameter\
ZL_MESSAGE_TIMEBOX makes a box without button, and wait "parm" milliseconds.
@param parm is the optional parameter. Usage described above.
@return Return value is not to be used.
*/
int zl_screen_msgbox(const char * title, const char * msg, const char action, void * parm)
{
int to_return = 0;
/*first of all, check the action*/
if(action != ZL_MESSAGE_TIMEWAIT && action != ZL_MESSAGE_BUTTONBOX && action != ZL_MESSAGE_YESNOBOX)
        return 1;

log_msg(3, "Displaying message box on the screen : %s", msg);
GAME_PAUSED = 1;
if(USE_TIMERS)
        {
        remove_int(increment_game_spd_counter);
        remove_int(fps_timer);
        }
                        
rectfill(game_frame[page_num], 0.15 * RESOL_X, 0.15 * zlogframe.l, 0.85 * RESOL_X, 0.99*zlogframe.l, 0);
rect(game_frame[page_num], 0.15 * RESOL_X, 0.15 * zlogframe.l, 0.85 * RESOL_X, 0.99*zlogframe.l, WHITE);
/*65 chars per line maximum*/
/*10 pixels between two lines*/
char * msgoffset = (char *)msg;
char msgline[80];
if(title)
        textout_centre_ex(game_frame[page_num], font, title, 0.5 * RESOL_X, 0.15 * zlogframe.l + 0.7 * 0.2 * zlogframe.l, RED, -1);
for(int y = 0.15 * zlogframe.l + 0.7 * 0.35 * zlogframe.l; y < 0.99 * zlogframe.l - 40; y += 10)
        {
        memset(msgline, 0, 80);
        int done = 0;
        unsigned int charcount = 0;
        while(charcount <= 65 && charcount < strlen(msgoffset) /*&& ( msgoffset[charcount] != ' ' || msgoffset[charcount] != '\n')*/)
                {
                charcount ++;
                if((charcount > 55 && msgoffset[charcount] == ' ') || msgoffset[charcount] == '\n')
                        break;
                }
        if(msgoffset[0] == ' ') msgoffset ++;
        
        if(charcount >= strlen(msgoffset))
               done = 1;
        strncpy(msgline, msgoffset, charcount);
        for(unsigned int i = 0; i < strlen(msgline); i++)
                {
                if(msgline[i] == '\n') msgline[i] = ' ';
                if(msgline[i] == '\t') msgline[i] = ' ';
                }
        msgoffset += charcount;
        textout_justify_ex(game_frame[page_num], font, msgline, 0.2 * RESOL_X, 0.8 * RESOL_X, y, 80, -1, -1);
 
        if(done) break;
        }

        if(action == ZL_MESSAGE_BUTTONBOX)
                {/*display the button*/
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.4 * RESOL_X, 0.99 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.6 * RESOL_X, 0.99 * zlogframe.l - 5, GREY);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.4 * RESOL_X, 0.99 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.6 * RESOL_X, 0.99 * zlogframe.l - 5, -1);

                char btnstr[15]; 
                memset(btnstr, 0, 15);
                if(parm) strncpy(btnstr, (char *)parm, 15);
                else strncpy(btnstr, "OK", 10);
                btnstr[14] = 0;
                textout_centre_ex(game_frame[page_num], font, btnstr, 0.15 * RESOL_X + 0.7 * 0.5 * RESOL_X, 0.99 * zlogframe.l - 20, -1, -1);
                }
                
        if(action == ZL_MESSAGE_YESNOBOX)
                {/*display the buttons*/
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.3 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.45 * RESOL_X, 0.85 * zlogframe.l - 5, GREY);
                rectfill(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.55 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.7 * RESOL_X, 0.85 * zlogframe.l - 5, GREY);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.3 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.45 * RESOL_X, 0.85 * zlogframe.l - 5, -1);
                rect(game_frame[page_num], 0.15 * RESOL_X + 0.7 * 0.55 * RESOL_X, 0.85 * zlogframe.l - 30, 0.15 * RESOL_X + 0.7 * 0.7 * RESOL_X, 0.85 * zlogframe.l - 5, -1);

                textout_centre_ex(game_frame[page_num], font, "Yes", 0.15 * RESOL_X + 0.7 * 0.37 * RESOL_X, 0.85 * zlogframe.l - 20, WHITE, -1);
                textout_centre_ex(game_frame[page_num], font, "No", 0.15 * RESOL_X + 0.7 * 0.63 * RESOL_X, 0.85 * zlogframe.l - 20, WHITE, -1);
                }
        
if(TEST_GLOBAL_STATE(NO_PAGE_FLIP))
        {    

        if(!is_memory_bitmap(ecranv[0]))
                vsync();

        acquire_screen();
        blit(ecranv[0], screen, 0,0,0,0,RESOL_X,RESOL_Y);
        release_screen();
        }
else {
        show_video_bitmap(ecranv[page_num]);
        page_num = 1-page_num;
        }
        
        
if(action == ZL_MESSAGE_TIMEWAIT)
        {
        int time_to_wait = (int)parm;
        if(! time_to_wait)
                time_to_wait = 40 * strlen(msg);
        log_msg(3, "Message box : waiting %i milliseconds", time_to_wait);
        rest(time_to_wait);
        }
        
if(action == ZL_MESSAGE_BUTTONBOX)
                {
                while(key[KEY_ENTER] || key[KEY_SPACE])
                        rest(10);
                while(!key[KEY_ENTER] && !key[KEY_SPACE])
                        rest(10);
                }
                
if(action == ZL_MESSAGE_YESNOBOX)
                {
                while(key[KEY_Y] || key[KEY_N])
                        rest(10);
                while(!key[KEY_Y] && !key[KEY_N])
                        rest(10);
                if(key[KEY_Y])
                        {
                        if(parm) *(int *)parm = 1;
                        to_return=1;
                        }
                if(key[KEY_N])
                        {
                        if(parm) *(int *)parm = 0;
                        to_return=0;
                        }
                }
        
                
/*unpause the game*/
GAME_PAUSED=0;
if(USE_TIMERS)
        {
        install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
        install_int_ex(fps_timer,SECS_TO_TIMER(1));
        }
        
return to_return;
}


zl_gui_widget * add_gui_widget(zl_gui_widget * head, int dialogtype, char * label, char * id, int (*callback)(), point position, point size)
{
log_msg(3, "Adding new widget to Zlog GUI element");
zl_gui_widget * new_obj = (zl_gui_widget *)calloc(1, sizeof(zl_gui_widget));
new_obj->dialogtype = dialogtype;
strncpy(new_obj->label, label, 30);
strncpy(new_obj->id, id, 15);	
new_obj->callback = callback;
new_obj->position = position;
new_obj->size = size;
if(head)
	{
	head->PREV = new_obj;
	new_obj->NEXT = head;
	}
return new_obj;
}

zl_gui_widget * remove_gui_widget(zl_gui_widget * head, zl_gui_widget * to_remove)
{
if(to_remove == zl_widget_head)
	{ /*if we're to remove the head*/
	head = head->NEXT;
	if(head)
		head->PREV = NULL;
	free(to_remove);
	return head;
	}
	
if(!to_remove->NEXT)
	{ /*tail*/
	if(to_remove->PREV)
		(to_remove->PREV)->NEXT = NULL;
	free(to_remove);
	return head;
	}

/*otherwise*/
(to_remove->PREV)->NEXT = to_remove->NEXT;
(to_remove->NEXT)->PREV = to_remove->PREV;
free(to_remove);
return head;
}

int clear_widget_list(zl_gui_widget * head)
{
log_msg(3, "Destroying widget list");
zl_gui_widget * save;
while(head)
	{
	save = head->NEXT;
	free(head);
	head = save;
	}
return 0;
}

int create_leveleditor_toolbox()
{
log_msg(2, "Creating toolbox");
point position = { RESOL_X - 110, 80 };
point size = { 100, 30 };
zl_widget_head = add_gui_widget(zl_widget_head, ZL_WIDGET_BUTTON, "Test level", "TestBtn", toggle_test_mode, position, size);
position.x = RESOL_X - 230;
position.y = 80;
zl_widget_head = add_gui_widget(zl_widget_head, ZL_WIDGET_BUTTON, "Save", "SaveBtn", save_level, position, size);
position.x = RESOL_X - 350;
position.y = 80;
zl_widget_head = add_gui_widget(zl_widget_head, ZL_WIDGET_BUTTON, "Add wall", "AddWlBtn", add_wall, position, size);
position.x = RESOL_X - 470;
position.y = 80;
zl_widget_head = add_gui_widget(zl_widget_head, ZL_WIDGET_BUTTON, "Add banana", "AddBnBtn", add_banana, position, size);
return 0;
}

int destroy_leveleditor_toolbox()
{
log_msg(2, "Destroying toolbox");
clear_widget_list(zl_widget_head);
return 0;
}

zl_gui_widget * search_widget_id(char * id)
{
zl_gui_widget * cur = zl_widget_head;
while(cur)
	{
	if(!strcmp(cur->id, id))
		return cur;
	cur = cur->NEXT;
	}
return NULL;
}


int toggle_test_mode()
{
extern char lvl_physic_runmask;
if(TEST_GLOBAL_STATE(LVLEDIT_TESTLEVEL))
	{	
	log_msg(2, "Ending test session");
	CLEAR_GLOBAL_STATE(LVLEDIT_TESTLEVEL);
	lvl_physic_runmask = 0;
	zl_widget_head = remove_gui_widget(zl_widget_head, search_widget_id("TrackbackBtn"));
	return 1;
	}
else {
	log_msg(2, "Starting test session");
	lvltoggle_ispressed_flag |= 128;
	lvl_physic_runmask = 127;
	log_msg(2, "Saving game status for trackback");
	create_savefile("trackback.sav");
	zl_save_game();
	SET_GLOBAL_STATE(LVLEDIT_TESTLEVEL);
	log_msg(2, "Adding trackback button to toolbox");
	point position = { RESOL_X - 110, 45 };
	point size = { 100, 30 };
	zl_widget_head = add_gui_widget(zl_widget_head, ZL_WIDGET_BUTTON, "Restart test", "TrackbackBtn", lvledit_trackback, position, size);
	}
return 0;
}

int lvledit_trackback()
{
log_msg(2, "Test session trackback");
lvltoggle_ispressed_flag |= 128;
if(!load_savefile("trackback.sav"))
	zl_load_link_binary_data();
zl_gui_widget * btn = search_widget_id("TrackbackBtn");
SET_NOT_CLICKED(btn);
return 0;
}



