/*

Copyright (c) 1999,2002-2005    Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"  


/*timer related variables*/
int speed_counter = 150;
int game_spd_counter = 1;
int fps_counter = 0;
int render_fps = 0;
int last_fps = 1;
int avg_fps = 20;
int nb_fps_cycles = 0;
int cyclecount = 0;
int counting_cycles = 0;
/*parameters*/
int GAME_PAUSED = 0;
int USE_TIMERS = 1;
int DO_BENCHMARK = 0;
int game_return_code = 0;
/***/

/*init_xxx functions in zlog.c*/
void init_player();
void init_walls();
void init_frame();

/** Increment the game speed counter. Used by interrupt routines.
*/
void increment_game_spd_counter()
{
        game_spd_counter++;
}
END_OF_FUNCTION(increment_game_spd_counter)

/** Take care of the fps timer. Used by interrupt routines.
*/
void fps_timer()
{
        last_fps=fps_counter;
        fps_counter=0;
        nb_fps_cycles++;
        avg_fps=((nb_fps_cycles-1)*avg_fps+last_fps)/nb_fps_cycles;
}
END_OF_FUNCTION(fps_timer)


/***********************************************************/

        #define ZLOG_GAME_BASE()                int end_get_touche=0;                                   \
                log_msg(2, "Entering game()");\
                init_player();                                          \
                init_walls();                                           \
                obj_db.screen_pos.x=1;                          \
                obj_db.screen_pos.y=1;                          \
		if(!update_world) { log_msg(0, "update_world was NULL ! Falling back to realtime (game) mode !"); update_world = realtime_update_world; } \
		if(!display_world) { log_msg(0, "display_world was NULL ! Falling back to realtime (game) mode !"); display_world = display_all; } \
		if(!get_input) { log_msg(0, "get_input was NULL ! Falling back to realtime (game) mode !"); get_input = get_keypress; } \
                log_msg(2, "All objects are now defined ");            \
                clear_keybuf();                         \
                rest(500);                                      \
                zl_screen_msgbox("Ready to go", "\tds as follows:\nMonkey read a note. Funny, funny note! Cirtaihcysp hospital give C.U.R.E.!\nIs it the monkey that goes to the hospital, or does the hospital approach the monkey? Relative my friend!\nMonkey know monkey is sick. Monkey must monkey cure, oh yes! Happy day, doctor give C.U.R.E.!\nCruel Unusual Revolving Experiment begun!\nHealing spreading in vein, spreading in blood, spreading in brain, spreading, spreading, spreading, oh my!\nInjections! 1, 10, 100, more injections! Green drugs, yellow drugs, red drugs, black drugs, strange drugs!\nRotations! 1G, 10G, 100G, more revolutions per second! Faster!\nRotations of injections and rotations of injections and rotations!\nrm -fr /\nAll done. C.U.R.E. done. Monkey done. But no!\nSystem halted. Reboot, Powerdown, or go Insane? I\nGoing insane in 543210.\nESCAPED IS MONKEY. CHASED IS MONKEY! Me is monkeeeey!\nInsaaaaaniiiiityyyyy come!\nEat banana. Boost body. Boost speed. Doping banana.\nRun beam. Beam bad. Beam give more C.U.R.E. \nNow I make a note. The note rea", ZL_MESSAGE_BUTTONBOX, "Play");\
                                                                                       \
                while(!keypressed())                                    \
                        rest(1);                                                        \


/* int game() initialisation des paramtres du jeu et boucle principale*/

/** Set-up timers and run the game.
@return Returns the return code of the game. 0 most of the time.
*/
int game()
{
        ZLOG_GAME_BASE()
        
	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_game_spd_counter);
	LOCK_FUNCTION(fps_timer);

	LOCK_VARIABLE(game_spd_counter);
	LOCK_VARIABLE(last_fps);
	LOCK_VARIABLE(fps_counter);
	LOCK_VARIABLE(nb_fps_cycles);
	LOCK_VARIABLE(avg_fps);



	install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
	install_int_ex(fps_timer,SECS_TO_TIMER(1));


	log_msg(2, "Timers are now up and running");
        game_return_code = 0;
        end_get_touche = 0;
        play_midi(music, 1);
        while(game_spd_counter > 0)
                {
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                display_world();
                fps_counter++;
                game_spd_counter--;
                while(game_spd_counter == 0)
                                rest(1);
                }


remove_int(increment_game_spd_counter);
remove_int(fps_timer);

return game_return_code;
}

/** Run the game without timers (not recommended)
@return Returns the game return code. 0 most of the time.
*/
int game_no_timers()
{
        ZLOG_GAME_BASE()
        game_return_code = 0;
        while(!end_get_touche && !game_return_code){
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                rest(5);
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                rest(5);
                end_get_touche=main_loop();
                cyclecount++;
                display_world();
                rest(5);
        }

return game_return_code;
}

/** Run the game without framerate limit (benchmark mode)
*/
int game_benchmark()
{
ZLOG_GAME_BASE()
	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(fps_timer);

	LOCK_VARIABLE(last_fps);
	LOCK_VARIABLE(fps_counter);
	LOCK_VARIABLE(nb_fps_cycles);
	LOCK_VARIABLE(avg_fps);

	install_int_ex(fps_timer,SECS_TO_TIMER(1));

	log_msg(2, "Timers are now up and running");
        game_return_code = 0;
        end_get_touche = 0;
        
        while(1)
                {
		display_world();
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                end_get_touche=main_loop();
                if(end_get_touche || game_return_code) break;
                cyclecount++;
                fps_counter++;
                }


remove_int(fps_timer);

return game_return_code;
}

/** Pause the game.
@return 0 if no error at the end of the pause, 1 if game was quit
*/
int pause()
{
int fin = 0;
        if(USE_TIMERS)
        {
                remove_int(increment_game_spd_counter);
                remove_int(fps_timer);
        }
        
        while(!fin)
        {
                display_all();
                rest(50);
                
                if (key [key_pause] && !(pltoggle_ispressed_flag & 2))
                        {
                        pltoggle_ispressed_flag |= 2;        
                        fin=1;
                        }
                if(!key[key_pause])
                        pltoggle_ispressed_flag &= ~2;
                        
                if(key[key_quit])
                {
                        return 1;
                }
        }
                        
        log_msg(1,"Game resumed.");
        GAME_PAUSED=0;
        if(USE_TIMERS)
        {
                install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(GAMESPEED));
                install_int_ex(fps_timer,SECS_TO_TIMER(1));
        }
return 0;
}


/** Main loop of the game/leveleditor.
*/
int main_loop()
{
int return_code = 0;
if(update_world())
	return ZL_QUIT;
return_code = get_input();
return(return_code);
}

/** Realtime updating of the world : code run by the game (not the level editor) to handle the realtime world (physics etc.)
*/
int realtime_update_world()
{
scheduler();
do_scroll(cur_player);  
/*update_mouse(); temporarily disabled*/

make_livewalls();
update_enemies();
cycle_object_sprites();
update_liveplatforms_sprites();
handle_pending_teleportation();
update_madmaker();
liveplayer * plrot;
for(int i = 0; i <2; i++)
	{
	if(!i) plrot = obj_db.liveplayer_head;
	else plrot = obj_db.enemy_head;
	
	while(plrot)
		{
		plrot->state |= ZL_PLAYER_IDLE;
		plrot->state &= ~ZL_SPRITE_ANIMATE;
		handle_player_zignals(plrot);
		make_jump(plrot);
		make_inertia(plrot);
		player_adj_coord(plrot);
		plrot = GETNEXT(plrot);
		}
	}
plrot = obj_db.liveplayer_head;
int count = 0;
while(plrot)
	{
	count ++;
	plrot = GETNEXT(plrot);
	}
plrot = obj_db.liveplayer_head;
while(plrot)
	{
	if(plrot->life <=0 && plrot->refpt.x)
        {
	if(count == 1)
		{
		set_teleportation(plrot, cur_level << 8);
		obj_db.screen_pos.x = obj_db.madmaker_head->refpt.x - 5;
		obj_db.screen_pos.y = obj_db.madmaker_head->refpt.y - 5;
		plrot->refpt.x = 0;
		if(!TEST_GLOBAL_STATE(LVLEDIT_MODE))
			zl_screen_msgbox("", "\tme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\n"
		"me is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\nme is over again and you will want to play again until ga\n"	, ZL_MESSAGE_BUTTONBOX, "RESTART");
		}
	else 
		{
		zl_screen_msgbox(plrot->name, "cause you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won because you are dead and he won be", ZL_MESSAGE_BUTTONBOX, "Take C.U.R.E");
		extern int game_return_code;
		game_return_code = ZL_QUIT;
		plrot->refpt.x = 0;
		return ZL_QUIT;
		}
        }
	else if(plrot->refpt.x) colldet();
	plrot = GETNEXT(plrot);
	}
return 0;
}



/*********************************************/

/** Get input for the game
@param returncode is a pointer to the return code of the game
@return Returns always 0.
*/
int get_keypress()
{
int plrot = 0;
liveplayer * target = obj_db.liveplayer_head;
int returncode = 0;
while(target)
        {
        if (key[pl_kbinds[RIGHT][plrot]])
			{        
        	if(! (target->state & ZL_PLAYER_RUNNING))
				pl_move_right(target, (float) (target->moving_spd.x));
            else
            	pl_move_right(target, (float) (target->moving_spd.x * 1.5));
           	}
             
        if (key[pl_kbinds[LEFT][plrot]])
        	{
        	if(! (target->state & ZL_PLAYER_RUNNING))
				pl_move_left(target, (float) (target->moving_spd.x));
            else
            	pl_move_left(target, (float) (target->moving_spd.x * 1.5));
           	}
             

	if(key[pl_kbinds[JUMP][plrot]])	
             {
             if(!(target->state & ZL_PLAYER_JPRESSED))
             	{ /*if the key was not pressed last cycle*/
             	target->state|=ZL_PLAYER_JPRESSED; /*it is pressed, now*/
             	if (!(target->state & ZL_PLAYER_JUMPING)) /*if we are not already jumping*/
                	if(target->state & NO_DOWN) /*if we are not falling*/
                   		setjump(target); /*make him jump*/
                }
             }
        
        else {	  /*if the key's not pressed*/
		     target->state&=~ZL_PLAYER_JPRESSED;	    	 
             if(target->state & ZL_PLAYER_JUMPING)
                 request_eojump(target);   
             }
  
    
    	/*lecture des switches*/
        if(key[pl_kbinds[RUN][plrot]])
                {
                if(!(pltoggle_ispressed_flag & 1))
                        {
                        pltoggle_ispressed_flag |= 1;
                        target->state ^= ZL_PLAYER_RUNNING;
                        }
                }
                else
                        pltoggle_ispressed_flag &= ~1;
                
                
        
        
	
         
        target = GETNEXT(target);
	plrot ++;
        }
        if(key[key_pause])
                { /*remove timers, set GAME_PAUSED to 1*/
                if (!(pltoggle_ispressed_flag & 2))
                        {
                        pltoggle_ispressed_flag |= 2;
                        log_msg(1,"Game paused.");
                        GAME_PAUSED=1;
                        returncode = pause();
                        }
                }
        else pltoggle_ispressed_flag &= ~2;
                
             
        
        if(key[KEY_J])
                {
                if(!(pltoggle_ispressed_flag & 4))
                        {
                        pltoggle_ispressed_flag |= 4;
                        create_savefile("zlog.sav");
                        zl_save_game();
                        }
                }
        else pltoggle_ispressed_flag &= ~4;
                
        if(key[KEY_H])
                {
                if(!(pltoggle_ispressed_flag & 8))
                        {
                        pltoggle_ispressed_flag |= 8;
                        if(!load_savefile("zlog.sav"))
                                {
                                zl_load_link_binary_data();
                                }
                        }
                }
        else pltoggle_ispressed_flag &= ~8;
        
        if(key[KEY_L])
                {
                if(!(pltoggle_ispressed_flag & 16))
                        {
                        pltoggle_ispressed_flag |= 16;
			char answer = 0;
				if(!TEST_GLOBAL_STATE(LVLEDIT_MODE))
					{
					zl_screen_msgbox("Mode change", "Do you want to go into leveledit mode ?", ZL_MESSAGE_YESNOBOX, &answer);
						if(answer == 1)
								switchto_leveledit();
					}	
				else 
					{
					zl_screen_msgbox("Mode change", "Are you sure you want to leave leveledit mode ?", ZL_MESSAGE_YESNOBOX, &answer);
						if(answer == 1)
								switchto_realtime();
					}
                        }
                }
        else pltoggle_ispressed_flag &= ~16;
		

        if(key[key_quit])
                {
                returncode = ZL_QUIT;
                game_return_code = ZL_QUIT;
                }
	

return returncode;
} /*fin de la fonction*/
	
	
