/*

Copyright (c) 2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

/** \file enemies.c
Enemies
*/

int update_madmaker()
{
if(obj_db.madmaker_head->refpt.x < obj_db.liveplayer_head->refpt.x)
	{
	if(obj_db.madmaker_head->speed & ZL_DIVIDE_SPD)
				{
				extern int cyclecount;
				if(cyclediv_check(&obj_db.madmaker_head->speed, &obj_db.madmaker_head->idling_for))
					{
					obj_db.madmaker_head->refpt.x += 3;//(!(cyclecount % 3)) ? 4 : 3;
					}
				}
	else obj_db.madmaker_head->refpt.x += obj_db.madmaker_head->speed;
	}
if(obj_db.madmaker_head->refpt.y < obj_db.screen_pos.y + 5)
	{
	obj_db.madmaker_head -> refpt.y = obj_db.screen_pos.y + 5;
	}
if(obj_db.madmaker_head->refpt.y > obj_db.screen_pos.y + 15)
	{
	obj_db.madmaker_head -> refpt.y = obj_db.screen_pos.y + 15;
	}
if(obj_db.screen_pos.x > 200)
	if(obj_db.madmaker_head->refpt.x < (obj_db.screen_pos.x - 200))
	{
	obj_db.madmaker_head -> refpt.x = obj_db.screen_pos.x - 200;
	}	
if(obj_db.madmaker_head->refpt.x > obj_db.screen_pos.x + zlogframe.L)
	{
	obj_db.madmaker_head -> refpt.x = obj_db.screen_pos.x + zlogframe.L;
	}	
colldet();
return 0;	
}

/** Update enemies. This function updates the targets of the enemies and moves them.
@see update_enemies_targets()
@see move_enemise()
@return Returns always 0.
*/
int update_enemies()
{
update_enemies_targets();
move_enemies();
return 0;
}

/** Move the enemies. Depending on their cleverness, move the enemies, either with waypoints, either by following the player.
@return Returns always 0.
*/
int move_enemies()
{
liveplayer * en = obj_db.enemy_head;
liveplayer * en_target;
	
while(en)
        {
        en_target = en->target;

        if(en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY)
                {
                if((!(en->parms & ZL_ENEMY_CLEVER)) || ! en_target)
                        { /*mario brosse*/
                                /*the enemy has no target and just wanders around*/
                        point ref = { 0 , 0 };
                        int width = 0;
                        if(en->ref_pform && en->state & ZL_PLAYER_LIVE_REFPFORM)
                                {
                                ref = ((livewall *)(en->ref_pform))->refpt;
                                width = ((livewall *)(en->ref_pform))->xsize;
                                }
                        else if(en->ref_pform)
                                {
                                ref = ((wall *)(en->ref_pform))->refpt;
                                width = ((wall *)(en->ref_pform))->xsize;
                                }
			if(width > 150)
				{
				
				if(en->state & NO_LEFT || ((en->refpt.x < ref.x) && (ref.x > 0)))
					pl_move_right(en, 0);
				if(en->state & NO_RIGHT || ((en->refpt.x + en->xsize) > (ref.x + width) && (ref.x > 0)))
					pl_move_left(en, 0);
                        
				if(IS_GOING_LEFT(en))
					{
					pl_move_left(en, (float)en->moving_spd.x);
					}
                                        
				else
					{
					pl_move_right(en, (float)en->moving_spd.x);
					}
				}
                        
                        }
                if((en->parms & ZL_ENEMY_CLEVER) && en_target)
                        { /*mickey mousse !*/
                        /*if he has a target, and if this target is at range (on the same platform), attack him*/
                                if(en->ref_pform == en_target->ref_pform && en->ref_pform)
                                        {
                                        if(en->refpt.x < en_target->refpt.x - 2)
                                                pl_move_right(en, (float)en->moving_spd.x);
                                        if(en->refpt.x > en_target->refpt.x + 2)
                                                pl_move_left(en, (float)en->moving_spd.x);
                                        }
                                else /*if the enemy is not on the same platform as its target*/
                                        {
                                  /*we'll just do nothing*/
                                        }
                        }
                                
                }
         else 
                {
                /*direction de l'enemi*/
                if(en_target)
                        {
                        if(en->refpt.x < en_target->refpt.x)
                                 {
                                 pl_move_right(en, 0);
                                 }
                        else pl_move_left(en, 0);
                        }                        
                }
         

         
         
        en = GETNEXT(en);
        }


return 0;
}


/** Update the targets of the enemies. Basically, this function wakes enemies up when the player is near enough, and stops them when they lose contact.
@see raise_zignal()
@return Returns always 0.
*/
int update_enemies_targets()
{
liveplayer * en = obj_db.enemy_head;
while(en)
        {
	liveplayer * pl = obj_db.liveplayer_head;
        while(pl)
                {
		/*vrification distance*/
                 /*si player prs de l'enemi, on rveille ce dernier*/
                if(abs(en->refpt.x - pl->refpt.x) < 1000 && abs(en->refpt.y - pl->refpt.y) < 500 && !(en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY))
                        {
                        raise_zignal(&en->zignals, ZIGNAL_PLAYER_INCOMING, (int)pl, 0);
                        log_msg(3, "Sent incoming player %x zignal to enemy", (unsigned int)pl);
                        }
                /*si player trop loin  on arrte de bouger*/
                if((abs(en->refpt.x - pl->refpt.x) > 1000 || abs(en->refpt.y - pl->refpt.y) > 500) && (en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY))
                         {
                         raise_zignal(&en->zignals, ZIGNAL_PLAYER_GETTINGAWAY, (int)pl, 0);
                         log_msg(3, "Sent zignal \"Player %x getting away\" to enemy", (unsigned int)pl);
                         }
		pl = GETNEXT(pl);
                }
	en = GETNEXT(en);
        }
return 0;
}

