/*

Copyright (c) 2003-2006    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */  
#include "all_inc.h"
#include <getopt.h>

extern int USE_TIMERS;
extern message_hdl ruletoadd;
extern char level_file[250];
extern int gfxmode;
extern int ask_gfx;
extern int DO_BENCHMARK;
int page_flip;

/** \file cmdline.c
Commandline options
*/

/** Display commandline options.
@see parse_commandline()
*/
void usage()
{   
fprintf(stderr,
	     "Usage : zlog-core [options]\nOptions are :\n"
	     "-V, --version : displays version number then exits\n"
	     "-h, --help : displays this help message\n"
	     "-d : do not display gfx mode dialogbox, runs the game directly (default)\n"
	     "-s : display gfx mode selection box\n");
fprintf(stderr,
	     "-p <playernb>, --player <playernb> : gives debug info about player #nb\n"
	     "-w <wallnb>, --wall <wallnb> : actually does nothing\n"
	     "-f <lwallnb>, --lwall <lwallnb> : gives debug info about livewall #nb\n"
	     "-L <levelfile> : uses specified levelfile\n"
	     "-X : multiplayer mode\n");
fprintf(stderr,
	     "-l <level>, --debuglevel <level> : debug level to issue messages\n"
	     "-G <mode>, --gfx-mode <mode> : use either \n\t\"safe\" : Safe Mode, not recommanded\n"
	     "\t\"autodetect\" or \"auto\" : autodetect best mode (fullscreen most of the time)\n"
	     "\t\"fullscreen\" or \"fs\" : try to set a fullscreen mode\n"
	     "\t\"window\" or \"win\" : play in a window (default, recommanded)\n"
	     "--no-page-flip : disable pageflipping\n"
	     "--do-page-flip : forces pageflipping (default)\n"
	     "--do-benchmark : no framerate limit, gives performance statistics\n");
fprintf(stderr,
		 "--use-deadzone : screen scrolling using a deadzone system (default)\n"
		 "--no-deadzone : don't you like deadzone ?\n");
		 
exit(0);

}




/** Parse commandline options, apply the changes. This function parses the commandline options and does what the options ask to do.
@param argc is the argc given to main()
@param argv is the argv given to main()
@return Returns always 0.
@see usage()
*/
int parse_commandline(int argc, char **argv)
{
    int option;
    int longindex;
    int addnewrule = 0;
    int give_vers = 0;
    int use_deadzone=1;
page_flip = 1;
  
	
    struct option longopts[] = {

	/*name                  arg             flag                    val */

	/*version */
	{"version", 			0, 				NULL, 					'V'},

	{"no-page-flip", 		0, 				&page_flip, 			0},
	{"do-page-flip", 		0, 				&page_flip, 			1},

	/*help */
	{"help", 				0, 				NULL, 					'h'},


	/*player  debug */
	{"player", 1, NULL, 'p'},
	{"wall", 1, NULL, 'w'},
	{"lwall", 1, NULL, 'f'},

	/*pas de timers */
	{"no-timers", 0, &USE_TIMERS, 0},
	{"do-benchmark", 0, &DO_BENCHMARK, 1},
	/*niveau de debug */
	{"debuglevel", 1, NULL, 'l'},

	/*redirection sur un fichier */
	/*--to-file <"path"|file#>*/

	/*changement mode gfx */
	{"gfx-mode", 1, NULL, 'G'},
	
	/*utilisation deadzone*/
	
	{"use-deadzone", 0, &use_deadzone, 1},
	{"no-deadzone", 0, &use_deadzone, 0},
	{NULL, 0, NULL, 0},

    };


    char *optstring = "Vhdsp:w:f:L:Xl:G:";

    while ((option =
	    getopt_long(argc, argv, optstring, longopts,
			&longindex)) != -1) {

	switch (option) {

	case 'V':
		give_vers = 1;
	    break;
	case 'h':
	    usage();
	    break;
	case 'd':
		ask_gfx=0;
	    break;
	case 's':
		ask_gfx=1;
		break;
	case 'p':
	    MODE_DEBUG_ACTIF = 1;
	    perso_to_debug = atoi(optarg);
	    log_msg(1, "Debugging player %i", perso_to_debug);
	    pform_to_debug = -1;
	    break;
	case 'w':
	    break;
	case 'f':
	    MODE_DEBUG_ACTIF = 1;
	    perso_to_debug = -1;
	    pform_to_debug = atoi(optarg);
	    log_msg(1, "Debugging pform %i", pform_to_debug);
	    break;
	case 'l':
	    addnewrule = 1;
	    ruletoadd.debuglvl = atoi(optarg);
	    break;
	case 'L':
	    strncpy(level_file, optarg, 249);
	    break;
	case 'X':
	    sprintf(level_file, "level_mp.xml");
	    break;
	case 'G':
		printf("%s",optarg);
	    if (strstr(optarg,"autodetect"))
			gfxmode = GFX_AUTODETECT;
		if (strstr(optarg,"fullscreen"))
			gfxmode = GFX_AUTODETECT_FULLSCREEN;
		if (strstr(optarg,"fs"))
			gfxmode = GFX_AUTODETECT_FULLSCREEN;	
	    if (strstr(optarg,"safe"))
			gfxmode = GFX_SAFE;
	    if (strstr(optarg,"window"))
			gfxmode = GFX_AUTODETECT_WINDOWED;
	    if (strstr(optarg,"win"))
			gfxmode = GFX_AUTODETECT_WINDOWED;
	    break;
	case '?':
		log_msg(0, "Quitting !");
		exit(5);
	    break;

	}
    }

/*filling global_stateflags*/
switch(page_flip)
    {
    case 0: SET_GLOBAL_STATE(NO_PAGE_FLIP); break;
    default: CLEAR_GLOBAL_STATE(NO_PAGE_FLIP); break;
    }
switch(use_deadzone)
    {
    case 0: SET_GLOBAL_STATE(NO_DEADZONE); break;
    default: CLEAR_GLOBAL_STATE(NO_DEADZONE); break;
    }

if (give_vers)
	{
	exit(0);
	}
                

if (addnewrule)
	
	{
	
	    /*retr_rule_str(add_rule(ruletoadd),temp); */ 
	    add_rule(ruletoadd);
	
	    /*log_msg(1, "Added rule whose description is : \n %s",temp); */ 
	}
    
return 0;

}

#ifdef _WIN32
#ifdef USE_W32_CSL

/*code from Allegro
takes a string, returns argc and argv*/
char ** cut_to_argv(char * s, int * argc)
{
   if (!s) {
      *argc = 0;
      return NULL;
   }

   /* increase the buffer size if needed */
   int s_size = strlen(s);
   char * argv_buf = calloc(1, s_size);
   strncpy(argv_buf, s, s_size);

int   pos = 0;
int   ac = 0;
char q = 0;
char c = 0;
   /* tokenize the buffer and count the number of words; every space character
    * as well as single and double quotes are replaced with zeros; comments * that start with # are also cut off with a 0
    */
   c = *argv_buf;
   while ((c) && (c != '#')) {
      /* replace all spaces up to the next word with 0 */
      while ((c) && (isspace(c))) {
	  argv_buf[pos] = 0;
   	  pos ++;
	  c = argv_buf[pos];
      }

      /* quit if we reached the end of the buffer or a comment */
      if ((c) && (c != '#')) {
         /* found another word! */
         ac++;

         /* cut away quotes by replacing them with 0 */
         if ((c == '\'') || (c == '"')) {
            q = c;
            argv_buf[pos]=0;
            pos ++;
            c = argv_buf[pos];
         }
         else {
            q = 0;
         }

         /* search for the end of the word */
         while ((c) && ((q) ? (c != q) : (!isspace(c)))) {
            pos ++;
            c = argv_buf[pos];
         }
      }
   }

   /* now that we know how many words there are in the buffer, allocate enough
    * space for a list of pointers to them, or return 0 if there are no words
    */
    char ** config_argv;
   if (ac > 0) {
      config_argv = malloc(ac*sizeof *config_argv);
   }
   else {
      *argc = 0;
      return NULL;
   }

   /* go through the tokenized buffer and assign pointers in argv to point to
    * the beginning of each individual word
    */
   for (int i=0, pos=0, c=*argv_buf; i < ac; i++) {
      /* find next word */
      while (!c) {
         pos ++;
         c = argv_buf[pos];
      }

      /* assign pointer */
      config_argv[i] = argv_buf+pos;

      /* find end of the word */
      while (c) {
         pos ++;
         c = argv_buf[pos];
      }
   }

   *argc = ac;
   return config_argv;
}
#endif
#endif
