/*

Copyright (c) 2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
 
 
#define TILESDIR "."

#define USE_FALLBACK 0
#define NO_FALLBACK 1
/*player spritesets*/
#define SPRSET_GOING_RIGHT 0
#define SPRSET_GOING_LEFT 1

/*platform spritesets*/
#define SPRSET_EDGE_RIGHT 0
#define SPRSET_EDGE_LEFT 1
#define SPRSET_CENTER 2

/*spritesets types*/
#define PLAYER_SPRSET 0
#define PFORM_SPRSET 1
#define BANANA_SPRSET 2

/** Macro for searching into a database of objects.
*/
#define SEARCH_XSETDB_ENTRY(X) { X##_entry * cur = db;\
if(! db)\
        return 0;\
while(1)\
        {\
        if(!strcmp(cur->key, clef))\
                return cur->dataset;\
        if(cur->NEXT)\
                cur = (X##_entry *)cur->NEXT;\
        else\
                return 0;\
        }\
return 0; }

/** Macro for adding an object in a database
*/
#define ADD_XSETDB_ENTRY(X) { X##_entry * newset = (X##_entry *)calloc(1, sizeof(X##_entry));\
strncpy(newset->key, clef, 25);\
newset->NEXT = (struct X##_entry *)target;\
newset->type = type;\
fill_##X (&newset->dataset, clef, type);\
target = newset;\
return newset; }

/** Macro for freeing a database
*/
#define FREE_XSETDB_ENTRY(X) { X##_entry * cur = db;\
X##_entry * next;\
while(cur)\
        {\
        next = (X##_entry *)cur->NEXT;\
        free_##X(&cur->dataset, cur->type);\
        free(cur);\
        cur = next;\
        }\
return 0; }

/*linked list handling (spriteset level 0 : sprite)*/
zl_sprite * add_zl_sprite_entry(zl_sprite *, char * , char *, int);
int free_zl_sprite(zl_sprite *);

/*spriteset handling (spriteset level 1 : group of sprites a.k.a. spriteset)*/
int fill_sprset(sprset * target, char * dir, int type);
int free_sprset(sprset * target, int type);

/*database handling (spriteset level 2 : database of all groups of sprites)*/
sprset_entry * spriteset_db;
sprset search_spritesetdb_entry(sprset_entry *, char *);
sprset_entry * add_spritesetdb_entry(sprset_entry *, char *, int type);
int free_spritesetdb(sprset_entry *);

/*zlog relative*/
int cycle_object_sprites();
int animate_player(liveplayer *);
int render_platforms();
int render_lwall(livewall *);
int update_liveplatforms_sprites();
