/*

Copyright (c) 2002-2005 Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/


#define ACTION_C
#include "all_inc.h"
#include <math.h>


/** \file action.c 
Contains object-moving functions.
*/


/************ 
deplacement
***************/



/** Move a liveplayer to the left.
@param target is a pointer to the liveplayer to move
@param combien is the number of points
@return Returns the number of points by which the player was moved
@see pl_move_right()
@see pl_move_up()
@see pl_move_down()
*/
int pl_move_left(liveplayer * target, float combien)
{
int i;
int combien_now = rintf(combien);

	
if (IS_GOING_LEFT(target) && combien)
	{ /*si le player est entrain de se dplacer, mais vers la gauche uniquement*/
	float imax = target->inert_max_speed_walk;
	if(target->state & ZL_PLAYER_RUNNING)
		{ /*s'il court*/
		imax = target->inert_max_speed_run; /*d'abord on paramtre l'inertie maximale*/
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = 1.225 * target->base_jumping_speed; /* et la vitesse de saut qui augmente*/
		} 
	else 
		{ /*s'il ne court pas*/
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = target->base_jumping_speed; /*la vitesse de saut (potentielle) diminue*/
		}
	if (target->current_spd.x > - imax)
		{
		/*si son inertie est infrieure  l'inertie max de marche*/
	//	target->current_spd.x -= 0.010;
		}
	}
else /*si il y a changement de direction*/
        { 
        if(IS_GOING_RIGHT(target))
                {
                        /*on change le sprite*/
                log_msg(3, "Changing sprite due to direction change : %x -> %x", target->current_sprite, target->spriteset[SPRSET_GOING_LEFT]);
                target->current_sprite = target->spriteset[SPRSET_GOING_LEFT];
                target->state &= ~SPR_REVERSE;
                }
        }

	

NOW_GOING_LEFT(target);

/*on le dplace du nombre de points spcifis, et on retourne la taille du mvt*/ 

target->add_x -= combien - combien_now;

for (i = 0; i < combien_now; i++)
	{
	if(target->refpt.x < obj_db.screen_pos.x)
		return i;
	if ( !(target->state & NO_LEFT))
       	target->refpt.x--;
	colldet();
        /*le player n'est plus idle puisqu'on le fait bouger*/
        target->state &= ~ZL_PLAYER_IDLE;
	if (target->state & NO_LEFT)
	   	return i;
	}
/*le sprite doit tre anim*/
if(target->state & NO_DOWN && (!(target->state & ZL_PLAYER_IDLE)))
        target->state |= ZL_SPRITE_ANIMATE;

if(target->moving_spd.x > 1) 
	target->moving_spd.x -= .0005 * i;
return i;
}


/** Move a livewall to the left.
@param target is a pointer to the livewall
@param combien is the number of points
@return Returns the number of points by which the wall was moved
@see lwl_move_right()
@see lwl_move_up()
@see lwl_move_down()
*/
int lwl_move_left(livewall * target, int combien)
{
int i;

for(i=0; i < combien; i++)
    {
    if(!(target->state & NO_LEFT))
        target->refpt.x--;
    colldet();    
    if(target->state & NO_LEFT)
        return i;
    }
return i;
}
    
    


/** Move a liveplayer to the right.
@param target is a pointer to the liveplayer to move
@param combien is the number of points
@return Returns the number of points by which the player was moved
@see pl_move_left()
@see pl_move_up()
@see pl_move_down()
*/
int pl_move_right(liveplayer * target, float combien)
{
int i;
int combien_now = rintf(combien);

/*on s'occupe tout d'abord de lui donner une inertie*/
if (IS_GOING_RIGHT(target) && combien)
	{ /*si le player est entrain de se dplacer, mais vers la droite uniquement*/
	float imax=target->inert_max_speed_walk;
	if(target->state & ZL_PLAYER_RUNNING)
		{
		imax=target->inert_max_speed_run;
		if(! (target->state & ZL_PLAYER_JUMPING))
			target->moving_spd.y = 1.225 * target->base_jumping_speed; /*la vitesse de saut augmente*/
		}
	else 
		{ /*s'il ne court pas*/
		target->moving_spd.y = target->base_jumping_speed; /*la vitesse de saut (potentielle) diminue*/
		}
	//if (target->current_spd.x < imax)
	//	target->current_spd.x += 0.010;
	}
else /*si il y a changement de direction*/
        { 
        if(IS_GOING_LEFT(target))
                {
                /*on change le sprite*/
                log_msg(3, "Changing sprite due to direction change : %x -> %x", target->current_sprite, target->spriteset[SPRSET_GOING_RIGHT]);
                target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT];
                target->state &= ~SPR_REVERSE;
                }
        }
		



NOW_GOING_RIGHT(target);
target->add_x += combien - combien_now;

for(i=0; i < combien_now; i++)
    {
    if(target->refpt.x >= obj_db.screen_pos.x + zlogframe.L)
	return i;
    if(!(target->state & NO_RIGHT))
        target->refpt.x++;
	colldet();   
        target->state &= ~ZL_PLAYER_IDLE;
    if(target->state & NO_RIGHT)
        return i;

}
if((target->state & NO_DOWN) && (!(target->state & ZL_PLAYER_IDLE)))
        target->state |= ZL_SPRITE_ANIMATE;

if(target->moving_spd.x > 1) target->moving_spd.x -= .0005 * i;
return i;

}
/** Move a livewall to the right.
@param target is a pointer to the livewall
@param combien is the number of points
@return Returns the number of points by which the wall was moved
@see lwl_move_left()
@see lwl_move_up()
@see lwl_move_down()
*/
int lwl_move_right(livewall * target, int combien)
{
int i;

for(i=0; i < combien; i++)
    {

    if(!(target->state & NO_RIGHT))
       target->refpt.x++;
    
    colldet();    
    
    if(target->state & NO_RIGHT)
        return i;
    }

return i;
}


/** Move a liveplayer up.
@param target is a pointer to the liveplayer to move
@param combien is the number of points
@return Returns the number of points by which the player was moved
@see pl_move_down()
@see pl_move_left()
@see pl_move_right()
*/
int pl_move_up(liveplayer * target, int combien)
{
int i;

target->state&=~ZL_PLAYER_IDLE;
    for(i=0;i<combien;i++)
    {
	if(!(target->state & NO_UP))
		if(target->refpt.y>1)    
            target->refpt.y--;
		else return i;
	else return i;
	colldet();
    }
    
    return i;
}
/** Move a livewall up.
@param target is a pointer to the livewall
@param combien is the number of points
@return Returns the number of points by which the wall was moved
@see lwl_move_down()
@see lwl_move_left()
@see lwl_move_right()
*/
int lwl_move_up(livewall * target, int combien)
{
  int i;

  
    for(i=0;i<combien;i++)
    {

        if(!(target->state & NO_UP))
          if(target->refpt.y > 1)    
            target->refpt.y--;
          else return i;
        else return i;
        
           colldet(); 
    }
    
    return i;
}

/** Move a liveplayer down.
@param target is a pointer to the liveplayer to move
@param combien is the number of points
@return Returns the number of points by which the player was moved
@see pl_move_up()
@see pl_move_left()
@see pl_move_right()
*/
int pl_move_down(liveplayer * target, int combien)
{
    int i;

    for(i=0;i<combien;i++)
    {
    
    
     if(target->state & NO_DOWN)
        return i;
      if(!(target->state & NO_DOWN))
        {
        target->refpt.y++;
        }
         colldet(); 
    }
    return i;
}

/** Move a livewall down.
@param target is a pointer to the livewall
@param combien is the number of points
@return Returns the number of points by which the wall was moved
@see lwl_move_up()
@see lwl_move_left()
@see lwl_move_right()
*/
int lwl_move_down(livewall * target, int combien)
{

    int i;

    for(i=0;i<combien;i++)
    {
      
      
      if(target->state & NO_DOWN)
        return i;
      if(!(target->state & NO_DOWN))
        target->refpt.y++;
        
          colldet();
    }
    return i;
}





	

/** Make a liveplayer jump. This function sets the variables of a liveplayer structure, so that the engine makes it jump.
@param target is the liveplayer who jumps
@see request_eojump()
*/
void setjump(liveplayer * target)
{ 
if(target->state & NO_DOWN)
    {
    target->jtime = 0;
    target->state |= ZL_PLAYER_JUMPING;
    }
}





/** Request the end of a jump. This function is used to request the end of a jump for a given player. It's a particularity in a platform game, because in real world, you can just stop jumping when you're in the air.
@param playernb is the number of the player whose jump is to be stopped.
@return Returns always 0.
*/
int request_eojump(liveplayer * target)
{
if(target->state & ZL_PLAYER_JUMPING)
	{
	target->state &=~ZL_PLAYER_JUMPING;
	target->jtime=0;        
	}
return 0;
}

   
/** Make a liveplayer lose health points. The function handles the death of the player if his hp become negative.
@param target is a pointer to the liveplayer concerned.
@param howmuch is the number of health points to remove.
@see unit_gets_killed()
*/
void unit_lose_hp(liveplayer * target, int howmuch)
{
if(!(target->state & ZL_PLAYER_INVINCIBLE))
        {
        target->life -= howmuch;
        if(target->life<=0)
            unit_gets_killed(target);
        }
}


/** Kill a liveplayer. Called by unit_lose_hp().
@param target is a pointer to the liveplayer to kill
@see unit_lose_hp()
*/
void unit_gets_killed(liveplayer * target)
{
target->used = 0;
liveplayer * findhead = target;
while(findhead->PREV)
	findhead = GETPREV(findhead);
if(findhead == obj_db.enemy_head)
	obj_db.enemy_head = del_player_from_database(findhead, target);
/*else obj_db.liveplayer_head = del_player_from_database(findhead, target);*/
}

/** Scroll the screen. do_scroll handles both deadzone-based and standard scrolling, and also the pseudo-parallax scrolling of the background.
@return Returns always 0.
*/
int do_scroll(liveplayer * target)
{
point basepos = obj_db.screen_pos;
/*dfilement centr*/
/*we set the screen pos to have the player on the center of the screen*/
liveplayer temp;
memset(&temp, 0, sizeof(liveplayer));
liveplayer * cur = obj_db.liveplayer_head;
int count = 0;
while(cur)
	{
	count ++;
	temp.refpt.x += cur->refpt.x;
	temp.refpt.y += cur->refpt.y;
	temp.xsize = cur->xsize;
	temp.ysize = cur->ysize;
	temp.state &= cur->state;
	cur = GETNEXT(cur);
	}
temp.refpt.x /= count;
temp.refpt.y /= count;
target= &temp;
	
if (TEST_GLOBAL_STATE(NO_DEADZONE))
	
	{
	
	if(target->refpt.x>(GAMESCR_RESOL_X/2))
		obj_db.screen_pos.x = target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2); /*x au milieu de l'cran*/
	else obj_db.screen_pos.x = 0;
   
    
	obj_db.screen_pos.y = target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2); /*y au milieu de l'cran */
	}


else { /*deadzone*/

	point deadzone_nw; /*les coordonnes du rectangle de la deadzone*/
	point deadzone_se;
	/*on calcule les coordonnes de la deadzone*/
	deadzone_nw.x = (GAMESCR_RESOL_X - GAMESCR_RESOL_X * DEADZONE_RATE /100) /2;
	deadzone_nw.y = (GAMESCR_RESOL_Y - GAMESCR_RESOL_Y * DEADZONE_RATE /100) /2;
	deadzone_se.x = GAMESCR_RESOL_X - deadzone_nw.x;
	deadzone_se.y = GAMESCR_RESOL_Y - deadzone_nw.y;
	if(TEST_GLOBAL_STATE(LVLEDIT_MODE))
		{
		deadzone_nw.y += 120;
		deadzone_se.y += 120;
		}
	/*comment doit on dfiler*/

	while((target->refpt.x < deadzone_nw.x + obj_db.screen_pos.x) && (obj_db.screen_pos.x > 0))
		obj_db.screen_pos.x--;
	while(target->refpt.x + target->xsize > deadzone_se.x + obj_db.screen_pos.x)
		obj_db.screen_pos.x++;
	while((target->refpt.y < deadzone_nw.y + obj_db.screen_pos.y) && (obj_db.screen_pos.y > 0))
		obj_db.screen_pos.y--;
	while(target->refpt.y + target->ysize > deadzone_se.y + obj_db.screen_pos.y)
		obj_db.screen_pos.y++;

	/*si le player est en idle on doit maintenant se rapprocher du centre __lentement__*/
	if((target->state & ZL_PLAYER_IDLE))
		{

		if(delay_to_deadzone > 0) /*si on est dj entrain d'attendre*/
			delay_to_deadzone--;
		if(delay_to_deadzone == 0) /*si on arrive  la fin du dlai, on lance le dfilement*/
			{
			if(obj_db.screen_pos.x > target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2))
				obj_db.screen_pos.x --;
			if(obj_db.screen_pos.x < target->refpt.x - ((GAMESCR_RESOL_X - target->xsize) / 2))
				obj_db.screen_pos.x ++;
			if(obj_db.screen_pos.y > target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2))
				obj_db.screen_pos.y --;
			if(obj_db.screen_pos.y < target->refpt.y - ((GAMESCR_RESOL_Y - target->ysize) / 2))
				obj_db.screen_pos.y ++;
			}
		if(delay_to_deadzone == -1) /*si aucun timer n'est lanc*/
			{
			delay_to_deadzone = 150; /*alors on en met un*/
			}
		}
	if(! (target->state & ZL_PLAYER_IDLE))
		{
		delay_to_deadzone = -1;
		}
	
		
			
	
	}
/*-----------------*/
int b;
#define POSITIVE_CONGR(X) b = ((- X) % 384); X = 384 - b;
float val;
val = (float)((int)obj_db.screen_pos.x - (int)basepos.x) / 2;
background_offset_x += (int)val; /*(obj_db.screen_pos.x - basepos.x) / 2;*/
add_bgoffsetx += val - (int)val;
val = (float)((int)obj_db.screen_pos.y - (int)basepos.y) / 2;
background_offset_y += (int)val;
add_bgoffsety += val - (int)val;

if(add_bgoffsetx >= 0.5)
        {
        background_offset_x ++;
        add_bgoffsetx --;
        }
if(add_bgoffsetx <=  - 0.5)
        {
        background_offset_x --;
        add_bgoffsetx ++;
        }
if(add_bgoffsety >= 0.5)
        {
        background_offset_y ++;
        add_bgoffsety --;
        }
if(add_bgoffsety <=  - 0.5)
        {
        background_offset_y --;
        add_bgoffsety ++;
        }
POSITIVE_CONGR(background_offset_x);
POSITIVE_CONGR(background_offset_y);
/*printf("X %i, Y %i\n", background_offset_x, background_offset_y);*/
/*if((background_offset_y % 384) == 0)
        background_offset_y = 0;*/
return 0;
}

/** Update the mouse position. UNUSED.
@return Returns always  0.
*/
/*
int update_mouse()
{
int mousexoffset, mouseyoffset;
get_mouse_mickeys(&mousexoffset, &mouseyoffset);
rel_mouse_pos_x += mousexoffset;
rel_mouse_pos_y += mouseyoffset;

if(sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y) < 100)
        {
        int x0 = rel_mouse_pos_x;
        int y0 = rel_mouse_pos_y;
        int r0 = sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y);
        if(!r0) r0 = 1;
        
        rel_mouse_pos_x = (100*x0) / r0;
        rel_mouse_pos_y = (100*y0) / r0;
        }
        
if(sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y) > 300)
        {
        int x0 = rel_mouse_pos_x;
        int y0 = rel_mouse_pos_y;
        int r0 = sqrt(rel_mouse_pos_x*rel_mouse_pos_x + rel_mouse_pos_y*rel_mouse_pos_y);
        if(!r0) r0 = 1;
        
        rel_mouse_pos_x = (300*x0) / r0;
        rel_mouse_pos_y = (300*y0) / r0;
        }
return 0;
}*/

/** FIXME : check and remove if UNUSED as supposed to be.
*/
void message_kill()
{
textout_ex(ecranv[page_num], font, killmsg, 400, 570, -1, -1);
}       


/** Round the decimal part of coordinates of a liveplayer. This function is used to compute the nearest integer value of the coordinates.
@param target is a pointer to the liveplayer on which to operate.
@return Returns 1 if something in the coordinates was changed, 0 otherwise.
*/
int player_adj_coord(liveplayer * target)
{
if(target->add_x >= 0.5)
	{
	if ( !(target->state & NO_RIGHT))
       	target->refpt.x++;
	colldet();
	target->add_x-=1;
	return 1;
	}
if(target->add_x <= -0.5)
	{
	if ( !(target->state & NO_LEFT))
       	target->refpt.x--;
	colldet();
	target->add_x+=1;
	return 1;
	}
	
if(target->add_y >= 0.5)
	{
	if ( !(target->state & NO_DOWN))
	pl_move_down(target, 1);
	target->add_y-=1;
	return 1;
	}
if(target->add_y <= -0.5)
	{
	if ( !(target->state & NO_UP))
	pl_move_up(target, 1);
	target->add_y+=1;
	return 1;
	}
return 0;
}
/** Apply inertia effects to a liveplayer's movement.
@param target is a pointer to the liveplayer on which to operate.
@return Returns always 0.
*/
int make_inertia(liveplayer * target)
{
int i;
if(target->current_spd.x > 0) 
	{ /*going to right*/
	target->add_x += (target->current_spd.x - rintf(target->current_spd.x));
	for (i=0; i < rintf(target->current_spd.x); i++)
		{
		if ( !(target->state & NO_RIGHT))
       		target->refpt.x++;
		colldet();
		}

	/*pl_move_right(playernb, (int)(target->current_spd.x));*/
	}
else
	{
	target->add_x -= (target->current_spd.x * -1 - rintf(target->current_spd.x) * -1);
	for (i=0; i < rintf(target->current_spd.x) * -1; i++)
		{
		if ( !(target->state & NO_LEFT))
       		target->refpt.x--;
		colldet();
		}
	/*pl_move_left(playernb, (int)(target->current_spd.x) * -1);*/
	}
	

/*rduction de vitesse de au frottement*/
	/*d'abord on calcule cette rduction*/
if(target->ref_pform != 0)
	{ /*si on est sur une plateforme, alors frottement*/
	float reduc;
	if(target->state & ZL_PLAYER_LIVE_REFPFORM && target->ref_pform)
		{ /*alors il s'agit d'un livewall*/
		reduc = ((livewall *)(target->ref_pform))->resist_inert;
		}
	else
		{
		if(target->ref_pform)
			reduc = ((wall *)(target->ref_pform))->resist_inert;
		}
	/*maintenant on applique cette rduction*/
	if(target->current_spd.x > 0)
		{ /*alors on va vers la droite, soustraction*/
		if(reduc < target->current_spd.x)
			target->current_spd.x -= reduc;
		else
			target->current_spd.x = 0;
		}
	if(target->current_spd.x < 0)
		{ /*alors on va vers la gauche, addition*/
		if(target->current_spd.x + reduc < 0)
			target->current_spd.x += reduc;
		else
			target->current_spd.x = 0;
		}
	}
else
	{ /*si pas sur plateforme, CODE EXPERIMENTAL !*/
	float reduc=0.008;
	if(target->current_spd.x > 0)
		{ /*alors on va vers la droite, soustraction*/
		if(reduc < target->current_spd.x)
			target->current_spd.x -= reduc;
		else
			target->current_spd.x = 0;
		}
	if(target->current_spd.x < 0)
		{ /*alors on va vers la gauche, addition*/
		if(target->current_spd.x + reduc < 0)
			target->current_spd.x += reduc;
		else
			target->current_spd.x = 0;
		}
	}
	



	
return 0;
}

/** Apply jump-related changes to a liveplayer.
@param target is a pointer to the liveplayer on which to operate.
@return Returns always 0.
*/
int make_jump(liveplayer * target)
{
if (target->state & ZL_PLAYER_IDLE && ! (target->state & ZL_PLAYER_JUMPING) )
	{ /*si le player ne bouge pas, vitesse de saut de base*/
	target->moving_spd.y = target-> base_jumping_speed;
	}
        
if(! (target->state & NO_DOWN)) {
        if((target->state & ZL_PLAYER_JUMPING) == 0)
		{	 /*if the player is falling*/
		target->current_spd.y = (gravite * target->jtime); 
		target->jtime ++;
		target->add_y += (target->current_spd.y - rint(target->current_spd.y));
		pl_move_down(target, rint(target->current_spd.y));
		}
        }
	
if(target->state &ZL_PLAYER_JUMPING)
	{
	target->current_spd.y = target->moving_spd.y - (gravite * target->jtime);

		if((gravite * target->jtime) >= target->moving_spd.y)
			{
			target->state &= ~ZL_PLAYER_JUMPING;
			target->jtime=0;
			return 0;
			}

			target->jtime++;
			if(pl_move_up(target, rint(target->current_spd.y)) < rint(target->current_spd.y))
				{ 
				target->state &= ~ZL_PLAYER_JUMPING;
				target->jtime=0;
                                return 0;
				}
			target->add_y += (target->current_spd.y - rint(target->current_spd.y));
        }

if(target->state & NO_DOWN)
	{
	target->jtime=0;
        target->current_spd.y = 0;
	target->state &= ~ZL_PLAYER_JUMPING;
	}

return 0;
} /*fin de la fonction*/
   




