/*****************************************************************************
 * Particles.  Very simple.  See .h for details
 * ***************************************************************************/

#include "particle.h"

/*****************************************************************************
 * The constructor initializes the values for the particle
 * ***************************************************************************/
particle::particle(int new_alpha, int new_lifetime, BITMAP *new_pic, int new_x, int new_y, int new_xvel, int new_yvel){
	alpha = new_alpha;
	first_alpha = new_alpha;
	lifetime = new_lifetime;
	life = new_lifetime;
	picca = new_pic;
	x = new_x;
	y = new_y;
	x_vel = new_xvel;
	y_vel = new_yvel;
	max_x = min_y = max_y = min_y = -1;
}

/*****************************************************************************
 * set_limits limits the particle to a rectangle
 * ***************************************************************************/
void particle::set_limits(int _max_x, int _min_x, int _max_y, int _min_y){
	max_x = _max_x;
	max_y = _max_y;
	min_x = _min_x;
	min_y = _min_y;
}

/*****************************************************************************
 * Update updates the position and alpha / lifetime values of the particle.
 * Returns whether or not the particle is still alive.
 * It also tries its best to keep the particle in its bounding rectangle
 * **************************************************************************/
bool particle::update(){
	// Update life
	life--;
	if (life <= 0)
		return false;

	// Update position
	x = x + x_vel;
	y = y + y_vel;
	if (max_x >= 0){
		if ((x > max_x && x_vel > 0) || (x < min_x && x_vel < 0))
			x_vel = -x_vel;
		if ((y > max_y && y_vel > 0) || (y < min_y && y_vel < 0))
			y_vel = -y_vel;
	}

	// Update transparency
	int alpha_change = first_alpha / lifetime;
	alpha = first_alpha - (alpha_change*(lifetime - life));	
}

/*****************************************************************************
 * Draw blits the particle to the given BITMAP, at its position
 * ***************************************************************************/
void particle::draw(BITMAP *buf){
	set_trans_blender(255, 255, 255, alpha);
	draw_trans_sprite(buf, picca, x, y);
	solid_mode();
}
