/******************************************************************************
 * Just a place for the main function
 * ***************************************************************************/

#include "Engine.h"
#include "Menus.h"

Menus *g_my_menus;
Engine *g_my_Engine;

/**
 * This initializes the allegro library and all of the subsystems of it used
 * in the game
 */
void init()
{
    allegro_init();
    set_color_depth(16);
    install_timer();
    install_keyboard();
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCN_WIDTH, SCN_HEIGHT, 0, 0);
    FSOUND_Init(44100, 32, 0);
    jpgalleg_init();
}

void main()
{
    init();
    g_my_Engine = new Engine();
    g_my_menus = new Menus();

    int playagain = 1;
    int score = 0;

    while (playagain) {
	g_my_Engine->intro();

	// Get the scores of the best and last game
	int last_score, best_score;
	ifstream replay;
	char last_str[50], best_str[50];

	replay.open("last_replay.rep", ios::in|ios::binary);
	if (replay.is_open()) {
	    replay.read((char *)&last_score, sizeof(int));
	    replay.close();
	} else
	    last_score = 0;
	sprintf(last_str, "Last Replay (Score %d)", last_score);

	replay.open("best_replay.rep", ios::in|ios::binary);
	if (replay.is_open()) {
	    replay.read((char *)&best_score, sizeof(int));
	    replay.close();
	} else
	    best_score = 0;
	sprintf(best_str, "Best Replay (Score %d)", best_score);

	// Generate the menu
	char menu_entries[4][50];
	sprintf(menu_entries[0], "Play");
	sprintf(menu_entries[1], last_str);
	sprintf(menu_entries[2], best_str);
	sprintf(menu_entries[3], "Quit");

	switch(g_my_menus->do_menu(3, 150, 1.5, menu_entries, NULL, NULL)){
	    case 0:
		score = g_my_Engine->play_game();
		playagain = g_my_Engine->death(score);
		break;

	    case 1:
		g_my_Engine->show_replay("last_replay.rep");
		break;

	    case 2:
		g_my_Engine->show_replay("best_replay.rep");
		break;

	    case 3:
		playagain = false;
		break;
	}
    }
}
END_OF_MAIN();
