/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/
 
#include "Globals.h"

Globals* Globals::_instance = 0;
 
/*******************************************************************************
 * The constructor cannot be called by outside functions.  If you want one of
 * these, you should call the instance function.  There's only supposed to be
 * one in existance at a time
 ******************************************************************************/
Globals::Globals(){
	SoundVolume = 256;
    MusicVolume = 128;
	theGraphics = new Graphics();
}

/*******************************************************************************
 * The instance function returns the static instance of the Globals variable.
 * It is what you should use in order to get it, not a constructor
 ******************************************************************************/
Globals* Globals::Instance(){
	if (_instance == 0){
		_instance = new Globals();
	}
	return _instance;
}
