// This is my implimentation of the circle class.  I sure do hope that
// I get the syntax for this part right.  If I do not, then I'll have a
// lot of trouble fixing my screwups.

#include <iostream>
#include <time.h>
#include <stdlib.h>
#include <allegro.h>
#include "Circle.h"

#define CIR_SIDE 72
#define MAX_VELOCITY_ORBIT 10
#define ACCELERATION_ORBIT 1

// This is a constructor used if you want to make your own damn circle
Circle::Circle(int _AI, int _X, int _Y, int _size, int _XVel, int _YVel){
    if (INITIALIZED == 0)
        initCircles();

    AIType = _AI;
    itsX = _X;
    itsY = _Y;
    itsSize = _size;
    itsXVel = _XVel;
    itsYVel = _YVel;
}

// Performs some initialization in the circle system.  Only needs to be called
// once.
void Circle::initCircles()
{
     // This loads the bitmap for the image
     const char *c = new char;
     PALETTE pal;
     char fileName[256];
     replace_filename(fileName, c, "gfx//pic_orbit.bmp", sizeof(fileName));
     orbitBitmap = load_bitmap(fileName, pal);
     if (!orbitBitmap)
        allegro_message("Error reading %s!\n", fileName);
     replace_filename(fileName, c, "gfx//pic_zombie.bmp", sizeof(fileName));
     zombieBitmap = load_bitmap(fileName, pal);
     if (!zombieBitmap)
        allegro_message("Error reading %s!\n", fileName);

     // This initializes the random seed if it hasn't done so already
     srand((unsigned int)time(0));
     INITIALIZED = 1;
}


// The lean method accelerates a circle towards the given point
void Circle::lean(int x, int y)
{
     // If the AI is supposed to veer towards the blue ball, do so
     if (AIType == ORBIT) {
          if (x < itsX)
          {   itsXVel -= ACCELERATION_ORBIT;
              if (itsXVel < -MAX_VELOCITY_ORBIT)
                itsXVel = -MAX_VELOCITY_ORBIT;
          } else {
             itsXVel += ACCELERATION_ORBIT;
             if (itsXVel > MAX_VELOCITY_ORBIT)
                itsXVel = MAX_VELOCITY_ORBIT; 
          }

         if (y < itsY)
         {   itsYVel -= ACCELERATION_ORBIT;
             if (itsYVel < -MAX_VELOCITY_ORBIT)
                itsYVel = -MAX_VELOCITY_ORBIT; 
         } else {
             itsYVel += ACCELERATION_ORBIT;
             if (itsYVel > MAX_VELOCITY_ORBIT)
                itsYVel = MAX_VELOCITY_ORBIT;
         }
    }     
}


// These basic inline methods return the position of the circle.
int Circle::getLeft() { return itsX; }
int Circle::getRight() { return itsX + itsSize; }
int Circle::getTop() { return itsY; }
int Circle::getBottom() { return itsY + itsSize; }


// This tests whether two circles have collided, and tells them both that they've
// collided with something if they have.
int Circle::testCollide( int x1, int y1, int size )
{
   int mouseSize = (int) (size * 0.8);
   int cirSize = (int) (itsSize * 0.8);

   int offset1 = (itsSize - cirSize) / 2;
   int offset2 = (size - mouseSize) / 2;

   int left1 = this->getLeft() + offset1;
   int right1 = this->getRight() - offset1;
   int top1 = this->getTop() + offset1;
   int bottom1 = this->getBottom() - offset1;
   int left2 = x1 + offset2;
   int right2 = x1 + offset2 + mouseSize;
   int top2 = y1 + offset2;
   int bottom2 = y1 + offset2 + mouseSize;

   if (right1 < left2 ) return 0;
   if (left1 > right2 ) return 0;
   if (bottom1 < top2 ) return 0;
   if (top1 > bottom2 ) return 0;

   return 1;
}

// The update method recalculates its coordinates
void Circle::update()
{
   itsY += itsYVel;
   itsX += itsXVel;
}

// This draws the circle on the given bitmap
void Circle::draw(BITMAP *buf)
{
    switch (AIType){
        case ZOMBIE:
                stretch_sprite(buf, zombieBitmap, itsX, itsY, itsSize, itsSize); 
                break;
        case ORBIT:
                stretch_sprite(buf, orbitBitmap, itsX, itsY, itsSize, itsSize); 
                break;
        default:
                allegro_message("Something has gone terrably awry.");
		allegro_exit();
    }
}

// This does NOT draw the circle to the screen.  It displays stats about it.
void Circle::display()
{
}

// This changes its direction based on the number passed to it
void Circle::collide(int dir)
{
      if (dir == 1)
      {  itsYVel *= -1;
      /* itsXVel = rand() % 20 - 10; */
         itsY += itsYVel; }
      else
      {  itsXVel *= -1;
      /* itsYVel = rand() % 20 - 10; */
         itsX += itsXVel; }
}


