/*****************************************************************************
 * Holds the backbuffer for anything that wants to do graphics.  The general
 * procedure is to get the buffer from this, write directly to that buffer,
 * and then call update(), which will wait until the next frame and then
 * blit the buffer to the screen.  The delay is defined in Definitions.h
 * **************************************************************************/

#ifndef FUDGEFACTOR_GRAPHICS_H
#define FUDGEFACTOR_GRAPHICS_H

#include <allegro.h>
#include "Definitions.h"
#include <list>
#include "particle.h"

using namespace std;

class Graphics {
	public:
		Graphics();
		BITMAP *get_buffer() { return buf; }
		void update();
		void add_particle(int alpha, int lifetime, BITMAP *picture, int x, int y, int xvel, int yvel);
		void add_particle(particle *new_particle);
		void update_particles();
		void draw_particles();
		
	private:
		BITMAP *buf;
		int start_of_tick;
		int start_of_second;
		int frames_this_second;
		int frames_last_second;
		int delay;
		int delay_changed;
		void update_framerate();
		list<particle *> particle_list;
		bool should_draw_framerate;
};

#endif
