/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/
 
/*******************************************************************************
 * I'm obviously too good for Global Variables.  Here's my alternative, a
 * spiffy little singleton object.  I like it.
 ******************************************************************************/

#ifndef GLOBALS_H
#define GLOBALS_H

#include "Graphics.h"

class Manager;

class Globals {

	public:
		static Globals *Instance();
		
		int getSoundVolume() { return SoundVolume; }
		int getMusicVolume() { return MusicVolume; }
		Graphics *getGraphics() { return theGraphics; }
		
		void setSoundVolume(int newVolume) { SoundVolume = newVolume; }
		void setMusicVolume (int newVolume) { MusicVolume = newVolume; }

	private:
		Globals();
		static Globals* _instance;  
		Graphics *theGraphics;
		int SoundVolume;
		int MusicVolume;
};

#endif
