/**
 * Just a header for the Engine class.  Nothing terrably exciting here.
 */

#include <stdio.h>
#include <allegro.h>
#include "fmod.h"
#include "circle.h"
#include "DataFile.h"
#include "Globals.h"
#include <fstream>
#include <jpgalleg.h>

#define MAX_CIRCLES 100
#define SCN_WIDTH 640
#define SCN_HEIGHT 480
#define DELAY 20
#define toNextLevel 199
#define MOUSE_SIZE 20
#define MOUSE_SPEED 1 // Lower is faster

using namespace std;

enum CIRCLE_VALS { AI_TYPE = 0, CIR_X, CIR_Y, CIR_SIZE, CIR_X_VEL, CIR_Y_VEL };

class Engine{
	public:
		int replay_circles[MAX_CIRCLES][6];
		int replay_player[MAX_CIRCLES * toNextLevel][2];
		int current_x, current_y;
		bool REPLAY;
		int NUM_CIRCLES;
		int levelCounter;
		char scoreString[64];
		int score;
		int gameOver;
		Circle *theCircles[MAX_CIRCLES];
		BITMAP *intro_bmp, *entro_bmp, *buf, *mouseBmp, *bg;
		Globals *myGlobals;
		
		void init();
		Engine();
		void init_game();
		BITMAP * initMouse();
		void show_replay(char *filename);
		int play_game();
		int mainLoop();
		void intro();
		int death(int);
		BITMAP *getBackGround();
};
