#include "common.h"
#include "global.h"
#include "graphics.h"
#include "shape.h"

#include <assert.h>


CShape	Shape[NRSHAPES]; // the 7 different shapes that exist in tetris


uchar*
GetHeapArray(uchar b0, uchar b1, uchar b2, uchar b3,
	uchar b4, uchar b5, uchar b6, uchar b7,
	uchar b8, uchar b9, uchar b10, uchar b11,
	uchar b12, uchar b13, uchar b14, uchar b15)
{
	uchar* data = new uchar[16];
	assert(data);

	data[0] = b0;	data[1] = b1;	data[2] = b2;	data[3] = b3;
	data[4] = b4;	data[5] = b5;	data[6] = b6;	data[7] = b7;
	data[8] = b8;	data[9] = b9;	data[10] = b10;	data[11] = b11;
	data[12] = b12;	data[13] = b13;	data[14] = b14;	data[15] = b15;

	return data;
}


void
InitShapes()
{
	uchar* temp = 0;


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		1, 1, 0, 0,
		0, 1, 1, 0,
		0, 0, 0, 0
	);
	Shape[0].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 0, 1, 0,
		0, 1, 1, 0,
		0, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[0].SetShape(1, temp);

	Shape[0].SetShape(2, Shape[0][0]);
	Shape[0].SetShape(3, Shape[0][1]);


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 1, 0,
		1, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[1].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 1, 0, 0,
		0, 1, 1, 0,
		0, 0, 1, 0,
		0, 0, 0, 0
	);
	Shape[1].SetShape(1, temp);

	Shape[1].SetShape(2, Shape[1][0]);
	Shape[1].SetShape(3, Shape[1][1]);


	temp = GetHeapArray
	(
		0, 1, 0, 0,
		1, 1, 1, 0,
		0, 0, 0, 0,
		0, 0, 0, 0
	);
	Shape[2].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 1, 0, 0,
		0, 1, 1, 0,
		0, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[2].SetShape(1, temp);

	temp = GetHeapArray
	(
		0, 0, 0, 0,
		1, 1, 1, 0,
		0, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[2].SetShape(2, temp);

	temp = GetHeapArray
	(
		0, 1, 0, 0,
		1, 1, 0, 0,
		0, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[2].SetShape(3, temp);


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 1, 0,
		0, 1, 1, 0,
		0, 0, 0, 0
	);
	Shape[3].SetShape(0, temp);
	Shape[3].SetShape(1, Shape[3][0]);
	Shape[3].SetShape(2, Shape[3][0]);
	Shape[3].SetShape(3, Shape[3][0]);


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		1, 1, 1, 1,
		0, 0, 0, 0,
		0, 0, 0, 0
	);
	Shape[4].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 1, 0, 0,
		0, 1, 0, 0,
		0, 1, 0, 0,
		0, 1, 0, 0
	);
	Shape[4].SetShape(1, temp);

	Shape[4].SetShape(2, Shape[4][0]);
	Shape[4].SetShape(3, Shape[4][1]);


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 1, 0,
		0, 0, 1, 0,
		0, 0, 1, 0
	);
	Shape[5].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 0, 1, 0,
		1, 1, 1, 0,
		0, 0, 0, 0
	);
	Shape[5].SetShape(1, temp);

	temp = GetHeapArray
	(
		0, 1, 0, 0,
		0, 1, 0, 0,
		0, 1, 1, 0,
		0, 0, 0, 0
	);
	Shape[5].SetShape(2, temp);

	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 1, 1,
		0, 1, 0, 0,
		0, 0, 0, 0
	);
	Shape[5].SetShape(3, temp);


	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 1, 0,
		0, 1, 0, 0,
		0, 1, 0, 0
	);
	Shape[6].SetShape(0, temp);

	temp = GetHeapArray
	(
		0, 0, 0, 0,
		1, 1, 1, 0,
		0, 0, 1, 0,
		0, 0, 0, 0
	);
	Shape[6].SetShape(1, temp);

	temp = GetHeapArray
	(
		0, 0, 1, 0,
		0, 0, 1, 0,
		0, 1, 1, 0,
		0, 0, 0, 0
	);
	Shape[6].SetShape(2, temp);

	temp = GetHeapArray
	(
		0, 0, 0, 0,
		0, 1, 0, 0,
		0, 1, 1, 1,
		0, 0, 0, 0
	);
	Shape[6].SetShape(3, temp);
}


CShape::CShape()
{
	shapeAtAngle[0] = 0;
	shapeAtAngle[1] = 0;
	shapeAtAngle[2] = 0;
	shapeAtAngle[3] = 0;
}


CShape::~CShape()
{
	delete[] shapeAtAngle[0];

	if (shapeAtAngle[1] != shapeAtAngle[0])
		delete[] shapeAtAngle[1];

	if (shapeAtAngle[2] != shapeAtAngle[0] && shapeAtAngle[2] != shapeAtAngle[1])
		delete[] shapeAtAngle[2];

	if (shapeAtAngle[3] != shapeAtAngle[0] && shapeAtAngle[3] != shapeAtAngle[1] && shapeAtAngle[3] != shapeAtAngle[2])
		delete[] shapeAtAngle[2];

	shapeAtAngle[0] = 0;
	shapeAtAngle[1] = 0;
	shapeAtAngle[2] = 0;
	shapeAtAngle[3] = 0;
}


void
CShape::SetShape(long angle, uchar* data)
{
	if (shapeAtAngle[angle])
	{
		delete[] shapeAtAngle[angle];
	}

	shapeAtAngle[angle] = data;
}


void
CShape::DrawShape(short posx, short posy, short angle)
{
	uchar* tempShape = shapeAtAngle[angle];

	for (short y = 0; y < 4; y++)
	{
		for (short x = 0; x < 4; x++)
		{
			if (tempShape[(y << 2) + x])
			{
				DrawSquare(posx + x, posy + y, PLAYFIELDPOSX, PLAYFIELDPOSY, 4);
			}
		}
	}
}


void
CShape::DrawAsNextShape()
{
	uchar* tempShape = shapeAtAngle[0];

	for (short y = 0; y < 4; y++)
	{
		for (short x = 0; x < 4; x++)
		{
			if (tempShape[(y << 2) + x])
			{
				DrawSquare(x, y, NEXTPIECEPOSX, NEXTPIECEPOSY, 2);
			}
		}
	}
}


uchar*
CShape::operator[] (long angle)
{
	return shapeAtAngle[angle];
}
