#include "common.h"
#include "palette.h"

#include <assert.h>
#include <fstream>


using namespace std;


RGB* palette	= 0;


// Global functions:

void
BuildPalette()
{
	palette = new RGB[256];
	assert(palette);

/*
	// 332 test palette
	for (ushort i = 0; i < 256; i++)
	{
		palette[i].r = (i / 32) * 8;
		palette[i].g = ((i % 32) / 4) * 8;
		palette[i].b = (i % 4) * 16;
	}
*/

	// 5 color game palette
	// RGB 0 - 255
	// 0:	0	0	0
	// 1:	236	233	191
	// 2:	41	138	50
	// 3:	187	209	156
	// 4:	190	48	48

	RGB* builder = palette;
	builder->r = 0;
	builder->g = 0;
	builder->b = 0;
	builder++;
	builder->r = 59;
	builder->g = 58;
	builder->b = 47;
	builder++;
	builder->r = 10;
	builder->g = 34;
	builder->b = 12;
	builder++;
	builder->r = 46;
	builder->g = 52;
	builder->b = 39;
	builder++;
	builder->r = 47;
	builder->g = 12;
	builder->b = 12;

	builder = 0;
}


void
SetPalette()
{
	set_palette(palette);
}


void
DeletePalette()
{
	delete palette;
	palette = 0;
}


void
GetRgbFromIndex(uchar index, uchar* r, uchar* g, uchar* b)
{
	RGB paletteEntry = palette[index];
	*r	= paletteEntry.r;
	*g	= paletteEntry.g;
	*b	= paletteEntry.b;
}

