#include "common.h"
#include "global.h"
#include "graphics.h"
#include "palette.h"

#include <assert.h>



BITMAP*	virscr	= 0;



// Global functions:

void
InitGraphics()
{
	BuildPalette();

	virscr = create_bitmap(SCREENW, SCREENH);
	assert(virscr);

	ClearVirscr(0);

	assert(set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREENW * 2, SCREENH * 2, 0, 0) >= 0);

	SetPalette();
}


void
ShutdownGraphics()
{
	destroy_bitmap(virscr);
	virscr	= 0;

	DeletePalette();
}


//#define PUTPIXEL(s, x, y, c)	((s)[(x) + ((y) << 8) + ((y) << 6)] = (c))


uchar
GetPixel(ulong x, ulong y)
{
	return getpixel(virscr, x, y);
/*
	if (x < SCREENW && y < SCREENH)
	{
		return virscr[(y << 8) + (y << 6) + x];
	}
	return 1;
*/
}


void
PutPixel(ulong x, ulong y, uchar color)
{
	putpixel(virscr, x, y, color);
/*
	if (x < SCREENW && y < SCREENH)
	{
		PUTPIXEL(virscr, x, y, color);
	}
*/
}


void
DrawLine(short x0, short y0, short x1, short y1, uchar color)
{
	line(virscr, x0, y0, x1, y1, color);

/*
	// Bresenham's algorithm :)

	float fdx = POSI(x1 - x0);
	long dx = (long)fdx;
	long x = (long)(x0 + 0.5);

	float fdy = POSI(y1 - y0);
	long dy = (long)fdy;
	long y = (long)(y0 + 0.5);


	if ((!dx) && (!dy))
	{
		PutPixel(x, y, color);
		return;
	}


	long fixdx = (long)(fdx * 256);
	long fixdy = (long)(fdy * 256);


	if (dx > dy)
	{
		long num = fixdx >> 1;
		if (x0 < x1)
		{
			if (y0 < y1)
			{
				for (long i = 0; i <= dx; i++)
				{
					PutPixel(x, y, color);
					x++;
					num += fixdy;
					if (num >= fixdx) {num -= fixdx; y++;}
				}
			}
			else
			{
				for (long i = 0; i <= dx; i++)
				{
					PutPixel(x, y, color);
					x++;
					num += fixdy;
					if (num >= fixdx) {num -= fixdx; y--;}
				}
			}
		}
		else
		{
			if (y0 < y1)
			{
				for (long i = 0; i <= dx; i++)
				{
					PutPixel(x, y, color);
					x--;
					num += fixdy;
					if (num >= fixdx) {num -= fixdx; y++;}
				}
			}
			else
			{
				for (long i = 0; i <= dx; i++)
				{
					PutPixel(x, y, color);
					x--;
					num += fixdy;
					if (num >= fixdx) {num -= fixdx; y--;}
				}
			}
		}
	}
	else
	{
		long num = fixdy >> 1;
		if (y0 < y1)
		{
			if (x0 < x1)
			{
				for (long i = 0; i <= dy; i++)
				{
					PutPixel(x, y, color);
					y++;
					num += fixdx;
					if (num >= fixdy) {num -= fixdy; x++;}
				}
			}
			else
			{
				for (long i = 0; i <= dy; i++)
				{
					PutPixel(x, y, color);
					y++;
					num += fixdx;
					if (num >= fixdy) {num -= fixdy; x--;}
				}
			}
		}
		else
		{
			if (x0 < x1)
			{
				for (long i = 0; i <= dy; i++)
				{
					PutPixel(x, y, color);
					y--;
					num += fixdx;
					if (num >= fixdy) {num -= fixdy; x++;}
				}
			}
			else
			{
				for (long i = 0; i <= dy; i++)
				{
					PutPixel(x, y, color);
					y--;
					num += fixdx;
					if (num >= fixdy) {num -= fixdy; x--;}
				}
			}
		}
	}
*/
}


void
DrawSquare(short posx, short posy, short ofsx, short ofsy, uchar color)
{
	short nw_x = worldX[posy][posx] + ofsx;
	short nw_y = worldY[posy][posx] + ofsy;
	short ne_x = worldX[posy][posx + 1] + ofsx;
	short ne_y = worldY[posy][posx + 1] + ofsy;
	short sw_x = worldX[posy + 1][posx] + ofsx;
	short sw_y = worldY[posy + 1][posx] + ofsy;
	short se_x = worldX[posy + 1][posx + 1] + ofsx;
	short se_y = worldY[posy + 1][posx + 1] + ofsy;

	DrawLine(nw_x, nw_y, sw_x, sw_y, color);
	DrawLine(nw_x, nw_y, ne_x, ne_y, color);
	DrawLine(ne_x, ne_y, se_x, se_y, color);
	DrawLine(sw_x, sw_y, se_x, se_y, color);

	// filling

	DrawLine(nw_x, nw_y, se_x, se_y, color);
	DrawLine(ne_x, ne_y, sw_x, sw_y, color);
/*
	DrawLine(nw_x + 1, nw_y, se_x, se_y - 1, color);
	DrawLine(nw_x, nw_y + 1, se_x - 1, se_y, color);
	DrawLine(ne_x - 1, ne_y, sw_x, sw_y - 1, color);
	DrawLine(ne_x, ne_y + 1, sw_x + 1, sw_y, color);
*/
	DrawLine(nw_x + 1, nw_y, sw_x + 1, sw_y, color);
	DrawLine(nw_x, nw_y + 1, ne_x, ne_y + 1, color);
	DrawLine(ne_x - 1, ne_y, se_x - 1, se_y, color);
	DrawLine(sw_x, sw_y - 1, se_x, se_y - 1, color);
}


void
ClearVirscr(ulong color)
{
	clear_to_color(virscr, color);
}


void
Vsync()
{
	vsync();
}


void
Blit()
{
//	blit(virscr, screen, 0,0, 0,0, SCREENW,SCREENH);
	stretch_blit(virscr, screen, 0,0, SCREENW, SCREENH, 0,0, SCREENW*2, SCREENH*2);
}

