// *******************************************
// Project:		Tetris
// File:		shape.hh
// Desc:		declaration of the class CShape
// Revisions:	2000-12-31	date of creation
//				2001-02-04	fixed a pretty obvious bug in the function GetHeapArray()
// *******************************************


#ifndef H_SHAPE_INCLUDED
#define H_SHAPE_INCLUDED

#include "common.h"

#define NRSHAPES	7

class CShape
{
private:
	uchar* shapeAtAngle[4]; // 4 different angles

public:
	CShape();
	~CShape();

	void SetShape(long angle, uchar* data);
	void DrawShape(short x, short y, short angle);
	void DrawAsNextShape();
	uchar* operator[] (long angle);
};

void	InitShapes();


extern CShape	Shape[NRSHAPES]; // the 7 different shapes that exist in tetris


#endif

