// *******************************************
// Created:		2001-04-22
// Desc:		functions for changing the screen mode and drawing pixels
// *******************************************


#ifndef H_GRAPHICS_INCLUDED
#define H_GRAPHICS_INCLUDED

#include "common.h"
#include "palette.h"


const int SCREENW = 320;
const int SCREENH = 200;
const int SCREENSIZE = 64000;


class CCurve
{
public:
	float x0;
	float y0;
	float x1;
	float y1;
	float x2;
	float y2;
	float x3;
	float y3;
};


class CSprite
{
public:
	long	pivotX;
	long	pivotY;
	ulong	width;
	ulong	height;
	long**	spaceLines;
	uchar**	colorLines;
	void	Init(ulong w, ulong h);
	void	DrawSprite(long x, long y);
};


void		InitGraphics();
void		ShutdownGraphics();
uchar		GetPixel(ulong x, ulong y);
void		PutPixel(ulong x, ulong y, uchar color);
void		DrawLine(short x0, short y0, short x1, short y1, uchar color);
void		DrawSquare(short posx, short posy, short ofsx, short ofsy, uchar color);
void		ClearVirscr(ulong color);
void		Vsync();
void		Blit();


//extern uchar*	virscr;
extern BITMAP* virscr;


#endif

