/*
*  Editor.h: 	Classes of the different parts of RPG Edit
*  By Bjrn Lindeijer
*
************************************************************************************/

#ifndef _INCLUDED_EDITOR_H_
#define _INCLUDED_EDITOR_H_

#include <allegro.h>
#include "GUI.h"
#include "OOGUI.h"

#define TILES_W			12
#define TILES_H			12
#define TILES_IN_ROW	16

#define MAX_GROUPS			4
#define MAX_TILES_IN_GROUP	256
#define MAX_OBJECT_ITEMS	64



class Titlebar : public BlockType {
public:
	Titlebar();
	void draw(BITMAP *bitmap);
};


class TileEditWindow : public BlockType {
public:
	TileEditWindow();
	~TileEditWindow();
	void calc_min_size();
	void become_size(int _x, int _y, int _w, int _h);
	void draw(BITMAP *bitmap);
private:
	Branch *bmain;
	Branch *bzoom;
};

//====================================================================================

class Tiled_Map_Window {
public:
	Tiled_Map_Window(int ix_min, int iy_min, int ix_max, int iy_max);		// Constructor
	~Tiled_Map_Window();							// Destructor
	void resize_to(int ix_min, int iy_min, int ix_max, int iy_max);
	void user_input();								// Handles user input
	void draw();									// Draws window + map + scrollbars
	
	bool changed;
private:
	void correct_camera();							// Make sure the map isn't leaving the window
	
	//World *my_world;
	int x_min, y_min, x_max, y_max, cam_x, cam_y;
	float float_cam_x, float_cam_y, MoveX, MoveY;
	WinThing *w_map;
	WinThing *w_corner;
	ScrollThing *s_scrollbar_x;
	ScrollThing *s_scrollbar_y;
};

/*
class Tile_Select_Window {
public:
	Tile_Select_Window(int ix_min, int iy_min, int ix_max, int iy_max);	// Constructor
	~Tile_Select_Window();
	void user_input();									// Handles user input
	void draw();										// Draws window + map + scrollbar
	void all_tiles_off();
	int save_groups(char *filename);
	int load_groups(char *filename);
	
	bool changed;
private:
	void remove_tile(int group_nr, int tile_nr);
	void add_tile   (int group_nr, int tile_nr, int add_tile);
	void calculate_values();
	void correct_y_mov();
	
	short x_min, y_min, x_max, y_max;
	short length, y_mov;
	short tiles_in_row, x_centre;
	short sel_group, sel_tile;
	WinThing    *w_main;
	WinThing    *w_menu;
	ButtonThing *b_all_tiles;
	ScrollThing *s_scrollbar;
	MenuThing   *popup_menu;

	char *group_label[MAX_GROUPS];
	bool  group_open[MAX_GROUPS];
	short group_tile[MAX_GROUPS][MAX_TILES_IN_GROUP];
	short group_tiles[MAX_GROUPS];
	short group_y[MAX_GROUPS];
	ButtonThing *b_group[MAX_GROUPS];
	WinThing    *w_group_border[MAX_GROUPS];
};
*/

class All_Tiles_Window {
public:
	All_Tiles_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~All_Tiles_Window();
	void resize_to(int ix_min, int iy_min, int ix_max, int iy_max);
	void user_input();
	void draw();

	bool changed, active;
private:
	int x_min, y_min, x_max, y_max;
	int y_mov;
	int tiles_in_row;

	WinThing *w_main1;
	WinThing *w_main2;
	ScrollThing *s_scrollbar;
};


class Tile_Edit_Window {
public:
	Tile_Edit_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~Tile_Edit_Window();
	void user_input();
	void draw();
	
	bool changed;
private:
	short x_min, y_min, x_max, y_max;
	bool grid;
	WinThing *w_main;
	WinThing *w_zoom;
	ButtonThing *b_grid;
};


class Palet_Window {
public:
	Palet_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~Palet_Window();
	void user_input();
	void draw();
	
	bool changed;
private:
	short x_min, y_min, x_max, y_max;
	int r, g, b;
	float h, s, v;
	WinThing *w_main;
	WinThing *w_color;
	ScrollThing *s_r;
	ScrollThing *s_g;
	ScrollThing *s_b;
	ScrollThing *s_v;
	WinThing *w_r;
	WinThing *w_g;
	WinThing *w_b;
};


class Objects_Window {
public:
	Objects_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~Objects_Window();
	void user_input();
	void draw();

	bool changed;
private:
	WinThing *w_main;
	WinThing *w_object;
	ScrollThing *s_scrollbar;

	short x_min, y_min, x_max, y_max;
	short length, y_mov;

	short obj_width, schuif;
	short nr_of_items;
	short object_item[MAX_OBJECT_ITEMS];
};


class Obj_Prop_Window {
public:
	Obj_Prop_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~Obj_Prop_Window();
	void user_input();
	void draw();

	bool changed;
private:
	short x_min, y_min, x_max, y_max;

	WinThing *w_main;
};


class Menubar_Window {
public:
	Menubar_Window(int ix_min, int iy_min, int ix_max, int iy_max);
	~Menubar_Window();
	void user_input();
	void draw();
	
	bool changed;
private:
	short x_min, y_min, x_max, y_max;
	
	WinThing    *w_main;
	ButtonThing *b_file;
	ButtonThing *b_mode;
	ButtonThing *b_layer;
	
	MenuThing *file_menu;
	MenuThing *mode_menu;
	MenuThing *layer_menu;
	
	char temp_filename[256];
};


#endif