/*
 *  Editor.cpp:		Classes of the different parts of RPG Edit
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#include <allegro.h>
#include "Errors.h"
#include "DRS.h"
#include "tiledmap.h"
#include "GUI.h"
#include "OOGUI.h"
#include "Editor.h"

extern int gui_color[];

extern void update_screen();

extern WinThing           *w_upper;
extern Menubar_Window     *window_menubar;
extern Tiled_Map_Window   *window_tiled_map;
extern All_Tiles_Window   *window_all_tiles;
extern Tile_Edit_Window   *window_tile_edit;
/*
extern Tile_Select_Window *window_tile_select;
extern Objects_Window     *window_objects;
extern Obj_Prop_Window    *window_obj_prop;
*/

extern int edit_mode;
extern int selected_layer;
extern int selected_object;
extern bool mouse_is_object;
extern volatile int updates_to_do;
extern int inkey;
extern bool program_end;
extern char map_name[];
extern BITMAP *buffer;

extern char status_message[];

extern TiledMap *tiledMap;
extern TileRepository *tileRepository;
extern TileType *selectedTile;
extern Entity* hoverEntity;

#define PROGRAM_ID		"RPG Edit [MiniRPG version]"
#define CREATOR_ID		"Moonlight Productions"


//===================   Titlebar   ===================================================

Titlebar::Titlebar():
BlockType(T_HIGH)
{
	min_h = text_height(font) + 6;
	min_w = text_length(font, PROGRAM_ID) + text_length(font, CREATOR_ID) + 12;
	hfr = 1;
}

void Titlebar::draw(BITMAP *bitmap)
{
	BlockType::draw(bitmap);
	textprintf      (bitmap, font, x + 4,     y + 4, gui_color[0], PROGRAM_ID);
	textprintf      (bitmap, font, x + 3,     y + 3, gui_color[5], PROGRAM_ID);
	textprintf_right(bitmap, font, x + w - 3, y + 4, gui_color[4], CREATOR_ID);
	textprintf_right(bitmap, font, x + w - 4, y + 3, gui_color[1], CREATOR_ID);
}



//===================   TileEditWindow   =============================================

TileEditWindow::TileEditWindow():
BlockType(T_HIGH)
{
	bmain = new HBranch(2, 5);
	bzoom = new VBranch(0, 1);
	bzoom->add(new BlockType(20, 20, 1, 1, T_DEEP));
	bzoom->add(new Button("Grid", 2));
	bmain->add(bzoom);
	bmain->add(new Block(0, 0, 1, 1));
	hfr = 1;
}

TileEditWindow::~TileEditWindow()
{
	delete bmain;
}

void TileEditWindow::calc_min_size()
{
	BlockType::calc_min_size();
	bmain->calc_min_size();
	min_h += bmain->min_h;
	min_w += bmain->min_w;
}

void TileEditWindow::become_size(int _x, int _y, int _w, int _h)
{
	BlockType::become_size(_x, _y, _w, _h);
	bmain->become_size(_x, _y, _w, _h);
}

void TileEditWindow::draw(BITMAP *bitmap)
{
	BlockType::draw(bitmap);
	bmain->draw(bitmap);
}



//===================   Tiled_Map_Window   ===========================================


Tiled_Map_Window::Tiled_Map_Window(int ix_min, int iy_min, int ix_max, int iy_max):
changed(true),
x_min(ix_min), y_min(iy_min),
x_max(ix_max), y_max(iy_max),
cam_x(0), cam_y(0), float_cam_x(0), float_cam_y(0),
MoveX(0), MoveY(0)
{
	int map_w = tiledMap->getWidth();
	int map_h = tiledMap->getHeight();

	// TODO: Be able to work with different map sizes
	w_map         = new    WinThing(x_min,     y_min,     x_max - 7, y_max - 7, 2, 2);
	s_scrollbar_x = new ScrollThing(x_min,     y_max - 6, x_max - 7, y_max,     0, map_w * TILES_W, (x_max-10)-(x_min+2), 0);
	s_scrollbar_y = new ScrollThing(x_max - 6, y_min,     x_max,     y_max - 7, 1, map_h * TILES_H, (y_max-10)-(y_min+2), 0);
	w_corner      = new    WinThing(x_max - 6, y_max - 6, x_max,     y_max,     1);
}

Tiled_Map_Window::~Tiled_Map_Window()
{
	delete w_map;
	delete s_scrollbar_x;
	delete s_scrollbar_y;
	delete w_corner;
}

void Tiled_Map_Window::resize_to(int ix_min, int iy_min, int ix_max, int iy_max)
{
	x_min = (ix_min == -99) ? x_min : ix_min;
	y_min = (iy_min == -99) ? y_min : iy_min;
	x_max = (ix_max == -99) ? x_max : ix_max;
	y_max = (iy_max == -99) ? y_max : iy_max;
	
	w_map->set_rect          (x_min,     y_min,     x_max - 7, y_max - 7);
	w_corner->set_rect       (x_max - 6, y_max - 6, x_max,     y_max);
	s_scrollbar_x->set_values(x_min,     y_max - 6, x_max - 7, y_max,     -99, (x_max-10)-(x_min+2));
	s_scrollbar_y->set_values(x_max - 6, y_min,     x_max,     y_max - 7, -99, (y_max-10)-(y_min+2));

	correct_camera();
	changed = true;
}

void Tiled_Map_Window::user_input()
{
	short prev_cam_x = cam_x, prev_cam_y = cam_y;

	// Scrolling with arrow keys / mouse
	if (key[KEY_LEFT]  && (MoveX > -2)) {MoveX -= 0.2;}
	if (key[KEY_RIGHT] && (MoveX <  2)) {MoveX += 0.2;}
	if (key[KEY_UP]    && (MoveY > -2)) {MoveY -= 0.2;}
	if (key[KEY_DOWN]  && (MoveY <  2)) {MoveY += 0.2;}

	MoveX = (MoveX > 0) ? MoveX - 0.1 : (MoveX < 0) ? MoveX + 0.1 : 0;
	MoveY = (MoveY > 0) ? MoveY - 0.1 : (MoveY < 0) ? MoveY + 0.1 : 0;
	if (MoveX < 0.05 && MoveX > -0.05) {MoveX = 0;}
	if (MoveY < 0.05 && MoveY > -0.05) {MoveY = 0;}

	if (MoveX != 0 || MoveY != 0) {
		float_cam_x += MoveX;
		float_cam_y += MoveY;
	}
	correct_camera();
	if (prev_cam_x != cam_x || prev_cam_y != cam_y) {changed = true;}

	// Mouse might have to be turned into the selected_object
	/*
	if (w_map->mouse_on(3) && selected_object > -1 && edit_mode == 1) {
		if (!mouse_is_object) {
			show_mouse(NULL);
			set_mouse_sprite(item[selected_object]->field_bitmap);
			set_mouse_sprite_focus(item[selected_object]->field_bitmap->w / 2, item[selected_object]->field_bitmap->h / 2);
			show_mouse(screen);
			mouse_is_object = true;
		}
	}
	else if (selected_object > -1 && edit_mode == 1) {
		if (mouse_is_object) {
			set_GUI_mouse(1);
			mouse_is_object = false;
		}
	}
	else if (edit_mode != 1) {
		if (mouse_is_object || selected_object > -1) {
			set_GUI_mouse(0);
			mouse_is_object = false;
			selected_object = -1;
		}
	}
	*/

	Point new_hover = Point(-TILES_W, -TILES_H);

	// Mouse input
	if (w_map->mouse_on(3))						  // ---> hovering above the map window: 
	{
		Point hoverTile = tiledMap->screenToTile(Point(mouse_x, mouse_y));
		Tile* cursorTile = tiledMap->getTile(hoverTile);
		TileType* tileType = cursorTile->getType();
		if (tileType) {
			sprintf(status_message, "X: %i  Y: %i  (%s)", hoverTile.x, hoverTile.y, tileType->getName());
		} else {
			sprintf(status_message, "X: %i  Y: %i", hoverTile.x, hoverTile.y);
		}
		new_hover = tiledMap->tileToMap(hoverTile);


		if (mouse_b & 1)								// --> You are pressing the left mouse button,
		{
			if (edit_mode == 0)
			{
				if (selected_layer == 0/* || selected_layer == 1*/)
				{
					if (w_map->mouse_on(3)) {
						Point hoverTile = tiledMap->screenToTile(Point(mouse_x, mouse_y));
						Tile* cursorTile = tiledMap->getTile(hoverTile);

						if (selectedTile != cursorTile->getType()) {
							cursorTile->setType(selectedTile);
							changed = true;
						}
						if (selectedTile) {
							sprintf(status_message, "X: %i  Y: %i  (%s)", hoverTile.x, hoverTile.y, selectedTile->getName());
						}
					} else {
						strcpy(status_message, "");
					}
					update_screen();
				}
				else if (selected_layer == 2) {
					Point hoverTile = tiledMap->screenToTile(Point(mouse_x, mouse_y));
					Tile* cursorTile = tiledMap->getTile(hoverTile);
					bool first_obstacle = cursorTile->obstacle;

					do {
						if (w_map->mouse_on(3)) {
							Point hoverTile = tiledMap->screenToTile(Point(mouse_x, mouse_y));
							Tile* cursorTile = tiledMap->getTile(hoverTile);
							hoverEntity->pos = tiledMap->tileToMap(hoverTile);

							if (tileType) {
								sprintf(status_message, "X: %i  Y: %i  (%s)", hoverTile.x, hoverTile.y, tileType->getName());
							} else {
								sprintf(status_message, "X: %i  Y: %i", hoverTile.x, hoverTile.y);
							}

							if (cursorTile->obstacle == first_obstacle) {
								cursorTile->obstacle = !first_obstacle;
								changed = true;
							}
						} else {
							strcpy(status_message, "");
						}
						update_screen();
					} while (mouse_b & 1);
				}
			}
			/*
			else if (edit_mode == 1) {
				if (selected_object > -1) {
					if (world->create_object(selected_map, mouse_x - x_min - 3 + cam_x,
					                          mouse_y - y_min - 3 + cam_y + (item[selected_object]->field_bitmap->h / 2),
											  0,
					                          selected_object, item[selected_object]->field_bitmap) >= 0) {
						changed = true; update_screen();
						do {;} while (mouse_b & 1);
					}
				}
				else {
					// Select some objects
				}
			}
			*/
		}
		if (mouse_b & 2)								// --> You are pressing the right mouse button,
		{
			if (selected_layer == 0 || selected_layer == 1)
			{
				Tile* cursorTile = tiledMap->getTile(tiledMap->screenToTile(Point(mouse_x, mouse_y)));
				
				if (selectedTile != cursorTile->getType())
				{
					selectedTile = cursorTile->getType();
					window_tile_edit->changed = true;
					window_all_tiles->changed = true;
				}
			}
		}
	}
	else if (mouse_b & 1) {
		if (s_scrollbar_x->mouse_on()) {				  // ---> hovering above the bottom scroll bar:
			s_scrollbar_x->handle(1);
			do {
				float_cam_x = (float)s_scrollbar_x->handle(0);
				correct_camera();
				if (prev_cam_x != cam_x) {prev_cam_x = cam_x; changed = true; update_screen();}
			} while (mouse_b & 1);
			updates_to_do = 0;
		}
		else if (s_scrollbar_y->mouse_on()) {				  // ---> hovering above the right scroll bar:
			s_scrollbar_y->handle(1);
			do {
				float_cam_y = (float)s_scrollbar_y->handle(0);
				correct_camera();
				if (prev_cam_y != cam_y) {prev_cam_y = cam_y; changed = true; update_screen();}
			} while (mouse_b & 1);
			updates_to_do = 0;
		}
		else if (w_corner->mouse_on()) {					  // ---> hovering above the little corner
			int mickey_x = 0, mickey_y = 0;
			int prev_mouse_x = mouse_x, prev_mouse_y = mouse_y;
			w_corner->set_rect(-99,-99,-99,-99,3);
			show_mouse(NULL); changed = true; update_screen();
			get_mouse_mickeys(&mickey_x, &mickey_y);
			do {
				get_mouse_mickeys(&mickey_x, &mickey_y);
				float_cam_x = float_cam_x + mickey_x;
				float_cam_y = float_cam_y + mickey_y;
				correct_camera();

				if (prev_cam_y != cam_y || prev_cam_x != cam_x) {
					prev_cam_y = cam_y; prev_cam_x = cam_x;
					changed = true; update_screen();
				}
			} while (mouse_b & 1);
			w_corner->set_rect(-99,-99,-99,-99,1);
			changed = true;
			position_mouse(prev_mouse_x, prev_mouse_y);
			show_mouse(screen);
			updates_to_do = 0;
		}
	}

	if (hoverEntity->pos.x != new_hover.x ||
		hoverEntity->pos.y != new_hover.y) {
		hoverEntity->pos = new_hover;
		changed = true;
	}
}

void Tiled_Map_Window::correct_camera()
{
	int map_w = tiledMap->getWidth();
	int map_h = tiledMap->getHeight();

	// Make sure the map is not 'leaving' the window...
	if (float_cam_x < 0) float_cam_x = 0;
	if (float_cam_y < 0) float_cam_y = 0;
	if (float_cam_x > map_w * TILES_W - ((x_max - 11) - (x_min + 1)))
		float_cam_x = map_w * TILES_W - ((x_max - 11) - (x_min + 1));
	if (float_cam_y > map_h * TILES_H - ((y_max - 11) - (y_min + 1)))
		float_cam_y = map_h * TILES_H - ((y_max - 11) - (y_min + 1));

	cam_x = (int)float_cam_x;
	cam_y = (int)float_cam_y;
}

void Tiled_Map_Window::draw()
{
	int map_w = tiledMap->getWidth();
	int map_h = tiledMap->getHeight();

	// Draw the entire window (all the WinThings + map)
	w_map        ->draw();
	w_corner     ->draw();
	s_scrollbar_x->set_values(-99, -99, -99, -99, map_w * TILES_W, -99, cam_x);
	s_scrollbar_y->set_values(-99, -99, -99, -99, map_h * TILES_H, -99, cam_y);
	s_scrollbar_x->draw();
	s_scrollbar_y->draw();

	if (tiledMap) {
		Rectangle clipRect(x_min + 3, y_min + 3, (x_max - 10) - (x_min + 3) + 1, (y_max - 10) - (y_min + 3) + 1);

		tiledMap->setCamera(Point(cam_x, cam_y), clipRect, false, true);

		if (selected_layer == 2) {
			tiledMap->draw(buffer, true);
		} else {
			tiledMap->draw(buffer, false);
		}

		/*
		switch (selected_layer) {
		case 0: 
			map->drawLayer(buffer, cam_x, cam_y, 0, 0);
			map->drawObjects(buffer, cam_x, cam_y);
			map->drawLayer(buffer, cam_x, cam_y, 1, 1);
			break;
		case 1: 
			map->drawLayer(buffer, cam_x, cam_y, 0, 1);
			map->drawObjects(buffer, cam_x, cam_y);
			map->drawLayer(buffer, cam_x, cam_y, 1, 0);
			break;
		case 2: 
			map->drawLayer(buffer, cam_x, cam_y, 0, 0);
			map->drawObjects(buffer, cam_x, cam_y);
			map->drawLayer(buffer, cam_x, cam_y, 1, 0);
			map->drawLayer(buffer, cam_x, cam_y, 2, 16);
			break;
		case 3:
			map->drawLayer(buffer, cam_x, cam_y, 0, 0);
			map->drawObjects(buffer, cam_x, cam_y);
			map->drawLayer(buffer, cam_x, cam_y, 1, 1);
			break;
		default:
			map->draw(buffer, cam_x, cam_y);
		}
		*/
	}

	add_rect(x_min, y_min, x_max, y_max);
	changed = false;
}



//===================   Menubar_Window   =============================================


Menubar_Window::Menubar_Window(int ix_min, int iy_min, int ix_max, int iy_max):
changed(true),
x_min(ix_min), y_min(iy_min),
x_max(ix_max), y_max(iy_max)
{
	w_main  = new    WinThing(x_min,      y_min,     x_max,       y_max);
	b_file  = new ButtonThing(x_min + 2,  y_min + 2, x_min + 38,  y_max - 2, "File");
	//b_mode  = new ButtonThing(x_min + 41, y_min + 2, x_min + 77,  y_max - 2, "Mode");
	//b_layer = new ButtonThing(x_min + 80, y_min + 2, x_min + 125, y_max - 2, "Layer");
	b_layer  = new ButtonThing(x_min + 41, y_min + 2, x_min + 77,  y_max - 2, "Layer");

	//file_menu  = new MenuThing(x_min + 2,  y_max, "New map,Import map...,Export map...,|,Load tile groups,Save tile groups,|,Exit");
	file_menu  = new MenuThing(x_min + 2,  y_max, "New map,Load map...,Save map,Save map as...,|,Import tiles...,Export tiles...,|,Exit");
	//mode_menu  = new MenuThing(x_min + 41, y_max, "Tile mode,Object mode");
	//layer_menu = new MenuThing(x_min + 80, y_max, "1. Ground layer,2. Floating layer,3. Obstacle layer");
	layer_menu = new MenuThing(x_min + 41, y_max, "1. Ground layer,3. Obstacle layer");
}

Menubar_Window::~Menubar_Window()
{
	delete w_main;
	delete b_file;
	//delete b_mode;
	delete b_layer;

	delete file_menu;
	//delete mode_menu;
	delete layer_menu;
}

void Menubar_Window::user_input()
{
	if (mouse_b & 1) {
		if (b_file->mouse_on()) {
			if (b_file->clicked()) {
				int chosen_item = file_menu->handle();
				char filename[256] = "";
				
				switch (chosen_item) {
				case 0:
					// New map
					// TODO: Should show pop-up to ask for map size.
					delete tiledMap;
					tiledMap = new SquareMap(TILES_W, TILES_H);
					tiledMap->resizeTo(128, 128);
					strcpy(map_name, "untitled.map");
					if (hoverEntity) tiledMap->addEntity(hoverEntity);
					window_tiled_map->changed = true;
					break;
				case 1:
					// Load map...
					if (file_select("Load map... (*.MAP)", filename, "MAP") != 0) {
						PACKFILE *file = pack_fopen(filename, F_READ_PACKED);
						tiledMap->loadFrom(file, tileRepository);
						pack_fclose(file);
						ustrcpy(map_name, filename);

						window_tiled_map->changed = true;
					}
					break;
				case 2:
					// Save map
					if (ustrcmp(map_name, "untitled.map") == 0) {
						if (file_select("Save map... (*.MAP)", filename, "MAP") != 0) {
							PACKFILE *file = pack_fopen(filename, F_WRITE_PACKED);
							tiledMap->saveTo(file);
							pack_fclose(file);
							ustrcpy(map_name, filename);
						}
					} else {
						PACKFILE *file = pack_fopen(map_name, F_WRITE_PACKED);
						tiledMap->saveTo(file);
						pack_fclose(file);
					}
					break;
				case 3:
					// Save map as...
					if (file_select("Save map... (*.MAP)", filename, "MAP") != 0) {
						PACKFILE *file = pack_fopen(filename, F_WRITE_PACKED);
						tiledMap->saveTo(file);
						pack_fclose(file);
					}
					break;
				case 4:
					// Import tiles...
					if (file_select("Import tiles... (*.BMP)", filename, "BMP") != 0) {
						tileRepository->importBitmap(filename, TILES_W, TILES_H, 0, TILES_IN_ROW);
						window_all_tiles->changed = true;
					}
					break;
				case 5:
					// Export tiles...
					if (file_select("Export tiles... (*.BMP)", filename, "BMP") != 0) {
						tileRepository->exportBitmap(filename, TILES_W, TILES_H, 0, TILES_IN_ROW);
					}
					break;
				/*
				case 3:
					// Load tile groups
					window_tile_select->load_groups("standard.ord");
					window_tile_select->changed = true;
					break;
				case 4:
					// Save tile groups
					window_tile_select->save_groups("standard.ord");
					break;
				*/
				case 6:
					// Exit program
					program_end = true;
					break;
				}
				
				updates_to_do = 0;
				changed = true;
			}
		}
		/*
		else if (b_mode->mouse_on()) {
			if (b_mode->clicked()) {
				int chosen_item = mode_menu->handle();

				switch (chosen_item) {
				case 0:
					if (edit_mode == 1) {
						edit_mode = 0;
						window_tile_select->changed = true;
						window_tile_edit->changed = true;
					}
					break;
				case 1:
					if (edit_mode == 0) {
						edit_mode = 1;
						window_tile_select->all_tiles_off();
						window_objects->changed = true;
						window_obj_prop->changed = true;
					}
					break;
				}

				updates_to_do = 0;
				changed = true;
			}
		}
		*/
		else if (b_layer->mouse_on()) {
			if (b_layer->clicked()) {
				int chosen_item = layer_menu->handle();

				switch (chosen_item) {
				case 0: selected_layer = 0; break;		// Select layer 1
				case 1: selected_layer = 2; break;		// Select layer 2
				//case 2: selected_layer = 2; break;		// Select layer 3
				}
				
				if (chosen_item > -1) {window_tiled_map->changed = true;}
				updates_to_do = 0;
				changed = true;
			}
		}
	}
}

void Menubar_Window::draw()
{
	w_main->draw();
	b_file->draw();
	//b_mode->draw();
	b_layer->draw();

	add_rect(x_min, y_min, x_max, y_max);
	changed = false;
}

