#include engine_interface

export init;
export tick;
export bump_into;
export walk_finished;

#title guard_patroling_outside
#author DLL-LJS

#define STATE_PATROL	0
#define STATE_GUARD	1
#define STATE_WAITING	2

void init(scArg arg)
{
	arg.me->speed = 3;
	arg.me->bitmap = get_bitmap("C_GUARD_BMP");
	arg.me->type = OBJ_CHAR;
	arg.me->flags = arg.me->flags | FLAG_OBSTACLE;

	arg.me->state = STATE_PATROL;
	arg.me->walk(DIR_LEFT);
}


void tick(scArg arg) {
	Object* me = arg.me;

	switch (me->state)
	{
	case STATE_GUARD:
		me->state = STATE_PATROL;
		me->tick = 0;

		if (me->x == 112) {
			me->walk(DIR_LEFT);
		}
		else {
			me->walk(DIR_RIGHT);
		}
	case STATE_WAITING:
		me->state = STATE_PATROL;
		me->walk(me->dir);
	}
}

void bump_into(scArg arg)
{
	Object* me = arg.me;

	switch (me->state)
	{
	case STATE_PATROL:
		me->state = STATE_WAITING;
		me->tick = 100;
	}
}

void walk_finished(scArg arg)
{
	Object* me = arg.me;

	switch (me->state)
	{
	case STATE_PATROL:
		if (me->dir == DIR_LEFT) {
			if (me->x == 64) {
				me->dir = DIR_UP;
				me->state = STATE_GUARD;
				me->tick = 200;
			}
			else {
				me->walk(DIR_LEFT);
			}
		} else {
			if (me->x == 112) {
				me->dir = DIR_UP;
				me->state = STATE_GUARD;
				me->tick = 200;
			}
			else {
				me->walk(DIR_RIGHT);
			}
		}
		break;
	}
}