/*
 *  An object oriented GUI.
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/


#ifndef _INCLUDED_OOGUI_
#define _INCLUDED_OOGUI_


#include <list>
#include <allegro.h>

using namespace std;


enum EWinType
{
	T_DEEP_DARK,
	T_DEEP,
	T_FLAT,
	T_HIGH,
	T_HIGH_BORDER,
	T_DEEP_BORDER
};

// WinThing types
#define T_DEEP_DARK		0
#define T_DEEP			1
#define T_FLAT			2
#define T_HIGH			3
#define T_HIGH_BORDER	4
#define T_DEEP_BORDER	5



// The base of a GUI object
class Block {
public:
	Block() : min_w(0), min_h(0), hfr(0), vfr(0) {}
	Block(int _min_w, int _min_h, int _hfr, int _vfr) : min_w(_min_w), min_h(_min_h), hfr(_hfr), vfr(_vfr) {}
	virtual ~Block() {}

	virtual int  message(int msg, int c) {return D_O_K;}
	virtual void calc_min_size() {}
	virtual void become_size(int _x, int _y, int _w, int _h) {x = _x; y = _y; w = _w; h = _h;}
	virtual void draw(BITMAP* bitmap) {}

	int min_w, min_h, hfr, vfr;

protected:
	int x, y, w, h;
};


// A branch, can have multiple Block childs
class Branch : public Block {
public:
	Branch();
	Branch(int _padding, int _space);
	Branch(int _min_w, int _min_h, int _hfr, int _vfr, int _padding, int _space);
	virtual ~Branch();

	virtual int  message(int msg, int c);
	virtual void calc_min_size();
	virtual void become_size(int _x, int _y, int _w, int _h);
	virtual void draw(BITMAP* bitmap);

	virtual void add(Block *_child);

protected:
	void alloc_memory();
	//list<Block*> childs;

	Block** child;
	int nr_of_childs;
	int padding, space;
};


// Displays childs horizontally aligned
class HBranch : public Branch {
public:
	HBranch() : Branch() {}
	HBranch(int _padding, int _space) : Branch(_padding, _space) {}
	HBranch(int _min_w, int _min_h, int _hfr, int _vfr, int _padding, int _space)
		: Branch(_min_w, _min_h, _hfr, _vfr, _padding, _space) {}
	virtual ~HBranch() {}

	virtual void calc_min_size();
	virtual void become_size(int _x, int _y, int _w, int _h);
};


// Displays childs vertically aligned
class VBranch : public Branch {
public:
	VBranch() : Branch() {}
	VBranch(int _padding, int _space) : Branch(_padding, _space) {}
	VBranch(int _min_w, int _min_h, int _hfr, int _vfr, int _padding, int _space)
		: Branch(_min_w, _min_h, _hfr, _vfr, _padding, _space) {}
	virtual ~VBranch() {}

	virtual void calc_min_size();
	virtual void become_size(int _x, int _y, int _w, int _h);
};


// A basic WinThing, with appearance
class BlockType : public Block {
public:
	BlockType(int _type) : Block(), type(_type) {};
	BlockType(int _min_w, int _min_h, int _hfr, int _vfr, int _type) : Block(_min_w, _min_h, _hfr, _vfr), type(_type) {};
	virtual ~BlockType() {};

	virtual void calc_min_size();
	virtual void draw(BITMAP* bitmap);
protected:
	int type;
};


// A button, calculates min size using the text
class Button : public BlockType {
public:
	Button(const char *_text, int _padding = 4);
	virtual ~Button();

	virtual void calc_min_size();
	virtual void draw(BITMAP* bitmap);
	bool pressed;
protected:
	char *text;
	int padding;
};



// Calculates all the GUI colors using this base color
//void set_GUI_color(int r, int g, int b);

// Will initialize the size and position of the dialogs and put them on the screen.
// It will then continue to update the block.
int do_block(Block *_block);


#endif