/*
 *  The Moonlight RPG engine  (see readme.txt about version info)
 *  MIDI interface by Georg Muntingh
 *
 *************************************************************************/

#include <allegro.h>
#include "Errors.h"
#include "MIDI.h"

MIDI *the_music;


int init_midi()
{
	char *cfg_path = new char[64];

	install_timer();

	/* install a MIDI sound driver */
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, cfg_path) != 0) {
      	output_error(0, "init_midi() - Error initialising sound system: %s\n", allegro_error);
	      return 1;
	}
	return 0;
}

int ld_midi(char *midi_file)
{
	/* load the MIDI file */
	the_music = load_midi(midi_file);
	if (!the_music) {
		output_error(0, "ld_midi() - Error reading MIDI file '%s'\n", midi_file);
		return 1;
	}
	return 0;
}

void play_midi()
{
	/* start up the MIDI file */
	if (the_music) {play_midi(the_music, true);}
}

void end_midi()
{
	/* destroy the MIDI file */
	destroy_midi(the_music);
}
