/*
 *  The Moonlight RPG engine  (see readme.txt about version info)
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <allegro.h>
#include "Errors.h"

FILE *log_file = NULL;


void open_log_file()
{
	log_file = fopen("RPG.log", "w");
	output_error(3, "-----\nStart of RPG log file\n-----\n\n");
	fclose(log_file);
}


void close_log_file()
{
	log_file = fopen("RPG.log", "a");
	output_error(3, "\n-----\nEnd of RPG log file\n-----\n");
	fclose(log_file);
}


void output_error(int action, char *error_desc, ...)
{
	char buf[512];

	va_list ap;
	va_start(ap, error_desc);
	uvsprintf(buf, error_desc, ap);
	va_end(ap);

	switch (action) {
		case 0:
			// Add the error to the console (but the console is yet to be programmed...)
			break;
		case 1:
			// Output the error in text modus and quit the program
			log_file = fopen("RPG.log", "a");
			if (log_file) {
				fprintf(log_file, "FATAL ERROR!!\n%s", buf);
			}
			fclose(log_file);
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message(buf);
			exit(1);
			break;
		case 2:
			// Popup the error in a window with an "Ok" button
			break;
		case 3:
			// Log the error (message) to the log file.
			log_file = fopen("RPG.log", "a");
			if (log_file) fprintf(log_file, buf);
			fclose(log_file);
			break;
	}
}
