/*
 *  The Moonlight RPG engine  (see readme.txt about version info)
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#include <allegro.h>
#include "Engine.h"
#include "RPG.h"
#include "Errors.h"
#include "Script.h"


bool dialog_open = false;
int dialog_x1, dialog_y1;
int dialog_x2, dialog_y2;
int text_x = 0, text_y = 0;


void open_dialog(BITMAP* left, BITMAP* right)
{
	// Setting dialog window format
	dialog_x1 = buffer->w / 4;
	dialog_y1 = buffer->h - buffer->h / 4;
	dialog_x2 = buffer->w - buffer->w / 4;
	dialog_y2 = buffer->h - buffer->h / 3 + buffer->h / 4 + 5;

	text_x = dialog_x1 + 3;
	text_y = dialog_y1 + 3 - text_height(font);

	// Draw dialog on screen
	if (left) {
		set_trans_blender(0,0,0,128);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		rectfill(buffer, dialog_x1 - left->w - 2 + 3, dialog_y1 - 1 + 3, dialog_x1  - 1 + 3, dialog_y1 + left->h + 3, makecol(0,0,0));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

		rect(buffer, dialog_x1 - left->w - 2, dialog_y1 - 1, dialog_x1 - 1, dialog_y1 + left->h, makecol(100,100,200));
		draw_sprite(buffer, left, dialog_x1 - left->w - 1, dialog_y1);
	}

	set_trans_blender(0,0,0,128);
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(buffer, dialog_x1 - 1 + 3, dialog_y1 - 1 + 3, dialog_x2 + 1 + 3, dialog_y2 + 1 + 3, makecol(0,0,0));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

	rectfill(buffer, dialog_x1, dialog_y1, dialog_x2, dialog_y2, makecol(64,64,128));
	rect(buffer, dialog_x1 - 1, dialog_y1 - 1, dialog_x2 + 1, dialog_y2 + 1, makecol(100,100,200));

	if (right) {
		set_trans_blender(0,0,0,128);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		rectfill(buffer, dialog_x2 + 1 + 3, dialog_y1 - 1 + 3, dialog_x2 + 2 + right->w + 3, dialog_y1 + right->h + 3, makecol(0,0,0));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

		rect(buffer, dialog_x2 + 1, dialog_y1 - 1, dialog_x2 + 2 + right->w, dialog_y1 + right->h, makecol(100,100,200));
		draw_sprite(buffer, right, dialog_x2 + 2, dialog_y1);
	}

	dialog_open = true;
}

void close_dialog()
{
	dialog_open = false;
}


void wait_for_key(int bitmap)
{
	// Draw arrow
	DATAFILE* data_arrow = NULL;
	BITMAP* arrow = NULL;
	int count = 0;
	bool arrow_vis = false;

	switch (bitmap) {
	case 0: data_arrow = find_datafile_object(bitmap_data, "ARROW_BMP"); break;
	case 1: data_arrow = find_datafile_object(bitmap_data, "SQUARE_BMP"); break;
	}
	if (data_arrow) {
		arrow = (BITMAP*)(data_arrow->dat);
		draw_sprite(buffer, arrow, dialog_x2 - arrow->w - 1, dialog_y2 - arrow->h - 1);
		arrow_vis = true;
		update_screen();
	}

	handle_input();
	while (inkey != KEY_SPACE) {
		count++;
		if (arrow && count > 20) {
			if (arrow_vis) {
				arrow_vis = false;
				rectfill(buffer, dialog_x2 - arrow->w - 1, dialog_y2 - arrow->h - 1, dialog_x2 - 1, dialog_y2 - 1, makecol(64,64,128));
				update_screen();
			} else {
				arrow_vis = true;
				draw_sprite(buffer, arrow, dialog_x2 - arrow->w - 1, dialog_y2 - arrow->h - 1);
				update_screen();
			}
			count = 0;
		}
		handle_input();
		wait_for_update();
	}
	// Remove arrow
	if (arrow) {
		rectfill(buffer, dialog_x2 - arrow->w - 1, dialog_y2 - arrow->h - 1, dialog_x2 - 1, dialog_y2 - 1, makecol(64,64,128));
	}
	update_screen();
	inkey = 0;
}

void scroll_up()
{
	int pixels_up = 2 * text_height(font);

	// Scroll existing stuff up
	frames_to_do = 0;
	for (int i = 0; i < pixels_up; i++) {
		wait_for_update();
		blit(
			buffer,
			buffer,
			dialog_x1 + 3,
			dialog_y1 + 4,
			dialog_x1 + 3,
			dialog_y1 + 3,
			dialog_x2 - dialog_x1 - 3,
			dialog_y2 - dialog_y1 - 3 - 5
		);
		update_screen();
	}

	text_y = dialog_y1 + text_height(font) + 3;
	text_x = dialog_x1 + 3;
}

void next_line(bool key)
{
	text_y += text_height(font);
	text_x = dialog_x1 + 3;

	if (text_y + text_height(font) > dialog_y2 - 4)
	{
		// Wait for keypress
		if (key) wait_for_key(0);
		scroll_up();
	}
}

void write_in_dialog(char* string, int color, bool new_line)
{
	char buf2[2];

	if (new_line) next_line(false);

	char *token;
	for (token = strtok(string, " "); token; token = strtok(NULL, " ")) {
		int toklen = text_length(font, token);
		if (text_x + toklen > dialog_x2 - 3) {
			update_screen();
			next_line(true);
		}

		// Print token to screen with delay
		for (int i = 0; i < strlen(token); i++) {
			handle_input();
			wait_for_update();

			sprintf(buf2, "%c", token[i]);
			textprintf(buffer, font, text_x, text_y, color, buf2);
			text_x += text_length(font, buf2);
			update_screen();
		}

		text_x += 4;
	}
}

void write_text(const char* name, const char* text)
{
	char buf[1024];

	if (name) {
		sprintf(buf, "%s: %s", name, text);
	} else {
		sprintf(buf, "%s", text);
	}

	write_in_dialog(buf, makecol(200,200,200), true);
	wait_for_key(1);
}

int get_command()
{
	// Draw combat bar
	DATAFILE* data_combat_bar = NULL;
	BITMAP* combat_bar = NULL;
	data_combat_bar = find_datafile_object(bitmap_data, "COMBAT_BAR_BMP");

	if (data_combat_bar) combat_bar = (BITMAP*)(data_combat_bar->dat);

	draw_sprite(buffer, combat_bar, dialog_x1 + 1, dialog_y2 - combat_bar->h);
	update_screen();

	int command = 0;
	handle_input();
	while (command == 0) {
		handle_input();
		if (inkey == KEY_A) command = 1;
		if (inkey == KEY_R) command = 2;
		//if (inkey == KEY_I) command = 3;
	}

	rectfill(buffer, dialog_x1 + 1, dialog_y2 - combat_bar->h, dialog_x1 + 1 + combat_bar->w - 1, dialog_y2 - 1, makecol(64,64,128));
	return command;
}

void draw_health_bars(Object* left, Object* right)
{
	if (left->max_health <= 0) output_error(1, "Error, \"%s\" does not have a legal max_health!", left->name);
	if (right->max_health <= 0) output_error(1, "Error, \"%s\" does not have a legal max_health!", right->name);

	int length_left = (left->health * 27) / left->max_health;
	int length_right = (right->health * 27) / right->max_health;

	int x1 = dialog_x1 - 28 - 1;
	int x2 = dialog_x2 + 2;
	int y = dialog_y1 + 38 - 1;

	hline(buffer, x1, y, x1 + 27, makecol(0,0,0));
	if (length_left > 0) hline(buffer, x1, y, x1 + length_left, makecol(200,0,0));

	hline(buffer, x2, y, x2 + 27, makecol(0,0,0));
	if (length_right > 0) hline(buffer, x2, y, x2 + length_right, makecol(200,0,0));

	update_screen();
}

void start_combat(Object* enemy)
{
	char buf[1024];
	bool end_of_combat = false;

	if (!enemy) {
		output_error(1, "Error, start_combat() needs an enemy!");
	}

	draw_health_bars(player, enemy);

	sprintf(buf, "Starting combat with %s", enemy->script);
	write_in_dialog(buf, makecol(230,230,0), true);

	while (!end_of_combat) {
		switch (get_command())
		{
		case 1: // Attack
			{
				// We attack the monster

				// Calculate combat values
				int hit = (player->agi - enemy->agi) * 4 + 50;
				int dam = (player->str / 2) + (rand() % (player->str + 1));
				int damage_taken = (dam * 20) / enemy->def;
				output_error(3, "Player attack: hit = %i, dam = %i, dam_taken = %i\n", hit, dam, damage_taken);

				// Report combat result
				if (rand() % 100 < hit) {
					enemy->health -= damage_taken;
					draw_health_bars(player, enemy);
					sprintf(buf, "%s takes %i damage.", enemy->script, damage_taken);
					write_in_dialog(buf, makecol(0,250,0), true);
				} else {
					sprintf(buf, "You miss.");
					write_in_dialog(buf, makecol(200,200,200), true);
				}

				// Check if enemy is dead
				if (enemy->health < 0) {
					sprintf(buf, "%s dies!", enemy->script);
					write_in_dialog(buf, makecol(0,250,0), true);
					end_of_combat = true;
					execute_script(enemy->script, "end_of_combat", enemy, player, END_DEFEAT, damage_taken, 0);
					execute_script(player->script, "end_of_combat", player, enemy, END_VICTORY, damage_taken, 0);
				} else {
					execute_script(enemy->script, "hit", enemy, player, WHO_PLAYER, damage_taken, 0);
					execute_script(player->script, "hit", player, enemy, WHO_ME, damage_taken, 0);
				}
			}
			break;
		case 2: // Run
			{
				int run_succeed = (player->speed - enemy->speed) * 4 + 50;
				if (rand() % 100 < run_succeed) {
					sprintf(buf, "You run away.");
					write_in_dialog(buf, makecol(0,250,0), true);
					end_of_combat = true;
					execute_script(enemy->script, "end_of_combat", enemy, player, END_RUNAWAY, 0, 0);
					execute_script(player->script, "end_of_combat", player, enemy, END_RUNAWAY, 0, 0);
				} else {
					sprintf(buf, "You failed to run away.");
					write_in_dialog(buf, makecol(0,250,0), true);
				}
			}
			break;
		case 3: // Item
			break;
		}

		// If enemy is not dead, he'll fight back!

		if (!end_of_combat) {
			// Calculate combat values
			int hit = (enemy->agi - player->agi) * 4 + 50;
			int dam = (enemy->str / 2) + (rand() % (enemy->str + 1));
			int damage_taken = (dam * 20) / player->def;
			output_error(3, "Enemy attack: hit = %i, dam = %i, dam_taken = %i\n", hit, dam, damage_taken);

			// Report combat result
			if (rand() % 100 < hit) {
				player->health -= damage_taken;
				draw_health_bars(player, enemy);
				sprintf(buf, "You take %i damage.", damage_taken);
				write_in_dialog(buf, makecol(250,0,0), true);
			} else {
				sprintf(buf, "%s misses you.", enemy->script);
				write_in_dialog(buf, makecol(200,200,200), true);
			}

			// Check if player is dead
			if (player->health < 0) {
				sprintf(buf, "You have died!", enemy->script);
				write_in_dialog(buf, makecol(250,0,0), true);
				end_of_combat = true;
				execute_script(enemy->script, "end_of_combat", enemy, player, END_VICTORY, 0, 0);
				execute_script(player->script, "end_of_combat", player, enemy, END_DEFEAT, 0, 0);
			} else {
				execute_script(enemy->script, "hit", enemy, player, WHO_ME, damage_taken, 0);
			}
		}
	}

	wait_for_key(1);
}

