#include engine_interface

#title rat
#author DLL-LJS

export init;
export bumped_into;
export activate;
export stand_on;
export tick;
export bump_into;
export walk_finished;

void init(scArg arg)
{
	Object* obj = arg.me;

	// Making sure this rat looks like a rat.
	obj->speed = 3;
	obj->bitmap = get_bitmap("C_RAT_BMP");
	obj->type = OBJ_CHAR;
	obj->flags = obj->flags | FLAG_OBSTACLE;

	// Set a small delay after which a goal is chosen
	obj->tick = random(100) + 10;

	obj->var[0] = 0; // variable for distance
	obj->var[1] = 0; // variable for direction
}

void bumped_into(scArg arg)
{
	if (get_pgp("rat_encountered") == 0 && get_object("player") == arg.obj)
	{
		open_dialog(NULL, NULL);
		write_text("Rat", "Squeeek!");
		write_text("Zork", "Beat it, you stupid rat!");
		close_dialog();
		set_pgp("rat_encountered", 1);
	}
}

void activate(scArg arg)
{
	open_dialog(NULL, NULL);
	write_text("Rat", "Squeeek!");
	close_dialog();
}

void stand_on(scArg arg)
{
	if (get_object("player") == arg.obj) {
		open_dialog(NULL, NULL);
		write_text("Rat", "SQUEEEK!");

		// Change to squished, dead rat

		close_dialog();
	}
}

void tick(scArg arg)
{
	Object* rat = arg.me;

	// Choose new goal and start walking towards it
	rat->var[1] = random(4);
	rat->var[0] = random(5);
	rat->tick = 0;
	rat->walk(rat->var[1]);
}

void bump_into(scArg arg)
{
	// Pause for some time and choose another direction
	arg.me->tick = random(100) + 10;
}

void walk_finished(scArg arg)
{
	Object* rat = arg.me;

	if (rat->var[0] <= 0) {
		// Reached his goal, pause and choose new goal.
		rat->tick = random(100) + 10;
	} else {
		// Walking to goal, keep walking.
		rat->var[0]--;
		rat->walk(rat->var[1]);
	}
}