#include engine_interface

#title rat
#author DLL-LJS

export init;
export bumped_into;
export activate;
export stand_on;
export tick;
export bump_into;
export walk_finished;

void init(scArg arg)
{
	Object* obj = arg.me;

	// Making sure this rat looks like a rat.
	obj->speed = 1;
	obj->bitmap = get_bitmap("C_ZORK_BMP");
	obj->type = OBJ_CHAR;
	obj->flags = obj->flags | FLAG_OBSTACLE;

	// Set a small delay after which a goal is chosen
	obj->tick = random(300) + 10;

	obj->var[0] = 0; // variable for distance
	obj->var[1] = 0; // variable for direction
}

void bumped_into(scArg arg)
{
	if (get_pgp("prisoner_encountered") == 0 && get_object("player") == arg.obj)
	{
		open_dialog(NULL, NULL);
		write_text("Prisoner", "Save me...");
		write_text("Zork", "Save yourself, I'm outta here.");
		close_dialog();
		set_pgp("prisoner_encountered", 1);
	}
}

void activate(scArg arg)
{
	open_dialog(NULL, NULL);
	write_text("Prisoner", "Go away!");
	close_dialog();
}

void stand_on(scArg arg)
{
	if (get_object("player") == arg.obj) {
		open_dialog(NULL, NULL);
		write_text("Prisoner", "Go away!");

		// Change to squished, dead rat

		close_dialog();
	}
}

void tick(scArg arg)
{
	Object* me = arg.me;

	// Choose new goal and start walking towards it
	me->var[1] = random(4);
	me->var[0] = random(5);
	me->tick = 0;
	me->walk(me->var[1]);
}

void bump_into(scArg arg)
{
	// Pause for some time and choose another direction
	arg.me->tick = random(250) + 10;
}

void walk_finished(scArg arg)
{
	Object* me = arg.me;

	if (me->var[0] <= 0) {
		// Reached his goal, pause and choose new goal.
		me->tick = random(250) + 10;
	} else {
		// Walking to goal, keep walking.
		me->var[0]--;
		me->walk(me->var[1]);
	}
}