#include engine_interface

#title bear
#author Frode Lindeijer

export init;
export bumped_into;
export tick;
export bump_into;
export walk_finished;
export end_of_combat;

#define STATE_ALIVE		0
#define STATE_DEFEATED	1

void init(scArg arg)
{
	Object* me = arg.me;

	// Making sure this rat looks like a rat.
	me->speed = 3;
	me->flags = me->flags | FLAG_OBSTACLE;

	// Set a small delay after which a goal is chosen
	me->tick = random(100) + 10;

	me->var[0] = 0; // variable for distance
	me->var[1] = 0; // variable for direction

	me->max_health = 100;
	me->health = 100;
	me->agi = 4;
	me->str = 4;
	me->def = 4;
}

void bumped_into(scArg arg)
{
	Object *me = arg.me;

	if (get_object("player") == arg.obj)
	{
		open_dialog(get_bitmap("ZORK_BMP"), get_bitmap("MONSTER4_BMP"));
		start_combat(me);
		close_dialog();
	}
}

void tick(scArg arg)
{
	Object* rat = arg.me;

	if (rat->state == STATE_DEFEATED)
	{
		rat->health = rat->max_health;
		rat->flags = FLAG_OBSTACLE;
		rat->state = STATE_ALIVE;
	}

	// Choose new goal and start walking towards it
	rat->var[1] = random(4);
	rat->var[0] = random(5);
	rat->tick = 0;
	rat->walk(rat->var[1]);
}

void bump_into(scArg arg)
{
	// Pause for some time and choose another direction
	arg.me->tick = random(100) + 10;
}

void walk_finished(scArg arg)
{
	Object* rat = arg.me;

	if (rat->tick == 0) {
		if (rat->var[0] <= 0) {
			// Reached his goal, pause and choose new goal.
			rat->tick = random(100) + 10;
		} else {
			// Walking to goal, keep walking.
			rat->var[0]--;
			rat->walk(rat->var[1]);
		}
	}
}

void end_of_combat(scArg arg)
{
	Object* me = arg.me;

	//if (arg.a == END_DEFEAT)
	//{
		me->flags = 0;
		me->tick = 6000;
		me->state = STATE_DEFEATED;
		// Beaten, pause for > minute
	//}
}