/*
 *  RPGEdit.cpp:  RPG Edit (tiled map editor)
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/


#include <allegro.h>
#include "DRS.h"
#include "Errors.h"
#include "tiledmap.h"
#include "GUI.h"
#include "OOGUI.h"
#include "Editor.h"

volatile int updates_to_do;					// update counter
void add_program_update() {updates_to_do++;}
END_OF_FUNCTION(add_program_update);


#define PROGRAM_ID			"RPG Edit [MiniRPG version]"
#define CREATOR_ID			"Moonlight Productions"
#define LPS					100					// program loops per second  -  sets the updating speed
bool VSYNC = false;

extern BITMAP *buffer;						// memory bitmap (from c_DRS.cpp)

WinThing           *w_upper;
Menubar_Window     *window_menubar;
Tiled_Map_Window   *window_tiled_map;
All_Tiles_Window   *window_all_tiles;
Palet_Window       *window_palet;
Tile_Edit_Window   *window_tile_edit;
WinThing           *w_status;
/*
Tile_Select_Window *window_tile_select;
Objects_Window     *window_objects;
Obj_Prop_Window    *window_obj_prop;
*/

Entity* hoverEntity = new Entity();

bool program_end = false;
int selected_layer = 0;
int selected_color = 0;
int edit_mode = 0;
int inkey;									// last pressed key
char map_name[256] = "untitled.map";
char status_message[256] = "";
char current_status[256] = "";

TiledMap *tiledMap;
TileRepository *tileRepository;
TileType *selectedTile = NULL;
BITMAP* copied_tile;

extern int gui_color[];

void init_program();
void init_screen();
void handle_input();
void update_screen();
void exit_program();


int main()
{
	init_program();

	do {
		if (updates_to_do > 0) {

			// These two commands are excecuted LPS times every second.
			handle_input();
			updates_to_do--;

			// If less than 2 updates are waiting, take time to display current program state.
			// If more than 10 updates are waiting, the system must have had something else to do.
			if      (updates_to_do < 2)  {update_screen();}
			else if (updates_to_do > 10) {updates_to_do -= 10;}
		}
	} while (!program_end);

	exit_program();
	return 0;
}
END_OF_MAIN();



void init_program()
{
	allegro_init();	 install_keyboard();	// Allegro initialisation
	install_timer(); install_mouse();

	set_color_depth(16);

	set_config_file("RPGEdit.cfg");
	int driver = GFX_AUTODETECT_WINDOWED;
	if (get_config_int("video", "fullscreen", 1)) {
		driver = GFX_AUTODETECT_FULLSCREEN;
	}
	int resolution = get_config_int("video", "resolution", 640);

	if (resolution == 800) {
		if (set_gfx_mode(driver, 800, 600, 0, 0) < 0) {
			output_error(1, "%s\n", allegro_error);
		}
	}
	else if (resolution == 320) {
		if (set_gfx_mode(driver, 320, 240, 0, 0) < 0) {
			output_error(1, "%s\n", allegro_error);
		}
	}
	else if (resolution == 400) {
		if (set_gfx_mode(driver, 400, 300, 0, 0) < 0) {
			output_error(1, "%s\n", allegro_error);
		}
	}
	else if (set_gfx_mode(driver, 640, 480, 0, 0) < 0) {
		output_error(1, "%s\n", allegro_error);
	}

	text_mode(-1);
	set_GUI_color(76,73,70);
	set_GUI_mouse(P_STANDARD);
	gui_fg_color = gui_color[1];
	gui_bg_color = gui_color[4];

	DATAFILE* hoverTile = load_datafile_object("GUI.dat", "HOVER_BMP");
	if (hoverTile) {
		hoverEntity->bitmap = (BITMAP*)(hoverTile->dat);
	}



	tiledMap = new SquareMap(TILES_W, TILES_H);
	tiledMap->resizeTo(128, 128);
	if (hoverEntity) tiledMap->addEntity(hoverEntity);

	tileRepository = new TileRepository();
	tileRepository->importBitmap("georg.bmp", TILES_W, TILES_H, 0, TILES_IN_ROW);
	tileRepository->importBitmap("frode.bmp", TILES_W, TILES_H, 0, TILES_IN_ROW);

	init_DRS();								// This creates the buffer
	init_GUI();								// Initializes the font

	// Initialize the windows
	w_upper            = new WinThing           (             0,              0, SCREEN_W -   1,             14);
	window_menubar     = new Menubar_Window     (             0,             15, SCREEN_W -   1,             32);
	window_palet       = new Palet_Window       (            64, SCREEN_H -  95,            140, SCREEN_H -  16);
	w_status           = new WinThing           (             0, SCREEN_H -  15, SCREEN_W -   1, SCREEN_H -   1);
	/*
	window_tile_select = new Tile_Select_Window (SCREEN_W - 162,             33, SCREEN_W -   1, SCREEN_H -   1);
	window_objects     = new Objects_Window     (             0, SCREEN_H - 100, SCREEN_W - 163, SCREEN_H -   1);
	window_obj_prop    = new Obj_Prop_Window    (SCREEN_W - 162,             33, SCREEN_W -   1, SCREEN_H -   1);
	*/
	if (resolution != 320) {
		window_tile_edit   = new Tile_Edit_Window   (             0, SCREEN_H -  95, SCREEN_W - 222, SCREEN_H -  16);
		window_tiled_map   = new Tiled_Map_Window   (             0,             33, SCREEN_W - 222, SCREEN_H -  96);
		window_all_tiles   = new All_Tiles_Window   (SCREEN_W - 221,             33, SCREEN_W -   1, SCREEN_H -  16);
	} else {
		window_tile_edit   = new Tile_Edit_Window   (             0, SCREEN_H -  95, SCREEN_W - 118, SCREEN_H -  16);
		window_tiled_map   = new Tiled_Map_Window   (             0,             33, SCREEN_W - 118, SCREEN_H -  96);
		window_all_tiles   = new All_Tiles_Window   (SCREEN_W - 117,             33, SCREEN_W -   1, SCREEN_H -  16);
	}

	init_screen();							// Prepare the screen (first time draw)
	show_mouse(screen);						// The mouse appears on the screen


	LOCK_VARIABLE(updates_to_do);			// Time handler
	LOCK_FUNCTION(add_program_update);
	install_int_ex(add_program_update, BPS_TO_TIMER(LPS));
}

void init_screen()
{
	/*
	Branch *b1, *b2;

	// Create map window + object/tile properties
	b1 = new VBranch(0, 0, 1, 1, 0, 0);
	b1->add(new BlockType(10, 10, 1, 1, T_HIGH_BORDER));
	b1->add(new TileEditWindow);

	// Combine the above with the sidebar, containing the tiles/objects
	b2 = new HBranch(0, 0, 1, 1, 0, 0);
	b2->add(b1);
	b2->add(new BlockType(160, 20, 0, 1, T_HIGH));

	// Combine it with title and menu bars
	b1 = new VBranch(0, 0, 1, 1, 0, 0);
	b1->add(new Titlebar);
	b1->add(new BlockType(0, 16, 1, 0, T_HIGH));
	b1->add(b2);

	// Display it on the screen
	do_block(b1);
	*/

	clear(buffer);

	w_upper ->draw();
	window_tiled_map->draw();
	window_tile_edit->draw();
	window_all_tiles->draw();
	window_menubar->draw();
	window_palet->draw();
	w_status->draw();
	/*
	window_tile_select->draw();
	*/

	textprintf      (buffer, font, 2 + 1,            0 + 2, gui_color[0], PROGRAM_ID);
	textprintf      (buffer, font, 2,                0 + 1, gui_color[5], PROGRAM_ID);
	textprintf_right(buffer, font, SCREEN_W - 3 + 1, 0 + 2, gui_color[4], CREATOR_ID);
	textprintf_right(buffer, font, SCREEN_W - 3    , 0 + 1, gui_color[1], CREATOR_ID);

	add_rect(0, 0, SCREEN_W - 1, SCREEN_H - 1);
	put_rects();
}

void handle_input()
{
	strcpy(status_message, "");

	if (key[KEY_ESC]) {program_end = true;}

	if (keypressed()) {inkey = (readkey() & 0xff);}
	else              {inkey = 0;}

	if (inkey == '1') {selected_layer = 0; window_tiled_map->changed = true;}
	if (inkey == '2') {selected_layer = 1; window_tiled_map->changed = true;}
	if (inkey == '3') {selected_layer = 2; window_tiled_map->changed = true;}

	window_menubar->user_input();
	window_tiled_map->user_input();
	switch (edit_mode) {
	case 0:	window_all_tiles->user_input();
			window_tile_edit->user_input();
			window_palet->user_input();
			/*
			window_tile_select->user_input();
			*/
			break;
	/*
	case 1:	window_objects->user_input();
			window_obj_prop->user_input();
			break;
	*/
	}

	if (inkey == 'c' || inkey == 'C') {
		// Copy tile
		if (selectedTile) {
			copied_tile = selectedTile->getBitmap();
		}
	}
	if (inkey == 'v' || inkey == 'V') {
		// Paste tile
		if (selectedTile && copied_tile) {
			BITMAP* bitmap = selectedTile->getBitmap();
			blit(copied_tile, bitmap, 0, 0, 0, 0, TILES_W, TILES_H);
			window_tiled_map->changed = true;
			window_all_tiles->changed = true;
			window_tile_edit->changed = true;
		}
	}
}

void update_screen()
{
	if (window_menubar->changed)     {window_menubar->draw();}
	if (window_tiled_map->changed)   {window_tiled_map->draw();}
	switch (edit_mode) {
	case 0:	if (window_all_tiles->changed)   {window_all_tiles->draw();}
			if (window_tile_edit->changed)   {window_tile_edit->draw();}
			if (window_palet->changed)       {window_palet->draw();}
			/*
			if (window_tile_select->changed) {window_tile_select->draw();}
			*/
			break;
	/*
	case 1:	if (window_objects->changed)     {window_objects->draw();}
			if (window_obj_prop->changed)    {window_obj_prop->draw();}
			break;
	*/
	}
	if (strcmp(current_status, status_message) != 0) {
		w_status->draw();
		textprintf_centre(buffer, font, SCREEN_W / 2 + 1, w_status->y_min + 2, gui_color[0], status_message);
		textprintf_centre(buffer, font, SCREEN_W / 2,     w_status->y_min + 1, gui_color[5], status_message);
		add_rect(0, SCREEN_H - 15, SCREEN_W - 1, SCREEN_H - 1);
		strcpy(current_status, status_message);
	}

	if (!key[KEY_F5]) {
		put_rects();
	} else {
		show_mouse(NULL);
		blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		show_mouse(screen);
	}
}

void exit_program()
{
	remove_int(add_program_update);

	delete w_upper;
	delete window_menubar;
	delete window_tiled_map;
	delete window_all_tiles;
	delete window_tile_edit;
	delete window_palet;
	delete w_status;
	/*
	delete window_tile_select;
	delete window_objects;
	delete window_obj_prop;
	*/

	delete tileRepository;
	exit_DRS();
}