/*
 *  The Moonlight RPG engine  (see readme.txt about version info)
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#ifndef _INCLUDED_RPG_H_
#define _INCLUDED_RPG_H_

#include "tiledmap.h"
#include "Engine.h"
#include <map>


// Some engine settings
#define PROGRAM_ID			"Anestor RPG engine [MiniRPG version]"
#define LPS					100		// Game loops per second  -  sets the game speed and possible frame rate
#define NR_OF_ITEM_SLOTS	10


extern volatile int frames_to_do;
extern volatile int fps, fps_counter;

extern int inkey;							// Last pressed key

extern DATAFILE *interface_graphics;
extern DATAFILE *bitmap_data;

extern TiledMap *tiledMap;
extern TileRepository *tileRepository;
extern TileType *selectedTile;

extern BITMAP *buffer;

extern bool game_end;

void ex_update_game(Object* excl_obj);
void wait_for_update();
void init_engine();
void init_rpg();
void init_graphics();
void handle_input();
void update_screen();
void draw_screen();
void exit_program();


#endif