/*
 *  GUI.h:  GUI things. Featuring:
 *               - WinThings, used as basis for any kind of window
 *               - ButtonThings, automated buttons with label
 *               - ScrollThings, partly automated scrollbars
 *               - MenuThings, easy to use pop-up menu's
 *
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#ifndef _INCLUDED_GUI_H_
#define _INCLUDED_GUI_H_


// WinThing types
#define W_DEEP_DARK		-2
#define W_DEEP			-1
#define W_FLAT			0
#define W_HIGH			1
#define W_HIGH_BORDER	2
#define W_DEEP_BORDER	3

// Mouse pointers
#define P_STANDARD		0
#define P_FILE			1



class WinThing {
public:
	WinThing(int ix_min, int iy_min, int ix_max, int iy_max,	// Constructor
		int itype = 1, int iback = 3);
	void set_rect(int ix_min=-99, int iy_min=-99, int ix_max=-99, int iy_max=-99,	// Changes WinThing properties
		int itype=-99, int iback=-99);
	void draw(BITMAP *bitmap = NULL);							// Draw the WinThing
	
	bool mouse_on(int border = 0);								// Return TRUE if mouse is on WinThing
	
	short int x_min, y_min, x_max, y_max;
private:
	short int type, back;
};


class ButtonThing {
public:
	ButtonThing(int ix_min, int iy_min, int ix_max, int iy_max, char *ilabel);
	~ButtonThing();
	void set_button(int ix_min=-99, int iy_min=-99, int ix_max=-99, int iy_max=-99,	// Changes ButtonThing properties
		char *ilabel = NULL);
	void draw();												// Draw the button
	
	bool clicked();												// Return TRUE if button is clicked
	bool mouse_on();											// Return TRUE if mouse is on the button
	bool pressed;
private:
	short int x_min, y_min, x_max, y_max;
	WinThing *w_button;
	char *label;
};


class ScrollThing {
public:
	ScrollThing(int ix_min, int iy_min, int ix_max, int iy_max,
		int idir, int io_length, int iw_length, int ishift);
	~ScrollThing();
	void set_values(int ix_min = -99, int iy_min = -99, int ix_max = -99, int iy_max = -99,
		int io_length=-99, int iw_length=-99, int ishift=-99);
	void draw();												// Draw the scrollbar
	
	int handle(bool init);										// Return new shift value (or initialise)
	bool mouse_on();											// Return TRUE if mouse is on the scrollbar
private:
	short int x_min, y_min, x_max, y_max, bar_size;
	long int o_length, w_length, my_length, shift;
	short int grab_dist, min_scroll, max_scroll, dir;
	WinThing *w_scrollback;
	WinThing *w_scrollbar;
};


class MenuThing {
public:
	MenuThing(int ix, int iy, char *items);
	~MenuThing();
	void locate(int ix, int iy);
	void draw();												// Draw the menu
	
	int  handle();												// Handle menu and return the chosen item
	bool mouse_on();											// Return TRUE if mouse is on the menu
private:
	int  find_selected_item();
	short int x, y, width, height;
	short int nr_of_items, selected_item;
	char *item[16];
	WinThing *w_back;
	BITMAP *background;
};


void init_GUI();												// Set the standard font
void set_GUI_mouse(int pointer_type);							// Set the GUI mouse pointer (0 or 1)
void set_GUI_color(int r, int g, int b);						// Set the global GUI color scheme

#endif
