/*
 *  The Moonlight RPG engine  (see readme.txt about version info)
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#ifndef _INCLUDED_ENGINE_H_
#define _INCLUDED_ENGINE_H_

#include "tiledmap.h"

#define DIR_UP			0
#define DIR_LEFT		1
#define DIR_RIGHT		2
#define DIR_DOWN		3

#define TILES_W			12
#define TILES_H			12
#define TILES_IN_ROW	16

#define OBJ_STATIC		0
#define OBJ_CHAR		1

#define FLAG_OBSTACLE	1
#define FLAG_ENEMY		2


// Combat defines

#define WHO_PLAYER		0	// This creature attacked the player
#define WHO_ME			1	// We have been attacked by the player

#define END_RUNAWAY		0	// The player ran away
#define END_VICTORY		1	// The player has won
#define END_DEFEAT		2	// The player has been defeated



//====================================================================================

class Object
{
  public:
	BITMAP* bitmap;
	int x, y, dir;
	int count, tick;
	int speed;
	int type;
	int flags;
	int walking;
	int state;
	int str, agi, def;
	int health, max_health;
	int var[10];
	Object* obj[10];

	void walk(int dir);
	void walk_nocol(int dir);


	Object(int x, int y, const char* script);
	~Object();
	void check_stand_on();
	void update();
	void update_entity();

	Entity* entity;
	char script[256];
	char name[256];
	Point mapPos;
	bool initialized;

	int ani_sequence[2];
	static void export_script_methods();
};

struct scArg {
	Object* me;
	Object* obj;
	int a, b, c;
};


//===================   Engine functions   ===========================================

void update_objects();
void switch_area_now();


//===================   Script functions   ===========================================

void show_bitmap_and_wait(BITMAP* bitmap);
void import_tile_bmp(const char* filename);
Object* add_object(int x, int y, const char* name, const char* script);
Object* get_object(const char* name);
void ex_walk(Object* obj, int dir, int dist);
void ex_wait(int updates);
void set_player(Object *player);
void set_camera_target(Object *obj);
BITMAP* get_bitmap(const char* name);
void load_area(const char* area_name);
void set_pgp(const char* name, int value);
int  get_pgp(const char* name);
int random(int nr);
void quit_game();

// Dialog functions (implemented in Dialog.cpp)
void open_dialog(BITMAP* left, BITMAP* right);
void close_dialog();
void write_text(const char* name, const char* text);
void start_combat(Object* enemy);

extern bool dialog_open;


//===================   Variables   ==================================================

extern map<const char*, Object*, ltstr> objects;
extern map<const char*, int, ltstr> progress_points;
extern Object* player;
extern Object* camera_target;

extern bool exclusive_mode;

extern bool switch_area;
extern char area_name[64];
extern char map_filename[64];

#endif
