/*
 *  c_EditObjects.cpp:	Classes of the object-related parts of RPG Edit
 *  By Bjrn Lindeijer
 *
 ************************************************************************************/

#include <allegro.h>
#include "Errors.h"
#include "DRS.h"
#include "GUI.h"
#include "OOGUI.h"
#include "tiledmap.h"
#include "Editor.h"

extern int gui_color[];

extern volatile int updates_to_do;
int selected_object = -1;
bool mouse_is_object = false;
extern BITMAP *buffer;



//===================   Object_Window   ==============================================


Objects_Window::Objects_Window(int ix_min, int iy_min, int ix_max, int iy_max)
{
	x_min = ix_min; x_max = ix_max;
	y_min = iy_min; y_max = iy_max;
	obj_width = 65;
	schuif = 0; nr_of_items = 0;
	
	w_main = new WinThing(x_min, y_min, x_max, y_max - 7, 2, 2);
	w_object = new WinThing(x_min + 3, y_min + 3, x_min + 3 + obj_width, y_max - 10, 0, 0);

	/*
	for (int i = 0; i < 1000 && nr_of_items < MAX_OBJECT_ITEMS; i++) {
		if (item[i]) {
			if (item[i]->field_bitmap) {
				object_item[nr_of_items] = i;
				nr_of_items++;
			}
		}
	}
	*/

	s_scrollbar = new ScrollThing(x_min, y_max - 6, x_max, y_max, 0,
		(nr_of_items*obj_width) + 1, (x_max-3) - (x_min+2), schuif);
	
	changed = true;
}

Objects_Window::~Objects_Window()
{
	delete w_main;
	delete w_object;
	delete s_scrollbar;
}

void Objects_Window::user_input()
{
	if (mouse_b & 1) {
		if (w_main->mouse_on(3)) {
			int sel_item = (mouse_x - x_min - 4 + schuif) / obj_width;
			sel_item = (sel_item < 0) ? 0 : (sel_item >= nr_of_items) ? nr_of_items - 1 : sel_item;
			if (object_item[sel_item] != selected_object) {
				selected_object = object_item[sel_item];
				mouse_is_object = false;
				draw(); put_rects();
				set_GUI_mouse(1);
				do {;} while (mouse_b & 1); updates_to_do = 0;
			}
			else {
				selected_object = -1;
				draw(); put_rects();
				set_GUI_mouse(0);
				do {;} while (mouse_b & 1); updates_to_do = 0;
			}
		}
		if (s_scrollbar->mouse_on()) {
			int prev_schuif = schuif;
			s_scrollbar->handle(1);
			do {
				schuif = s_scrollbar->handle(0);
				if (prev_schuif != schuif) {
					draw(); put_rects();
					prev_schuif = schuif;
				}
			} while (mouse_b & 1);
		}
	}
}

void Objects_Window::draw()
{
	w_main->draw();
	s_scrollbar->draw();
	
	set_clip(buffer, x_min + 3, y_min + 3, x_max - 3, y_max - 10);
	/*
	for (int i = 0; i < nr_of_items; i++) {
		if (object_item[i] == selected_object) {
			w_object->set_rect(x_min + 4 - schuif + (obj_width*i), -99, x_min + 2 + (obj_width*(i+1)) - schuif, -99, 0, 3);
			w_object->draw();
			draw_sprite(buffer, item[object_item[i]]->field_bitmap,
				x_min + 4 - schuif + (obj_width*i) + (obj_width / 2) - (item[object_item[i]]->field_bitmap->w / 2),
				((y_max - 7 + y_min) / 2) - (item[object_item[i]]->field_bitmap->h / 2));
			textprintf(buffer, font, x_min + 6 - schuif + (obj_width*i), y_min + 4, gui_color[4], "%i", object_item[i]);
		}
		else {
			w_object->set_rect(x_min + 4 - schuif + (obj_width*i), -99, x_min + 2 + (obj_width*(i+1)) - schuif, -99, 0, 0);
			w_object->draw();
			draw_sprite(buffer, item[object_item[i]]->field_bitmap,
				x_min + 4 - schuif + (obj_width*i) + (obj_width / 2) - (item[object_item[i]]->field_bitmap->w / 2),
				((y_max - 7 + y_min) / 2) - (item[object_item[i]]->field_bitmap->h / 2));
			textprintf(buffer, font, x_min + 6 - schuif + (obj_width*i), y_min + 4, gui_color[3], "%i", object_item[i]);
		}
	}
	*/

	// Transparent schadows at the left and right side of the window
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender(0,0,0,125);
	vline(buffer, x_max - 3, y_min + 3, y_max - 10, makecol(0,0,0));
	set_trans_blender(0,0,0,75);
	vline(buffer, x_min + 3, y_min + 3, y_max - 10, makecol(0,0,0));
	vline(buffer, x_max - 4, y_min + 3, y_max - 10, makecol(0,0,0));
	set_trans_blender(0,0,0,25);
	vline(buffer, x_min + 4, y_min + 3, y_max - 10, makecol(0,0,0));
	vline(buffer, x_max - 5, y_min + 3, y_max - 10, makecol(0,0,0));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
	set_clip(buffer, 0, 0, buffer->w - 1, buffer->h - 1);
	
	add_rect(x_min, y_min, x_max, y_max);
	changed = false;
}



//===================   Obj_Prop_Window   ============================================


Obj_Prop_Window::Obj_Prop_Window(int ix_min, int iy_min, int ix_max, int iy_max)
{
	x_min = ix_min; x_max = ix_max;
	y_min = iy_min; y_max = iy_max;
	
	w_main = new WinThing(x_min, y_min, x_max, y_max);
	changed = true;
}

Obj_Prop_Window::~Obj_Prop_Window()
{
	delete w_main;
}

void Obj_Prop_Window::user_input()
{
}

void Obj_Prop_Window::draw()
{
	w_main->draw();

	add_rect(x_min, y_min, x_max, y_max);
	changed = false;
}


