/*
 *  DRS.cpp: Very basic Dirty Rectangle functions
 *  By Bjrn Lindeijer
 *
 *************************************************************************/

#include <list>
#include <allegro.h>
#include "Errors.h"
#include "DRS.h"

using namespace std;

bool vsync_on = false;
BITMAP *buffer;

list<DirtyRectangle> d_rects;


void DirtyRectangle::draw() const
{
	blit(buffer, screen, x, y, x, y, width, height);
}


void add_rect(int x_min, int y_min, int x_max, int y_max)
{
	if (!buffer) {init_DRS();}
	d_rects.push_back(DirtyRectangle(x_min, y_min, x_max - x_min + 1, y_max - y_min + 1));
}

void put_rects()
{
	if (!d_rects.empty()) {
		if (vsync_on) vsync();

		scare_mouse();
		acquire_screen();
		for (list<DirtyRectangle>::iterator di = d_rects.begin(); di != d_rects.end(); di++) di->draw();
		release_screen();
		unscare_mouse();

		d_rects.clear();
	}
}

void init_DRS()
{
	output_error(3, "Initializing dirty rectangle system...\n");

	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	clear(buffer);
}

void exit_DRS() {
	destroy_bitmap(buffer);
}
